<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMD_CouponDetail StructType
 * @subpackage Structs
 */
class EMD_CouponDetail extends AbstractStructBase
{
    /**
     * The Fare
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\FareBreakType
     */
    public $Fare;
    /**
     * The TaxBreak
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\TaxType[]
     */
    public $TaxBreak;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * The RFIC_SubCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RFIC_SubCode;
    /**
     * The AssociatedDocNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AssociatedDocNumber;
    /**
     * The AssociatedSegmentNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AssociatedSegmentNumber;
    /**
     * The ConsumedAtIssuanceInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConsumedAtIssuanceInd;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for EMD_CouponDetail
     * @uses EMD_CouponDetail::setFare()
     * @uses EMD_CouponDetail::setTaxBreak()
     * @uses EMD_CouponDetail::setRemarks()
     * @uses EMD_CouponDetail::setRFIC_SubCode()
     * @uses EMD_CouponDetail::setAssociatedDocNumber()
     * @uses EMD_CouponDetail::setAssociatedSegmentNumber()
     * @uses EMD_CouponDetail::setConsumedAtIssuanceInd()
     * @uses EMD_CouponDetail::setQuantity()
     * @param \SabrePaymentGateway\StructType\FareBreakType $fare
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @param string $remarks
     * @param string $rFIC_SubCode
     * @param string $associatedDocNumber
     * @param string $associatedSegmentNumber
     * @param string $consumedAtIssuanceInd
     * @param int $quantity
     */
    public function __construct(\SabrePaymentGateway\StructType\FareBreakType $fare = null, array $taxBreak = array(), $remarks = null, $rFIC_SubCode = null, $associatedDocNumber = null, $associatedSegmentNumber = null, $consumedAtIssuanceInd = null, $quantity = null)
    {
        $this
            ->setFare($fare)
            ->setTaxBreak($taxBreak)
            ->setRemarks($remarks)
            ->setRFIC_SubCode($rFIC_SubCode)
            ->setAssociatedDocNumber($associatedDocNumber)
            ->setAssociatedSegmentNumber($associatedSegmentNumber)
            ->setConsumedAtIssuanceInd($consumedAtIssuanceInd)
            ->setQuantity($quantity);
    }
    /**
     * Get Fare value
     * @return \SabrePaymentGateway\StructType\FareBreakType|null
     */
    public function getFare()
    {
        return $this->Fare;
    }
    /**
     * Set Fare value
     * @param \SabrePaymentGateway\StructType\FareBreakType $fare
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setFare(\SabrePaymentGateway\StructType\FareBreakType $fare = null)
    {
        $this->Fare = $fare;
        return $this;
    }
    /**
     * Get TaxBreak value
     * @return \SabrePaymentGateway\StructType\TaxType[]|null
     */
    public function getTaxBreak()
    {
        return $this->TaxBreak;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxBreak method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxBreak method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxBreakForArrayConstraintsFromSetTaxBreak(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $eMD_CouponDetailTaxBreakItem) {
            // validation for constraint: itemType
            if (!$eMD_CouponDetailTaxBreakItem instanceof \SabrePaymentGateway\StructType\TaxType) {
                $invalidValues[] = is_object($eMD_CouponDetailTaxBreakItem) ? get_class($eMD_CouponDetailTaxBreakItem) : sprintf('%s(%s)', gettype($eMD_CouponDetailTaxBreakItem), var_export($eMD_CouponDetailTaxBreakItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setTaxBreak(array $taxBreak = array())
    {
        // validation for constraint: array
        if ('' !== ($taxBreakArrayErrorMessage = self::validateTaxBreakForArrayConstraintsFromSetTaxBreak($taxBreak))) {
            throw new \InvalidArgumentException($taxBreakArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxBreak) && count($taxBreak) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxBreak)), __LINE__);
        }
        $this->TaxBreak = $taxBreak;
        return $this;
    }
    /**
     * Add item to TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType $item
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function addToTaxBreak(\SabrePaymentGateway\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TaxBreak) && count($this->TaxBreak) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TaxBreak)), __LINE__);
        }
        $this->TaxBreak[] = $item;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get RFIC_SubCode value
     * @return string|null
     */
    public function getRFIC_SubCode()
    {
        return $this->RFIC_SubCode;
    }
    /**
     * Set RFIC_SubCode value
     * @param string $rFIC_SubCode
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setRFIC_SubCode($rFIC_SubCode = null)
    {
        // validation for constraint: string
        if (!is_null($rFIC_SubCode) && !is_string($rFIC_SubCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFIC_SubCode, true), gettype($rFIC_SubCode)), __LINE__);
        }
        $this->RFIC_SubCode = $rFIC_SubCode;
        return $this;
    }
    /**
     * Get AssociatedDocNumber value
     * @return string|null
     */
    public function getAssociatedDocNumber()
    {
        return $this->AssociatedDocNumber;
    }
    /**
     * Set AssociatedDocNumber value
     * @param string $associatedDocNumber
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setAssociatedDocNumber($associatedDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDocNumber) && !is_string($associatedDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDocNumber, true), gettype($associatedDocNumber)), __LINE__);
        }
        $this->AssociatedDocNumber = $associatedDocNumber;
        return $this;
    }
    /**
     * Get AssociatedSegmentNumber value
     * @return string|null
     */
    public function getAssociatedSegmentNumber()
    {
        return $this->AssociatedSegmentNumber;
    }
    /**
     * Set AssociatedSegmentNumber value
     * @param string $associatedSegmentNumber
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setAssociatedSegmentNumber($associatedSegmentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($associatedSegmentNumber) && !is_string($associatedSegmentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedSegmentNumber, true), gettype($associatedSegmentNumber)), __LINE__);
        }
        $this->AssociatedSegmentNumber = $associatedSegmentNumber;
        return $this;
    }
    /**
     * Get ConsumedAtIssuanceInd value
     * @return string|null
     */
    public function getConsumedAtIssuanceInd()
    {
        return $this->ConsumedAtIssuanceInd;
    }
    /**
     * Set ConsumedAtIssuanceInd value
     * @param string $consumedAtIssuanceInd
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setConsumedAtIssuanceInd($consumedAtIssuanceInd = null)
    {
        // validation for constraint: string
        if (!is_null($consumedAtIssuanceInd) && !is_string($consumedAtIssuanceInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumedAtIssuanceInd, true), gettype($consumedAtIssuanceInd)), __LINE__);
        }
        $this->ConsumedAtIssuanceInd = $consumedAtIssuanceInd;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
