<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthorizationResult StructType
 * @subpackage Structs
 */
class AuthorizationResult extends AbstractStructBase
{
    /**
     * The AdditionalDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\NameValueType[]
     */
    public $AdditionalDetail;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseCode;
    /**
     * The ApprovalCode
     * @var string
     */
    public $ApprovalCode;
    /**
     * The AVS_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: AddressVerification Result Code as returned by CC vendor.
     * @var string
     */
    public $AVS_ResultCode;
    /**
     * The CSC_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: CardSecurityCode verification result code: I: Card verification number failed processor's data validation check. M: Card verification number matched. N: Card verification number not matched. P: Card verification number not processed.
     * S: Card verification number is on the card but was not included in the request. U: Card verification is not supported by the issuing bank. X: Card verification is not supported by the card association. 1: CyberSource does not support card
     * verification for this processor or card type. 2: The processor returned an unrecognized value for the card verification response. 3: The processor did not return a card verification result code.
     * @var string
     */
    public $CSC_ResultCode;
    /**
     * The CAVV_ResultCode
     * @var string
     */
    public $CAVV_ResultCode;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierReferenceID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierReferenceID;
    /**
     * The SupplierFOP_Code
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierFOP_Code;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The MerchantAccountNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MerchantAccountNumber;
    /**
     * The FailedCount
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $FailedCount;
    /**
     * The NetworkTransactionReference
     * Meta information extracted from the WSDL
     * - documentation: Transaction ID that supports merchant-initiated transaction (MIT) exemptions
     * - use: optional
     * @var string
     */
    public $NetworkTransactionReference;
    /**
     * Constructor method for AuthorizationResult
     * @uses AuthorizationResult::setAdditionalDetail()
     * @uses AuthorizationResult::setResponseCode()
     * @uses AuthorizationResult::setApprovalCode()
     * @uses AuthorizationResult::setAVS_ResultCode()
     * @uses AuthorizationResult::setCSC_ResultCode()
     * @uses AuthorizationResult::setCAVV_ResultCode()
     * @uses AuthorizationResult::setSupplierID()
     * @uses AuthorizationResult::setSupplierTransID()
     * @uses AuthorizationResult::setSupplierReferenceID()
     * @uses AuthorizationResult::setSupplierFOP_Code()
     * @uses AuthorizationResult::setSupplierResponseCode()
     * @uses AuthorizationResult::setMerchantAccountNumber()
     * @uses AuthorizationResult::setFailedCount()
     * @uses AuthorizationResult::setNetworkTransactionReference()
     * @param \SabrePaymentGateway\StructType\NameValueType[] $additionalDetail
     * @param string $responseCode
     * @param string $approvalCode
     * @param string $aVS_ResultCode
     * @param string $cSC_ResultCode
     * @param string $cAVV_ResultCode
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $supplierReferenceID
     * @param string $supplierFOP_Code
     * @param string $supplierResponseCode
     * @param string $merchantAccountNumber
     * @param int $failedCount
     * @param string $networkTransactionReference
     */
    public function __construct(array $additionalDetail = array(), $responseCode = null, $approvalCode = null, $aVS_ResultCode = null, $cSC_ResultCode = null, $cAVV_ResultCode = null, $supplierID = null, $supplierTransID = null, $supplierReferenceID = null, $supplierFOP_Code = null, $supplierResponseCode = null, $merchantAccountNumber = null, $failedCount = null, $networkTransactionReference = null)
    {
        $this
            ->setAdditionalDetail($additionalDetail)
            ->setResponseCode($responseCode)
            ->setApprovalCode($approvalCode)
            ->setAVS_ResultCode($aVS_ResultCode)
            ->setCSC_ResultCode($cSC_ResultCode)
            ->setCAVV_ResultCode($cAVV_ResultCode)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierReferenceID($supplierReferenceID)
            ->setSupplierFOP_Code($supplierFOP_Code)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setMerchantAccountNumber($merchantAccountNumber)
            ->setFailedCount($failedCount)
            ->setNetworkTransactionReference($networkTransactionReference);
    }
    /**
     * Get AdditionalDetail value
     * @return \SabrePaymentGateway\StructType\NameValueType[]|null
     */
    public function getAdditionalDetail()
    {
        return $this->AdditionalDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalDetailForArrayConstraintsFromSetAdditionalDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $authorizationResultAdditionalDetailItem) {
            // validation for constraint: itemType
            if (!$authorizationResultAdditionalDetailItem instanceof \SabrePaymentGateway\StructType\NameValueType) {
                $invalidValues[] = is_object($authorizationResultAdditionalDetailItem) ? get_class($authorizationResultAdditionalDetailItem) : sprintf('%s(%s)', gettype($authorizationResultAdditionalDetailItem), var_export($authorizationResultAdditionalDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalDetail property can only contain items of type \SabrePaymentGateway\StructType\NameValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\NameValueType[] $additionalDetail
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setAdditionalDetail(array $additionalDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalDetailArrayErrorMessage = self::validateAdditionalDetailForArrayConstraintsFromSetAdditionalDetail($additionalDetail))) {
            throw new \InvalidArgumentException($additionalDetailArrayErrorMessage, __LINE__);
        }
        $this->AdditionalDetail = $additionalDetail;
        return $this;
    }
    /**
     * Add item to AdditionalDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\NameValueType $item
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function addToAdditionalDetail(\SabrePaymentGateway\StructType\NameValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\NameValueType) {
            throw new \InvalidArgumentException(sprintf('The AdditionalDetail property can only contain items of type \SabrePaymentGateway\StructType\NameValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalDetail[] = $item;
        return $this;
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get AVS_ResultCode value
     * @return string|null
     */
    public function getAVS_ResultCode()
    {
        return $this->AVS_ResultCode;
    }
    /**
     * Set AVS_ResultCode value
     * @param string $aVS_ResultCode
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setAVS_ResultCode($aVS_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($aVS_ResultCode) && !is_string($aVS_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVS_ResultCode, true), gettype($aVS_ResultCode)), __LINE__);
        }
        $this->AVS_ResultCode = $aVS_ResultCode;
        return $this;
    }
    /**
     * Get CSC_ResultCode value
     * @return string|null
     */
    public function getCSC_ResultCode()
    {
        return $this->CSC_ResultCode;
    }
    /**
     * Set CSC_ResultCode value
     * @param string $cSC_ResultCode
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setCSC_ResultCode($cSC_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cSC_ResultCode) && !is_string($cSC_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSC_ResultCode, true), gettype($cSC_ResultCode)), __LINE__);
        }
        $this->CSC_ResultCode = $cSC_ResultCode;
        return $this;
    }
    /**
     * Get CAVV_ResultCode value
     * @return string|null
     */
    public function getCAVV_ResultCode()
    {
        return $this->CAVV_ResultCode;
    }
    /**
     * Set CAVV_ResultCode value
     * @param string $cAVV_ResultCode
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setCAVV_ResultCode($cAVV_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV_ResultCode) && !is_string($cAVV_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV_ResultCode, true), gettype($cAVV_ResultCode)), __LINE__);
        }
        $this->CAVV_ResultCode = $cAVV_ResultCode;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierReferenceID value
     * @return string|null
     */
    public function getSupplierReferenceID()
    {
        return $this->SupplierReferenceID;
    }
    /**
     * Set SupplierReferenceID value
     * @param string $supplierReferenceID
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setSupplierReferenceID($supplierReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReferenceID) && !is_string($supplierReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierReferenceID, true), gettype($supplierReferenceID)), __LINE__);
        }
        $this->SupplierReferenceID = $supplierReferenceID;
        return $this;
    }
    /**
     * Get SupplierFOP_Code value
     * @return string|null
     */
    public function getSupplierFOP_Code()
    {
        return $this->SupplierFOP_Code;
    }
    /**
     * Set SupplierFOP_Code value
     * @param string $supplierFOP_Code
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setSupplierFOP_Code($supplierFOP_Code = null)
    {
        // validation for constraint: string
        if (!is_null($supplierFOP_Code) && !is_string($supplierFOP_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierFOP_Code, true), gettype($supplierFOP_Code)), __LINE__);
        }
        $this->SupplierFOP_Code = $supplierFOP_Code;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get MerchantAccountNumber value
     * @return string|null
     */
    public function getMerchantAccountNumber()
    {
        return $this->MerchantAccountNumber;
    }
    /**
     * Set MerchantAccountNumber value
     * @param string $merchantAccountNumber
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setMerchantAccountNumber($merchantAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccountNumber) && !is_string($merchantAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccountNumber, true), gettype($merchantAccountNumber)), __LINE__);
        }
        $this->MerchantAccountNumber = $merchantAccountNumber;
        return $this;
    }
    /**
     * Get FailedCount value
     * @return int|null
     */
    public function getFailedCount()
    {
        return $this->FailedCount;
    }
    /**
     * Set FailedCount value
     * @param int $failedCount
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setFailedCount($failedCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedCount) && !(is_int($failedCount) || ctype_digit($failedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedCount, true), gettype($failedCount)), __LINE__);
        }
        $this->FailedCount = $failedCount;
        return $this;
    }
    /**
     * Get NetworkTransactionReference value
     * @return string|null
     */
    public function getNetworkTransactionReference()
    {
        return $this->NetworkTransactionReference;
    }
    /**
     * Set NetworkTransactionReference value
     * @param string $networkTransactionReference
     * @return \SabrePaymentGateway\StructType\AuthorizationResult
     */
    public function setNetworkTransactionReference($networkTransactionReference = null)
    {
        // validation for constraint: string
        if (!is_null($networkTransactionReference) && !is_string($networkTransactionReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkTransactionReference, true), gettype($networkTransactionReference)), __LINE__);
        }
        $this->NetworkTransactionReference = $networkTransactionReference;
        return $this;
    }
}
