<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for T3DS_AuthenticationResultType StructType
 * @subpackage Structs
 */
class T3DS_AuthenticationResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - documentation: 3DS Response Code: AUTHENTICATION_SUCCESSFUL: Authentication Successful AUTHENTICATION_ATTEMPTED: Authentication attempted MEMBER_NOT_ENROLLED: Card is not enrolled in 3DS UNABLE_TO_AUTHENTICATE: Unable to authenticate
     * AUTHENTICATION_FAILED: Authentication failed INVALID_AUTHENTICATION: Invalid authentication ENROLLMENT_VENDOR_TIMEOUT: 3DS vendor timeout ENROLLMENT_SYSTEM_ERROR: Internal/external processing error ENROLLMENT_VENDOR_ERROR: External processing error
     * ACS_VENDOR_TIMEOUT: Access Control Server (ACS) timeout ACS_SYSTEM_ERROR: Access Control Server (ACS) processing error ACS_VENDOR_ERROR: Access Control Server (ACS) vendor error
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The T3DS_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\T3DS_Result
     */
    public $T3DS_Result;
    /**
     * The RedirectHTML
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RedirectHTML;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - documentation: Supplier/Vendor ID e.g. CS
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - documentation: 3DS Supplier/Vendor Response Code
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - documentation: Payment Web Services (PWS) Payment Reference Number
     * - use: optional
     * @var string
     */
    public $PaymentRef;
    /**
     * Constructor method for T3DS_AuthenticationResultType
     * @uses T3DS_AuthenticationResultType::setResponseCode()
     * @uses T3DS_AuthenticationResultType::setT3DS_Result()
     * @uses T3DS_AuthenticationResultType::setRedirectHTML()
     * @uses T3DS_AuthenticationResultType::setDescription()
     * @uses T3DS_AuthenticationResultType::setSupplierID()
     * @uses T3DS_AuthenticationResultType::setSupplierResponseCode()
     * @uses T3DS_AuthenticationResultType::setPaymentRef()
     * @param string $responseCode
     * @param \SabrePaymentGateway\StructType\T3DS_Result $t3DS_Result
     * @param string $redirectHTML
     * @param string $description
     * @param string $supplierID
     * @param string $supplierResponseCode
     * @param string $paymentRef
     */
    public function __construct($responseCode = null, \SabrePaymentGateway\StructType\T3DS_Result $t3DS_Result = null, $redirectHTML = null, $description = null, $supplierID = null, $supplierResponseCode = null, $paymentRef = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setT3DS_Result($t3DS_Result)
            ->setRedirectHTML($redirectHTML)
            ->setDescription($description)
            ->setSupplierID($supplierID)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setPaymentRef($paymentRef);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\T3DS_AuthenticationResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get T3DS_Result value
     * @return \SabrePaymentGateway\StructType\T3DS_Result|null
     */
    public function getT3DS_Result()
    {
        return $this->T3DS_Result;
    }
    /**
     * Set T3DS_Result value
     * @param \SabrePaymentGateway\StructType\T3DS_Result $t3DS_Result
     * @return \SabrePaymentGateway\StructType\T3DS_AuthenticationResultType
     */
    public function setT3DS_Result(\SabrePaymentGateway\StructType\T3DS_Result $t3DS_Result = null)
    {
        $this->T3DS_Result = $t3DS_Result;
        return $this;
    }
    /**
     * Get RedirectHTML value
     * @return string|null
     */
    public function getRedirectHTML()
    {
        return $this->RedirectHTML;
    }
    /**
     * Set RedirectHTML value
     * @param string $redirectHTML
     * @return \SabrePaymentGateway\StructType\T3DS_AuthenticationResultType
     */
    public function setRedirectHTML($redirectHTML = null)
    {
        // validation for constraint: string
        if (!is_null($redirectHTML) && !is_string($redirectHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectHTML, true), gettype($redirectHTML)), __LINE__);
        }
        $this->RedirectHTML = $redirectHTML;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\T3DS_AuthenticationResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\T3DS_AuthenticationResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \SabrePaymentGateway\StructType\T3DS_AuthenticationResultType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \SabrePaymentGateway\StructType\T3DS_AuthenticationResultType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
}
