<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterAuthResultType StructType
 * @subpackage Structs
 */
class RegisterAuthResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The LocalCardDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\LocalCardDetail
     */
    public $LocalCardDetail;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarksType
     */
    public $Remarks;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentRef;
    /**
     * The CSC_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: CardSecurityCode verification result code: I: Card verification number failed processor's data validation check. M: Card verification number matched. N: Card verification number not matched. P: Card verification number not processed.
     * S: Card verification number is on the card but was not included in the request. U: Card verification is not supported by the issuing bank. X: Card verification is not supported by the card association.
     * - use: optional
     * @var string
     */
    public $CSC_ResultCode;
    /**
     * The AVS_ResultCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AVS_ResultCode;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * Constructor method for RegisterAuthResultType
     * @uses RegisterAuthResultType::setResponseCode()
     * @uses RegisterAuthResultType::setLocalCardDetail()
     * @uses RegisterAuthResultType::setRemarks()
     * @uses RegisterAuthResultType::setPaymentRef()
     * @uses RegisterAuthResultType::setCSC_ResultCode()
     * @uses RegisterAuthResultType::setAVS_ResultCode()
     * @uses RegisterAuthResultType::setApprovalCode()
     * @uses RegisterAuthResultType::setSupplierTransID()
     * @param string $responseCode
     * @param \SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail
     * @param \SabrePaymentGateway\StructType\RemarksType $remarks
     * @param string $paymentRef
     * @param string $cSC_ResultCode
     * @param string $aVS_ResultCode
     * @param string $approvalCode
     * @param string $supplierTransID
     */
    public function __construct($responseCode = null, \SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail = null, \SabrePaymentGateway\StructType\RemarksType $remarks = null, $paymentRef = null, $cSC_ResultCode = null, $aVS_ResultCode = null, $approvalCode = null, $supplierTransID = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setLocalCardDetail($localCardDetail)
            ->setRemarks($remarks)
            ->setPaymentRef($paymentRef)
            ->setCSC_ResultCode($cSC_ResultCode)
            ->setAVS_ResultCode($aVS_ResultCode)
            ->setApprovalCode($approvalCode)
            ->setSupplierTransID($supplierTransID);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get LocalCardDetail value
     * @return \SabrePaymentGateway\StructType\LocalCardDetail|null
     */
    public function getLocalCardDetail()
    {
        return $this->LocalCardDetail;
    }
    /**
     * Set LocalCardDetail value
     * @param \SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setLocalCardDetail(\SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail = null)
    {
        $this->LocalCardDetail = $localCardDetail;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \SabrePaymentGateway\StructType\RemarksType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \SabrePaymentGateway\StructType\RemarksType $remarks
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setRemarks(\SabrePaymentGateway\StructType\RemarksType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get CSC_ResultCode value
     * @return string|null
     */
    public function getCSC_ResultCode()
    {
        return $this->CSC_ResultCode;
    }
    /**
     * Set CSC_ResultCode value
     * @param string $cSC_ResultCode
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setCSC_ResultCode($cSC_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cSC_ResultCode) && !is_string($cSC_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cSC_ResultCode, true), gettype($cSC_ResultCode)), __LINE__);
        }
        $this->CSC_ResultCode = $cSC_ResultCode;
        return $this;
    }
    /**
     * Get AVS_ResultCode value
     * @return string|null
     */
    public function getAVS_ResultCode()
    {
        return $this->AVS_ResultCode;
    }
    /**
     * Set AVS_ResultCode value
     * @param string $aVS_ResultCode
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setAVS_ResultCode($aVS_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($aVS_ResultCode) && !is_string($aVS_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aVS_ResultCode, true), gettype($aVS_ResultCode)), __LINE__);
        }
        $this->AVS_ResultCode = $aVS_ResultCode;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \SabrePaymentGateway\StructType\RegisterAuthResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
}
