<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Passenger detail
 * @subpackage Structs
 */
class ProductDetailType extends AbstractStructBase
{
    /**
     * The ProductID
     * Meta information extracted from the WSDL
     * - documentation: 0001 – Air Booking (default) 0002 – Hotel Booking 0003 – Car Rental 0004 – Travel Package 0005 - Insurance 0006 - Rail 1000 - PTA 1001 - MSR 1002 - EXB 1003 - Voucher 1004 - Ancillaries (EMD) 2000 - Service Fee 9999 - Other
     * - use: optional
     * @var string
     */
    public $ProductID;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProductName;
    /**
     * The ProductCategoryCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProductCategoryCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - documentation: 3 alpha ISO 4217
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The UnitPrice
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $UnitPrice;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Fees;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TourCode;
    /**
     * The OriginCity
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $OriginCity;
    /**
     * The DestinationCity
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $DestinationCity;
    /**
     * Constructor method for ProductDetailType
     * @uses ProductDetailType::setProductID()
     * @uses ProductDetailType::setProductName()
     * @uses ProductDetailType::setProductCategoryCode()
     * @uses ProductDetailType::setCurrencyCode()
     * @uses ProductDetailType::setUnitPrice()
     * @uses ProductDetailType::setTaxes()
     * @uses ProductDetailType::setFees()
     * @uses ProductDetailType::setQuantity()
     * @uses ProductDetailType::setTourCode()
     * @uses ProductDetailType::setOriginCity()
     * @uses ProductDetailType::setDestinationCity()
     * @param string $productID
     * @param string $productName
     * @param string $productCategoryCode
     * @param string $currencyCode
     * @param float $unitPrice
     * @param float $taxes
     * @param float $fees
     * @param int $quantity
     * @param string $tourCode
     * @param string $originCity
     * @param string $destinationCity
     */
    public function __construct($productID = null, $productName = null, $productCategoryCode = null, $currencyCode = null, $unitPrice = null, $taxes = null, $fees = null, $quantity = null, $tourCode = null, $originCity = null, $destinationCity = null)
    {
        $this
            ->setProductID($productID)
            ->setProductName($productName)
            ->setProductCategoryCode($productCategoryCode)
            ->setCurrencyCode($currencyCode)
            ->setUnitPrice($unitPrice)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setQuantity($quantity)
            ->setTourCode($tourCode)
            ->setOriginCity($originCity)
            ->setDestinationCity($destinationCity);
    }
    /**
     * Get ProductID value
     * @return string|null
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param string $productID
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: string
        if (!is_null($productID) && !is_string($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productID, true), gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductCategoryCode value
     * @return string|null
     */
    public function getProductCategoryCode()
    {
        return $this->ProductCategoryCode;
    }
    /**
     * Set ProductCategoryCode value
     * @param string $productCategoryCode
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setProductCategoryCode($productCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($productCategoryCode) && !is_string($productCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCategoryCode, true), gettype($productCategoryCode)), __LINE__);
        }
        $this->ProductCategoryCode = $productCategoryCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get UnitPrice value
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->UnitPrice;
    }
    /**
     * Set UnitPrice value
     * @param float $unitPrice
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setUnitPrice($unitPrice = null)
    {
        // validation for constraint: float
        if (!is_null($unitPrice) && !(is_float($unitPrice) || is_numeric($unitPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unitPrice, true), gettype($unitPrice)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($unitPrice) && mb_strlen(mb_substr($unitPrice, false !== mb_strpos($unitPrice, '.') ? mb_strpos($unitPrice, '.') + 1 : mb_strlen($unitPrice))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($unitPrice, true), mb_strlen(mb_substr($unitPrice, mb_strpos($unitPrice, '.') + 1))), __LINE__);
        }
        $this->UnitPrice = $unitPrice;
        return $this;
    }
    /**
     * Get Taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param float $taxes
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setTaxes($taxes = null)
    {
        // validation for constraint: float
        if (!is_null($taxes) && !(is_float($taxes) || is_numeric($taxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxes, true), gettype($taxes)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($taxes) && mb_strlen(mb_substr($taxes, false !== mb_strpos($taxes, '.') ? mb_strpos($taxes, '.') + 1 : mb_strlen($taxes))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($taxes, true), mb_strlen(mb_substr($taxes, mb_strpos($taxes, '.') + 1))), __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return float|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param float $fees
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setFees($fees = null)
    {
        // validation for constraint: float
        if (!is_null($fees) && !(is_float($fees) || is_numeric($fees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fees, true), gettype($fees)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fees) && mb_strlen(mb_substr($fees, false !== mb_strpos($fees, '.') ? mb_strpos($fees, '.') + 1 : mb_strlen($fees))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fees, true), mb_strlen(mb_substr($fees, mb_strpos($fees, '.') + 1))), __LINE__);
        }
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get OriginCity value
     * @return string|null
     */
    public function getOriginCity()
    {
        return $this->OriginCity;
    }
    /**
     * Set OriginCity value
     * @param string $originCity
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setOriginCity($originCity = null)
    {
        // validation for constraint: string
        if (!is_null($originCity) && !is_string($originCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originCity, true), gettype($originCity)), __LINE__);
        }
        $this->OriginCity = $originCity;
        return $this;
    }
    /**
     * Get DestinationCity value
     * @return string|null
     */
    public function getDestinationCity()
    {
        return $this->DestinationCity;
    }
    /**
     * Set DestinationCity value
     * @param string $destinationCity
     * @return \SabrePaymentGateway\StructType\ProductDetailType
     */
    public function setDestinationCity($destinationCity = null)
    {
        // validation for constraint: string
        if (!is_null($destinationCity) && !is_string($destinationCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationCity, true), gettype($destinationCity)), __LINE__);
        }
        $this->DestinationCity = $destinationCity;
        return $this;
    }
}
