<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValueType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class KeyValueType extends AbstractStructBase
{
    /**
     * The DSAKeyValue
     * Meta information extracted from the WSDL
     * - choice: DSAKeyValue | RSAKeyValue |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: ds:DSAKeyValue
     * @var \SabrePaymentGateway\StructType\DSAKeyValueType
     */
    public $DSAKeyValue;
    /**
     * The RSAKeyValue
     * Meta information extracted from the WSDL
     * - choice: DSAKeyValue | RSAKeyValue |
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - ref: ds:RSAKeyValue
     * @var \SabrePaymentGateway\StructType\RSAKeyValueType
     */
    public $RSAKeyValue;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for KeyValueType
     * @uses KeyValueType::setDSAKeyValue()
     * @uses KeyValueType::setRSAKeyValue()
     * @uses KeyValueType::setAny()
     * @param \SabrePaymentGateway\StructType\DSAKeyValueType $dSAKeyValue
     * @param \SabrePaymentGateway\StructType\RSAKeyValueType $rSAKeyValue
     * @param \DOMDocument $any
     */
    public function __construct(\SabrePaymentGateway\StructType\DSAKeyValueType $dSAKeyValue = null, \SabrePaymentGateway\StructType\RSAKeyValueType $rSAKeyValue = null, \DOMDocument $any = null)
    {
        $this
            ->setDSAKeyValue($dSAKeyValue)
            ->setRSAKeyValue($rSAKeyValue)
            ->setAny($any);
    }
    /**
     * Get DSAKeyValue value
     * @return \SabrePaymentGateway\StructType\DSAKeyValueType|null
     */
    public function getDSAKeyValue()
    {
        return isset($this->DSAKeyValue) ? $this->DSAKeyValue : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDSAKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDSAKeyValue method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDSAKeyValueForChoiceConstraintsFromSetDSAKeyValue($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'RSAKeyValue',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property DSAKeyValue can\'t be set as the property %s is already set. Only one property must be set among these properties: DSAKeyValue, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set DSAKeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\DSAKeyValueType $dSAKeyValue
     * @return \SabrePaymentGateway\StructType\KeyValueType
     */
    public function setDSAKeyValue(\SabrePaymentGateway\StructType\DSAKeyValueType $dSAKeyValue = null)
    {
        // validation for constraint: choice(DSAKeyValue, RSAKeyValue, )
        if ('' !== ($dSAKeyValueChoiceErrorMessage = self::validateDSAKeyValueForChoiceConstraintsFromSetDSAKeyValue($dSAKeyValue))) {
            throw new \InvalidArgumentException($dSAKeyValueChoiceErrorMessage, __LINE__);
        }
        if (is_null($dSAKeyValue) || (is_array($dSAKeyValue) && empty($dSAKeyValue))) {
            unset($this->DSAKeyValue);
        } else {
            $this->DSAKeyValue = $dSAKeyValue;
        }
        return $this;
    }
    /**
     * Get RSAKeyValue value
     * @return \SabrePaymentGateway\StructType\RSAKeyValueType|null
     */
    public function getRSAKeyValue()
    {
        return isset($this->RSAKeyValue) ? $this->RSAKeyValue : null;
    }
    /**
     * This method is responsible for validating the value passed to the setRSAKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRSAKeyValue method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateRSAKeyValueForChoiceConstraintsFromSetRSAKeyValue($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'DSAKeyValue',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property RSAKeyValue can\'t be set as the property %s is already set. Only one property must be set among these properties: RSAKeyValue, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set RSAKeyValue value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\RSAKeyValueType $rSAKeyValue
     * @return \SabrePaymentGateway\StructType\KeyValueType
     */
    public function setRSAKeyValue(\SabrePaymentGateway\StructType\RSAKeyValueType $rSAKeyValue = null)
    {
        // validation for constraint: choice(DSAKeyValue, RSAKeyValue, )
        if ('' !== ($rSAKeyValueChoiceErrorMessage = self::validateRSAKeyValueForChoiceConstraintsFromSetRSAKeyValue($rSAKeyValue))) {
            throw new \InvalidArgumentException($rSAKeyValueChoiceErrorMessage, __LINE__);
        }
        if (is_null($rSAKeyValue) || (is_array($rSAKeyValue) && empty($rSAKeyValue))) {
            unset($this->RSAKeyValue);
        } else {
            $this->RSAKeyValue = $rSAKeyValue;
        }
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\KeyValueType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
}
