<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight detail
 * @subpackage Structs
 */
class FlightDetailType extends AbstractStructBase
{
    /**
     * The AirlineCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AirlineCode;
    /**
     * The OperatingAirlineCode
     * Meta information extracted from the WSDL
     * - documentation: For codeshare flight.
     * - minOccurs: 0
     * @var string
     */
    public $OperatingAirlineCode;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: 1 - 4 digits flight number or OPEN or ARNK
     * - minOccurs: 0
     * @var string
     */
    public $FlightNumber;
    /**
     * The ClassOfService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ClassOfService;
    /**
     * The DepartureInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\DepartureInfo
     */
    public $DepartureInfo;
    /**
     * The ArrivalInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\ArrivalInfo
     */
    public $ArrivalInfo;
    /**
     * The DocNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DocNumber;
    /**
     * The FareBasisCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FareBasisCode;
    /**
     * The TicketDesignator
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TicketDesignator;
    /**
     * The ReturnFlightInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReturnFlightInd;
    /**
     * The PNR_SegmentNbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $PNR_SegmentNbr;
    /**
     * The ConnectingFlightInd
     * Meta information extracted from the WSDL
     * - documentation: 'X' - Transit, 'O' - Stopover
     * - use: optional
     * @var string
     */
    public $ConnectingFlightInd;
    /**
     * The CouponUseIndicator
     * Meta information extracted from the WSDL
     * - documentation: 'F' - Flight, 'S' - Surface
     * - use: optional
     * @var string
     */
    public $CouponUseIndicator;
    /**
     * Constructor method for FlightDetailType
     * @uses FlightDetailType::setAirlineCode()
     * @uses FlightDetailType::setOperatingAirlineCode()
     * @uses FlightDetailType::setFlightNumber()
     * @uses FlightDetailType::setClassOfService()
     * @uses FlightDetailType::setDepartureInfo()
     * @uses FlightDetailType::setArrivalInfo()
     * @uses FlightDetailType::setDocNumber()
     * @uses FlightDetailType::setFareBasisCode()
     * @uses FlightDetailType::setTicketDesignator()
     * @uses FlightDetailType::setReturnFlightInd()
     * @uses FlightDetailType::setPNR_SegmentNbr()
     * @uses FlightDetailType::setConnectingFlightInd()
     * @uses FlightDetailType::setCouponUseIndicator()
     * @param string $airlineCode
     * @param string $operatingAirlineCode
     * @param string $flightNumber
     * @param string $classOfService
     * @param \SabrePaymentGateway\StructType\DepartureInfo $departureInfo
     * @param \SabrePaymentGateway\StructType\ArrivalInfo $arrivalInfo
     * @param string $docNumber
     * @param string $fareBasisCode
     * @param string $ticketDesignator
     * @param bool $returnFlightInd
     * @param int $pNR_SegmentNbr
     * @param string $connectingFlightInd
     * @param string $couponUseIndicator
     */
    public function __construct($airlineCode = null, $operatingAirlineCode = null, $flightNumber = null, $classOfService = null, \SabrePaymentGateway\StructType\DepartureInfo $departureInfo = null, \SabrePaymentGateway\StructType\ArrivalInfo $arrivalInfo = null, $docNumber = null, $fareBasisCode = null, $ticketDesignator = null, $returnFlightInd = null, $pNR_SegmentNbr = null, $connectingFlightInd = null, $couponUseIndicator = null)
    {
        $this
            ->setAirlineCode($airlineCode)
            ->setOperatingAirlineCode($operatingAirlineCode)
            ->setFlightNumber($flightNumber)
            ->setClassOfService($classOfService)
            ->setDepartureInfo($departureInfo)
            ->setArrivalInfo($arrivalInfo)
            ->setDocNumber($docNumber)
            ->setFareBasisCode($fareBasisCode)
            ->setTicketDesignator($ticketDesignator)
            ->setReturnFlightInd($returnFlightInd)
            ->setPNR_SegmentNbr($pNR_SegmentNbr)
            ->setConnectingFlightInd($connectingFlightInd)
            ->setCouponUseIndicator($couponUseIndicator);
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineCode, true), gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get OperatingAirlineCode value
     * @return string|null
     */
    public function getOperatingAirlineCode()
    {
        return $this->OperatingAirlineCode;
    }
    /**
     * Set OperatingAirlineCode value
     * @param string $operatingAirlineCode
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setOperatingAirlineCode($operatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingAirlineCode) && !is_string($operatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingAirlineCode, true), gettype($operatingAirlineCode)), __LINE__);
        }
        $this->OperatingAirlineCode = $operatingAirlineCode;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param string $flightNumber
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return string|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param string $classOfService
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setClassOfService($classOfService = null)
    {
        // validation for constraint: string
        if (!is_null($classOfService) && !is_string($classOfService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classOfService, true), gettype($classOfService)), __LINE__);
        }
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get DepartureInfo value
     * @return \SabrePaymentGateway\StructType\DepartureInfo|null
     */
    public function getDepartureInfo()
    {
        return $this->DepartureInfo;
    }
    /**
     * Set DepartureInfo value
     * @param \SabrePaymentGateway\StructType\DepartureInfo $departureInfo
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setDepartureInfo(\SabrePaymentGateway\StructType\DepartureInfo $departureInfo = null)
    {
        $this->DepartureInfo = $departureInfo;
        return $this;
    }
    /**
     * Get ArrivalInfo value
     * @return \SabrePaymentGateway\StructType\ArrivalInfo|null
     */
    public function getArrivalInfo()
    {
        return $this->ArrivalInfo;
    }
    /**
     * Set ArrivalInfo value
     * @param \SabrePaymentGateway\StructType\ArrivalInfo $arrivalInfo
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setArrivalInfo(\SabrePaymentGateway\StructType\ArrivalInfo $arrivalInfo = null)
    {
        $this->ArrivalInfo = $arrivalInfo;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get FareBasisCode value
     * @return string|null
     */
    public function getFareBasisCode()
    {
        return $this->FareBasisCode;
    }
    /**
     * Set FareBasisCode value
     * @param string $fareBasisCode
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setFareBasisCode($fareBasisCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasisCode) && !is_string($fareBasisCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasisCode, true), gettype($fareBasisCode)), __LINE__);
        }
        $this->FareBasisCode = $fareBasisCode;
        return $this;
    }
    /**
     * Get TicketDesignator value
     * @return string|null
     */
    public function getTicketDesignator()
    {
        return $this->TicketDesignator;
    }
    /**
     * Set TicketDesignator value
     * @param string $ticketDesignator
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setTicketDesignator($ticketDesignator = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDesignator) && !is_string($ticketDesignator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDesignator, true), gettype($ticketDesignator)), __LINE__);
        }
        $this->TicketDesignator = $ticketDesignator;
        return $this;
    }
    /**
     * Get ReturnFlightInd value
     * @return bool|null
     */
    public function getReturnFlightInd()
    {
        return $this->ReturnFlightInd;
    }
    /**
     * Set ReturnFlightInd value
     * @param bool $returnFlightInd
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setReturnFlightInd($returnFlightInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnFlightInd) && !is_bool($returnFlightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnFlightInd, true), gettype($returnFlightInd)), __LINE__);
        }
        $this->ReturnFlightInd = $returnFlightInd;
        return $this;
    }
    /**
     * Get PNR_SegmentNbr value
     * @return int|null
     */
    public function getPNR_SegmentNbr()
    {
        return $this->PNR_SegmentNbr;
    }
    /**
     * Set PNR_SegmentNbr value
     * @param int $pNR_SegmentNbr
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setPNR_SegmentNbr($pNR_SegmentNbr = null)
    {
        // validation for constraint: int
        if (!is_null($pNR_SegmentNbr) && !(is_int($pNR_SegmentNbr) || ctype_digit($pNR_SegmentNbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pNR_SegmentNbr, true), gettype($pNR_SegmentNbr)), __LINE__);
        }
        $this->PNR_SegmentNbr = $pNR_SegmentNbr;
        return $this;
    }
    /**
     * Get ConnectingFlightInd value
     * @return string|null
     */
    public function getConnectingFlightInd()
    {
        return $this->ConnectingFlightInd;
    }
    /**
     * Set ConnectingFlightInd value
     * @param string $connectingFlightInd
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setConnectingFlightInd($connectingFlightInd = null)
    {
        // validation for constraint: string
        if (!is_null($connectingFlightInd) && !is_string($connectingFlightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectingFlightInd, true), gettype($connectingFlightInd)), __LINE__);
        }
        $this->ConnectingFlightInd = $connectingFlightInd;
        return $this;
    }
    /**
     * Get CouponUseIndicator value
     * @return string|null
     */
    public function getCouponUseIndicator()
    {
        return $this->CouponUseIndicator;
    }
    /**
     * Set CouponUseIndicator value
     * @param string $couponUseIndicator
     * @return \SabrePaymentGateway\StructType\FlightDetailType
     */
    public function setCouponUseIndicator($couponUseIndicator = null)
    {
        // validation for constraint: string
        if (!is_null($couponUseIndicator) && !is_string($couponUseIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponUseIndicator, true), gettype($couponUseIndicator)), __LINE__);
        }
        $this->CouponUseIndicator = $couponUseIndicator;
        return $this;
    }
}
