<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareBreakType StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides a monetary amount and the code of the currency in which this amount is expressed.
 * @subpackage Structs
 */
class FareBreakType extends AbstractStructBase
{
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BaseFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Fees;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The EquivalentBaseFare
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $EquivalentBaseFare;
    /**
     * The EquivalentCurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EquivalentCurrencyCode;
    /**
     * Constructor method for FareBreakType
     * @uses FareBreakType::setBaseFare()
     * @uses FareBreakType::setTaxes()
     * @uses FareBreakType::setFees()
     * @uses FareBreakType::setCurrencyCode()
     * @uses FareBreakType::setEquivalentBaseFare()
     * @uses FareBreakType::setEquivalentCurrencyCode()
     * @param float $baseFare
     * @param float $taxes
     * @param float $fees
     * @param string $currencyCode
     * @param float $equivalentBaseFare
     * @param string $equivalentCurrencyCode
     */
    public function __construct($baseFare = null, $taxes = null, $fees = null, $currencyCode = null, $equivalentBaseFare = null, $equivalentCurrencyCode = null)
    {
        $this
            ->setBaseFare($baseFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setCurrencyCode($currencyCode)
            ->setEquivalentBaseFare($equivalentBaseFare)
            ->setEquivalentCurrencyCode($equivalentCurrencyCode);
    }
    /**
     * Get BaseFare value
     * @return float|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param float $baseFare
     * @return \SabrePaymentGateway\StructType\FareBreakType
     */
    public function setBaseFare($baseFare = null)
    {
        // validation for constraint: float
        if (!is_null($baseFare) && !(is_float($baseFare) || is_numeric($baseFare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFare, true), gettype($baseFare)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($baseFare) && mb_strlen(mb_substr($baseFare, false !== mb_strpos($baseFare, '.') ? mb_strpos($baseFare, '.') + 1 : mb_strlen($baseFare))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($baseFare, true), mb_strlen(mb_substr($baseFare, mb_strpos($baseFare, '.') + 1))), __LINE__);
        }
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param float $taxes
     * @return \SabrePaymentGateway\StructType\FareBreakType
     */
    public function setTaxes($taxes = null)
    {
        // validation for constraint: float
        if (!is_null($taxes) && !(is_float($taxes) || is_numeric($taxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxes, true), gettype($taxes)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($taxes) && mb_strlen(mb_substr($taxes, false !== mb_strpos($taxes, '.') ? mb_strpos($taxes, '.') + 1 : mb_strlen($taxes))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($taxes, true), mb_strlen(mb_substr($taxes, mb_strpos($taxes, '.') + 1))), __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return float|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param float $fees
     * @return \SabrePaymentGateway\StructType\FareBreakType
     */
    public function setFees($fees = null)
    {
        // validation for constraint: float
        if (!is_null($fees) && !(is_float($fees) || is_numeric($fees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fees, true), gettype($fees)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fees) && mb_strlen(mb_substr($fees, false !== mb_strpos($fees, '.') ? mb_strpos($fees, '.') + 1 : mb_strlen($fees))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fees, true), mb_strlen(mb_substr($fees, mb_strpos($fees, '.') + 1))), __LINE__);
        }
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabrePaymentGateway\StructType\FareBreakType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get EquivalentBaseFare value
     * @return float|null
     */
    public function getEquivalentBaseFare()
    {
        return $this->EquivalentBaseFare;
    }
    /**
     * Set EquivalentBaseFare value
     * @param float $equivalentBaseFare
     * @return \SabrePaymentGateway\StructType\FareBreakType
     */
    public function setEquivalentBaseFare($equivalentBaseFare = null)
    {
        // validation for constraint: float
        if (!is_null($equivalentBaseFare) && !(is_float($equivalentBaseFare) || is_numeric($equivalentBaseFare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($equivalentBaseFare, true), gettype($equivalentBaseFare)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($equivalentBaseFare) && mb_strlen(mb_substr($equivalentBaseFare, false !== mb_strpos($equivalentBaseFare, '.') ? mb_strpos($equivalentBaseFare, '.') + 1 : mb_strlen($equivalentBaseFare))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($equivalentBaseFare, true), mb_strlen(mb_substr($equivalentBaseFare, mb_strpos($equivalentBaseFare, '.') + 1))), __LINE__);
        }
        $this->EquivalentBaseFare = $equivalentBaseFare;
        return $this;
    }
    /**
     * Get EquivalentCurrencyCode value
     * @return string|null
     */
    public function getEquivalentCurrencyCode()
    {
        return $this->EquivalentCurrencyCode;
    }
    /**
     * Set EquivalentCurrencyCode value
     * @param string $equivalentCurrencyCode
     * @return \SabrePaymentGateway\StructType\FareBreakType
     */
    public function setEquivalentCurrencyCode($equivalentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($equivalentCurrencyCode) && !is_string($equivalentCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($equivalentCurrencyCode, true), gettype($equivalentCurrencyCode)), __LINE__);
        }
        $this->EquivalentCurrencyCode = $equivalentCurrencyCode;
        return $this;
    }
}
