<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationDetailType StructType
 * @subpackage Structs
 */
class AuthenticationDetailType extends AbstractStructBase
{
    /**
     * The RedirectURL_Parameter
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\NameValueType[]
     */
    public $RedirectURL_Parameter;
    /**
     * The MAC
     * @var string
     */
    public $MAC;
    /**
     * Constructor method for AuthenticationDetailType
     * @uses AuthenticationDetailType::setRedirectURL_Parameter()
     * @uses AuthenticationDetailType::setMAC()
     * @param \SabrePaymentGateway\StructType\NameValueType[] $redirectURL_Parameter
     * @param string $mAC
     */
    public function __construct(array $redirectURL_Parameter = array(), $mAC = null)
    {
        $this
            ->setRedirectURL_Parameter($redirectURL_Parameter)
            ->setMAC($mAC);
    }
    /**
     * Get RedirectURL_Parameter value
     * @return \SabrePaymentGateway\StructType\NameValueType[]|null
     */
    public function getRedirectURL_Parameter()
    {
        return $this->RedirectURL_Parameter;
    }
    /**
     * This method is responsible for validating the values passed to the setRedirectURL_Parameter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRedirectURL_Parameter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRedirectURL_ParameterForArrayConstraintsFromSetRedirectURL_Parameter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $authenticationDetailTypeRedirectURL_ParameterItem) {
            // validation for constraint: itemType
            if (!$authenticationDetailTypeRedirectURL_ParameterItem instanceof \SabrePaymentGateway\StructType\NameValueType) {
                $invalidValues[] = is_object($authenticationDetailTypeRedirectURL_ParameterItem) ? get_class($authenticationDetailTypeRedirectURL_ParameterItem) : sprintf('%s(%s)', gettype($authenticationDetailTypeRedirectURL_ParameterItem), var_export($authenticationDetailTypeRedirectURL_ParameterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RedirectURL_Parameter property can only contain items of type \SabrePaymentGateway\StructType\NameValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RedirectURL_Parameter value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\NameValueType[] $redirectURL_Parameter
     * @return \SabrePaymentGateway\StructType\AuthenticationDetailType
     */
    public function setRedirectURL_Parameter(array $redirectURL_Parameter = array())
    {
        // validation for constraint: array
        if ('' !== ($redirectURL_ParameterArrayErrorMessage = self::validateRedirectURL_ParameterForArrayConstraintsFromSetRedirectURL_Parameter($redirectURL_Parameter))) {
            throw new \InvalidArgumentException($redirectURL_ParameterArrayErrorMessage, __LINE__);
        }
        $this->RedirectURL_Parameter = $redirectURL_Parameter;
        return $this;
    }
    /**
     * Add item to RedirectURL_Parameter value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\NameValueType $item
     * @return \SabrePaymentGateway\StructType\AuthenticationDetailType
     */
    public function addToRedirectURL_Parameter(\SabrePaymentGateway\StructType\NameValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\NameValueType) {
            throw new \InvalidArgumentException(sprintf('The RedirectURL_Parameter property can only contain items of type \SabrePaymentGateway\StructType\NameValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RedirectURL_Parameter[] = $item;
        return $this;
    }
    /**
     * Get MAC value
     * @return string|null
     */
    public function getMAC()
    {
        return $this->MAC;
    }
    /**
     * Set MAC value
     * @param string $mAC
     * @return \SabrePaymentGateway\StructType\AuthenticationDetailType
     */
    public function setMAC($mAC = null)
    {
        // validation for constraint: string
        if (!is_null($mAC) && !is_string($mAC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mAC, true), gettype($mAC)), __LINE__);
        }
        $this->MAC = $mAC;
        return $this;
    }
}
