<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrivalInfo StructType
 * @subpackage Structs
 */
class ArrivalInfo extends AbstractStructBase
{
    /**
     * The ArrivalAirport
     * Meta information extracted from the WSDL
     * - documentation: 3-alpha IATA airport city code.
     * - use: required
     * @var string
     */
    public $ArrivalAirport;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The FinalDestinationInd
     * Meta information extracted from the WSDL
     * - documentation: Indicates if the arrival city is the final destination.
     * - use: optional
     * @var bool
     */
    public $FinalDestinationInd;
    /**
     * Constructor method for ArrivalInfo
     * @uses ArrivalInfo::setArrivalAirport()
     * @uses ArrivalInfo::setArrivalDateTime()
     * @uses ArrivalInfo::setFinalDestinationInd()
     * @param string $arrivalAirport
     * @param string $arrivalDateTime
     * @param bool $finalDestinationInd
     */
    public function __construct($arrivalAirport = null, $arrivalDateTime = null, $finalDestinationInd = null)
    {
        $this
            ->setArrivalAirport($arrivalAirport)
            ->setArrivalDateTime($arrivalDateTime)
            ->setFinalDestinationInd($finalDestinationInd);
    }
    /**
     * Get ArrivalAirport value
     * @return string
     */
    public function getArrivalAirport()
    {
        return $this->ArrivalAirport;
    }
    /**
     * Set ArrivalAirport value
     * @param string $arrivalAirport
     * @return \SabrePaymentGateway\StructType\ArrivalInfo
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirport) && !is_string($arrivalAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirport, true), gettype($arrivalAirport)), __LINE__);
        }
        $this->ArrivalAirport = $arrivalAirport;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \SabrePaymentGateway\StructType\ArrivalInfo
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get FinalDestinationInd value
     * @return bool|null
     */
    public function getFinalDestinationInd()
    {
        return $this->FinalDestinationInd;
    }
    /**
     * Set FinalDestinationInd value
     * @param bool $finalDestinationInd
     * @return \SabrePaymentGateway\StructType\ArrivalInfo
     */
    public function setFinalDestinationInd($finalDestinationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($finalDestinationInd) && !is_bool($finalDestinationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($finalDestinationInd, true), gettype($finalDestinationInd)), __LINE__);
        }
        $this->FinalDestinationInd = $finalDestinationInd;
        return $this;
    }
}
