<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AmountDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Total transaction amount
 * @subpackage Structs
 */
class AmountDetail extends CurrencyAmountType
{
    /**
     * The TaxBreak
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\TaxType[]
     */
    public $TaxBreak;
    /**
     * The FeeBreak
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\FeeBreakType
     */
    public $FeeBreak;
    /**
     * The BonusAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BonusAmount;
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Points;
    /**
     * The TicketingCurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TicketingCurrencyCode;
    /**
     * The TicketingAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $TicketingAmount;
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BaseAmount;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Fees;
    /**
     * The FopFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $FopFeeAmount;
    /**
     * The WithInterestInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $WithInterestInd;
    /**
     * The InterestAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $InterestAmount;
    /**
     * The NonInstallmentAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $NonInstallmentAmount;
    /**
     * Constructor method for AmountDetail
     * @uses AmountDetail::setTaxBreak()
     * @uses AmountDetail::setFeeBreak()
     * @uses AmountDetail::setBonusAmount()
     * @uses AmountDetail::setPoints()
     * @uses AmountDetail::setTicketingCurrencyCode()
     * @uses AmountDetail::setTicketingAmount()
     * @uses AmountDetail::setBaseAmount()
     * @uses AmountDetail::setTaxes()
     * @uses AmountDetail::setFees()
     * @uses AmountDetail::setFopFeeAmount()
     * @uses AmountDetail::setWithInterestInd()
     * @uses AmountDetail::setInterestAmount()
     * @uses AmountDetail::setNonInstallmentAmount()
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @param \SabrePaymentGateway\StructType\FeeBreakType $feeBreak
     * @param float $bonusAmount
     * @param int $points
     * @param string $ticketingCurrencyCode
     * @param float $ticketingAmount
     * @param float $baseAmount
     * @param float $taxes
     * @param float $fees
     * @param float $fopFeeAmount
     * @param bool $withInterestInd
     * @param float $interestAmount
     * @param float $nonInstallmentAmount
     */
    public function __construct(array $taxBreak = array(), \SabrePaymentGateway\StructType\FeeBreakType $feeBreak = null, $bonusAmount = null, $points = null, $ticketingCurrencyCode = null, $ticketingAmount = null, $baseAmount = null, $taxes = null, $fees = null, $fopFeeAmount = null, $withInterestInd = null, $interestAmount = null, $nonInstallmentAmount = null)
    {
        $this
            ->setTaxBreak($taxBreak)
            ->setFeeBreak($feeBreak)
            ->setBonusAmount($bonusAmount)
            ->setPoints($points)
            ->setTicketingCurrencyCode($ticketingCurrencyCode)
            ->setTicketingAmount($ticketingAmount)
            ->setBaseAmount($baseAmount)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setFopFeeAmount($fopFeeAmount)
            ->setWithInterestInd($withInterestInd)
            ->setInterestAmount($interestAmount)
            ->setNonInstallmentAmount($nonInstallmentAmount);
    }
    /**
     * Get TaxBreak value
     * @return \SabrePaymentGateway\StructType\TaxType[]|null
     */
    public function getTaxBreak()
    {
        return $this->TaxBreak;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxBreak method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxBreak method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxBreakForArrayConstraintsFromSetTaxBreak(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $amountDetailTaxBreakItem) {
            // validation for constraint: itemType
            if (!$amountDetailTaxBreakItem instanceof \SabrePaymentGateway\StructType\TaxType) {
                $invalidValues[] = is_object($amountDetailTaxBreakItem) ? get_class($amountDetailTaxBreakItem) : sprintf('%s(%s)', gettype($amountDetailTaxBreakItem), var_export($amountDetailTaxBreakItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setTaxBreak(array $taxBreak = array())
    {
        // validation for constraint: array
        if ('' !== ($taxBreakArrayErrorMessage = self::validateTaxBreakForArrayConstraintsFromSetTaxBreak($taxBreak))) {
            throw new \InvalidArgumentException($taxBreakArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxBreak) && count($taxBreak) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxBreak)), __LINE__);
        }
        $this->TaxBreak = $taxBreak;
        return $this;
    }
    /**
     * Add item to TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType $item
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function addToTaxBreak(\SabrePaymentGateway\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TaxBreak) && count($this->TaxBreak) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TaxBreak)), __LINE__);
        }
        $this->TaxBreak[] = $item;
        return $this;
    }
    /**
     * Get FeeBreak value
     * @return \SabrePaymentGateway\StructType\FeeBreakType|null
     */
    public function getFeeBreak()
    {
        return $this->FeeBreak;
    }
    /**
     * Set FeeBreak value
     * @param \SabrePaymentGateway\StructType\FeeBreakType $feeBreak
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setFeeBreak(\SabrePaymentGateway\StructType\FeeBreakType $feeBreak = null)
    {
        $this->FeeBreak = $feeBreak;
        return $this;
    }
    /**
     * Get BonusAmount value
     * @return float|null
     */
    public function getBonusAmount()
    {
        return $this->BonusAmount;
    }
    /**
     * Set BonusAmount value
     * @param float $bonusAmount
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setBonusAmount($bonusAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bonusAmount) && !(is_float($bonusAmount) || is_numeric($bonusAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusAmount, true), gettype($bonusAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($bonusAmount) && mb_strlen(mb_substr($bonusAmount, false !== mb_strpos($bonusAmount, '.') ? mb_strpos($bonusAmount, '.') + 1 : mb_strlen($bonusAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($bonusAmount, true), mb_strlen(mb_substr($bonusAmount, mb_strpos($bonusAmount, '.') + 1))), __LINE__);
        }
        $this->BonusAmount = $bonusAmount;
        return $this;
    }
    /**
     * Get Points value
     * @return int|null
     */
    public function getPoints()
    {
        return $this->Points;
    }
    /**
     * Set Points value
     * @param int $points
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setPoints($points = null)
    {
        // validation for constraint: int
        if (!is_null($points) && !(is_int($points) || ctype_digit($points))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($points, true), gettype($points)), __LINE__);
        }
        $this->Points = $points;
        return $this;
    }
    /**
     * Get TicketingCurrencyCode value
     * @return string|null
     */
    public function getTicketingCurrencyCode()
    {
        return $this->TicketingCurrencyCode;
    }
    /**
     * Set TicketingCurrencyCode value
     * @param string $ticketingCurrencyCode
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setTicketingCurrencyCode($ticketingCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingCurrencyCode) && !is_string($ticketingCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingCurrencyCode, true), gettype($ticketingCurrencyCode)), __LINE__);
        }
        $this->TicketingCurrencyCode = $ticketingCurrencyCode;
        return $this;
    }
    /**
     * Get TicketingAmount value
     * @return float|null
     */
    public function getTicketingAmount()
    {
        return $this->TicketingAmount;
    }
    /**
     * Set TicketingAmount value
     * @param float $ticketingAmount
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setTicketingAmount($ticketingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ticketingAmount) && !(is_float($ticketingAmount) || is_numeric($ticketingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ticketingAmount, true), gettype($ticketingAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($ticketingAmount) && mb_strlen(mb_substr($ticketingAmount, false !== mb_strpos($ticketingAmount, '.') ? mb_strpos($ticketingAmount, '.') + 1 : mb_strlen($ticketingAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($ticketingAmount, true), mb_strlen(mb_substr($ticketingAmount, mb_strpos($ticketingAmount, '.') + 1))), __LINE__);
        }
        $this->TicketingAmount = $ticketingAmount;
        return $this;
    }
    /**
     * Get BaseAmount value
     * @return float|null
     */
    public function getBaseAmount()
    {
        return $this->BaseAmount;
    }
    /**
     * Set BaseAmount value
     * @param float $baseAmount
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setBaseAmount($baseAmount = null)
    {
        // validation for constraint: float
        if (!is_null($baseAmount) && !(is_float($baseAmount) || is_numeric($baseAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseAmount, true), gettype($baseAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($baseAmount) && mb_strlen(mb_substr($baseAmount, false !== mb_strpos($baseAmount, '.') ? mb_strpos($baseAmount, '.') + 1 : mb_strlen($baseAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($baseAmount, true), mb_strlen(mb_substr($baseAmount, mb_strpos($baseAmount, '.') + 1))), __LINE__);
        }
        $this->BaseAmount = $baseAmount;
        return $this;
    }
    /**
     * Get Taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param float $taxes
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setTaxes($taxes = null)
    {
        // validation for constraint: float
        if (!is_null($taxes) && !(is_float($taxes) || is_numeric($taxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxes, true), gettype($taxes)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($taxes) && mb_strlen(mb_substr($taxes, false !== mb_strpos($taxes, '.') ? mb_strpos($taxes, '.') + 1 : mb_strlen($taxes))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($taxes, true), mb_strlen(mb_substr($taxes, mb_strpos($taxes, '.') + 1))), __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return float|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param float $fees
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setFees($fees = null)
    {
        // validation for constraint: float
        if (!is_null($fees) && !(is_float($fees) || is_numeric($fees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fees, true), gettype($fees)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fees) && mb_strlen(mb_substr($fees, false !== mb_strpos($fees, '.') ? mb_strpos($fees, '.') + 1 : mb_strlen($fees))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fees, true), mb_strlen(mb_substr($fees, mb_strpos($fees, '.') + 1))), __LINE__);
        }
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get FopFeeAmount value
     * @return float|null
     */
    public function getFopFeeAmount()
    {
        return $this->FopFeeAmount;
    }
    /**
     * Set FopFeeAmount value
     * @param float $fopFeeAmount
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setFopFeeAmount($fopFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fopFeeAmount) && !(is_float($fopFeeAmount) || is_numeric($fopFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fopFeeAmount, true), gettype($fopFeeAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fopFeeAmount) && mb_strlen(mb_substr($fopFeeAmount, false !== mb_strpos($fopFeeAmount, '.') ? mb_strpos($fopFeeAmount, '.') + 1 : mb_strlen($fopFeeAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fopFeeAmount, true), mb_strlen(mb_substr($fopFeeAmount, mb_strpos($fopFeeAmount, '.') + 1))), __LINE__);
        }
        $this->FopFeeAmount = $fopFeeAmount;
        return $this;
    }
    /**
     * Get WithInterestInd value
     * @return bool|null
     */
    public function getWithInterestInd()
    {
        return $this->WithInterestInd;
    }
    /**
     * Set WithInterestInd value
     * @param bool $withInterestInd
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setWithInterestInd($withInterestInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($withInterestInd) && !is_bool($withInterestInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($withInterestInd, true), gettype($withInterestInd)), __LINE__);
        }
        $this->WithInterestInd = $withInterestInd;
        return $this;
    }
    /**
     * Get InterestAmount value
     * @return float|null
     */
    public function getInterestAmount()
    {
        return $this->InterestAmount;
    }
    /**
     * Set InterestAmount value
     * @param float $interestAmount
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setInterestAmount($interestAmount = null)
    {
        // validation for constraint: float
        if (!is_null($interestAmount) && !(is_float($interestAmount) || is_numeric($interestAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($interestAmount, true), gettype($interestAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($interestAmount) && mb_strlen(mb_substr($interestAmount, false !== mb_strpos($interestAmount, '.') ? mb_strpos($interestAmount, '.') + 1 : mb_strlen($interestAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($interestAmount, true), mb_strlen(mb_substr($interestAmount, mb_strpos($interestAmount, '.') + 1))), __LINE__);
        }
        $this->InterestAmount = $interestAmount;
        return $this;
    }
    /**
     * Get NonInstallmentAmount value
     * @return float|null
     */
    public function getNonInstallmentAmount()
    {
        return $this->NonInstallmentAmount;
    }
    /**
     * Set NonInstallmentAmount value
     * @param float $nonInstallmentAmount
     * @return \SabrePaymentGateway\StructType\AmountDetail
     */
    public function setNonInstallmentAmount($nonInstallmentAmount = null)
    {
        // validation for constraint: float
        if (!is_null($nonInstallmentAmount) && !(is_float($nonInstallmentAmount) || is_numeric($nonInstallmentAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nonInstallmentAmount, true), gettype($nonInstallmentAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($nonInstallmentAmount) && mb_strlen(mb_substr($nonInstallmentAmount, false !== mb_strpos($nonInstallmentAmount, '.') ? mb_strpos($nonInstallmentAmount, '.') + 1 : mb_strlen($nonInstallmentAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($nonInstallmentAmount, true), mb_strlen(mb_substr($nonInstallmentAmount, mb_strpos($nonInstallmentAmount, '.') + 1))), __LINE__);
        }
        $this->NonInstallmentAmount = $nonInstallmentAmount;
        return $this;
    }
}
