<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalApprovals StructType
 * @subpackage Structs
 */
class AdditionalApprovals extends AbstractStructBase
{
    /**
     * The Approval
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * @var \SabrePaymentGateway\StructType\Approval[]
     */
    public $Approval;
    /**
     * Constructor method for AdditionalApprovals
     * @uses AdditionalApprovals::setApproval()
     * @param \SabrePaymentGateway\StructType\Approval[] $approval
     */
    public function __construct(array $approval = array())
    {
        $this
            ->setApproval($approval);
    }
    /**
     * Get Approval value
     * @return \SabrePaymentGateway\StructType\Approval[]|null
     */
    public function getApproval()
    {
        return $this->Approval;
    }
    /**
     * This method is responsible for validating the values passed to the setApproval method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproval method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApprovalForArrayConstraintsFromSetApproval(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalApprovalsApprovalItem) {
            // validation for constraint: itemType
            if (!$additionalApprovalsApprovalItem instanceof \SabrePaymentGateway\StructType\Approval) {
                $invalidValues[] = is_object($additionalApprovalsApprovalItem) ? get_class($additionalApprovalsApprovalItem) : sprintf('%s(%s)', gettype($additionalApprovalsApprovalItem), var_export($additionalApprovalsApprovalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approval property can only contain items of type \SabrePaymentGateway\StructType\Approval, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approval value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Approval[] $approval
     * @return \SabrePaymentGateway\StructType\AdditionalApprovals
     */
    public function setApproval(array $approval = array())
    {
        // validation for constraint: array
        if ('' !== ($approvalArrayErrorMessage = self::validateApprovalForArrayConstraintsFromSetApproval($approval))) {
            throw new \InvalidArgumentException($approvalArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($approval) && count($approval) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($approval)), __LINE__);
        }
        $this->Approval = $approval;
        return $this;
    }
    /**
     * Add item to Approval value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Approval $item
     * @return \SabrePaymentGateway\StructType\AdditionalApprovals
     */
    public function addToApproval(\SabrePaymentGateway\StructType\Approval $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Approval) {
            throw new \InvalidArgumentException(sprintf('The Approval property can only contain items of type \SabrePaymentGateway\StructType\Approval, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Approval) && count($this->Approval) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Approval)), __LINE__);
        }
        $this->Approval[] = $item;
        return $this;
    }
}
