<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountValidationResultType StructType
 * @subpackage Structs
 */
class AccountValidationResultType extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResultCode;
    /**
     * The CardReaderResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CardReaderResult
     */
    public $CardReaderResult;
    /**
     * The T3DS_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\T3DS_ResultType
     */
    public $T3DS_Result;
    /**
     * The CSC_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CSC_ResultType
     */
    public $CSC_Result;
    /**
     * The PIN_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PIN_Result
     */
    public $PIN_Result;
    /**
     * The AVS_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AVS_ResultType
     */
    public $AVS_Result;
    /**
     * The AuthResponseDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AuthResponseDetail
     */
    public $AuthResponseDetail;
    /**
     * The TokenizationResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\TokenizationResultType
     */
    public $TokenizationResult;
    /**
     * The SupplierMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\SupplierMessagesType
     */
    public $SupplierMessages;
    /**
     * The LocalCardDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\LocalCardDetail
     */
    public $LocalCardDetail;
    /**
     * The ReturnURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnURL;
    /**
     * The FulfillmentNotificationURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FulfillmentNotificationURL;
    /**
     * The RedirectHTML
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RedirectHTML;
    /**
     * The AdditionalApprovals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AdditionalApprovals
     */
    public $AdditionalApprovals;
    /**
     * The VoucherDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\VoucherDetail
     */
    public $VoucherDetail;
    /**
     * The AdditionalRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarksType
     */
    public $AdditionalRemarks;
    /**
     * The AdditionalNonHistoricalRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarksType
     */
    public $AdditionalNonHistoricalRemarks;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarksType
     */
    public $Remarks;
    /**
     * The AdditionalDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AdditionalDetailType
     */
    public $AdditionalDetail;
    /**
     * The ListOfReferenceNbrs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\ListOfReferenceNbrs
     */
    public $ListOfReferenceNbrs;
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResponseCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * The ApprovedAmount
     * Meta information extracted from the WSDL
     * - documentation: Total authorized including Bonus. | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $ApprovedAmount;
    /**
     * The AuthAmountSent
     * Meta information extracted from the WSDL
     * - documentation: Internal use only | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $AuthAmountSent;
    /**
     * The BonusAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BonusAmount;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierReferenceID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierReferenceID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The AcquirerResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AcquirerResponseCode;
    /**
     * The MerchantAccountNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MerchantAccountNumber;
    /**
     * The CAVV_ResultCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CAVV_ResultCode;
    /**
     * The AuthRemarks1
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthRemarks1;
    /**
     * The AuthRemarks2
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthRemarks2;
    /**
     * The DCC_Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DCC_Remarks;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The PaymentConfirmInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentConfirmInd;
    /**
     * The FulfillmentNotificationInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $FulfillmentNotificationInd;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentRef;
    /**
     * The ReverseFlagInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $ReverseFlagInd;
    /**
     * The PreviouslyProcessedRqst
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $PreviouslyProcessedRqst;
    /**
     * The NetworkTransactionReference
     * Meta information extracted from the WSDL
     * - documentation: Transaction ID that supports merchant-initiated transaction (MIT) exemptions
     * - use: optional
     * @var string
     */
    public $NetworkTransactionReference;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ErrorCode;
    /**
     * Constructor method for AccountValidationResultType
     * @uses AccountValidationResultType::setResultCode()
     * @uses AccountValidationResultType::setCardReaderResult()
     * @uses AccountValidationResultType::setT3DS_Result()
     * @uses AccountValidationResultType::setCSC_Result()
     * @uses AccountValidationResultType::setPIN_Result()
     * @uses AccountValidationResultType::setAVS_Result()
     * @uses AccountValidationResultType::setAuthResponseDetail()
     * @uses AccountValidationResultType::setTokenizationResult()
     * @uses AccountValidationResultType::setSupplierMessages()
     * @uses AccountValidationResultType::setLocalCardDetail()
     * @uses AccountValidationResultType::setReturnURL()
     * @uses AccountValidationResultType::setFulfillmentNotificationURL()
     * @uses AccountValidationResultType::setRedirectHTML()
     * @uses AccountValidationResultType::setAdditionalApprovals()
     * @uses AccountValidationResultType::setVoucherDetail()
     * @uses AccountValidationResultType::setAdditionalRemarks()
     * @uses AccountValidationResultType::setAdditionalNonHistoricalRemarks()
     * @uses AccountValidationResultType::setRemarks()
     * @uses AccountValidationResultType::setAdditionalDetail()
     * @uses AccountValidationResultType::setListOfReferenceNbrs()
     * @uses AccountValidationResultType::setResponseCode()
     * @uses AccountValidationResultType::setDescription()
     * @uses AccountValidationResultType::setApprovalCode()
     * @uses AccountValidationResultType::setApprovedAmount()
     * @uses AccountValidationResultType::setAuthAmountSent()
     * @uses AccountValidationResultType::setBonusAmount()
     * @uses AccountValidationResultType::setSupplierID()
     * @uses AccountValidationResultType::setSupplierTransID()
     * @uses AccountValidationResultType::setSupplierReferenceID()
     * @uses AccountValidationResultType::setSupplierResponseCode()
     * @uses AccountValidationResultType::setAcquirerResponseCode()
     * @uses AccountValidationResultType::setMerchantAccountNumber()
     * @uses AccountValidationResultType::setCAVV_ResultCode()
     * @uses AccountValidationResultType::setAuthRemarks1()
     * @uses AccountValidationResultType::setAuthRemarks2()
     * @uses AccountValidationResultType::setDCC_Remarks()
     * @uses AccountValidationResultType::setCurrencyCode()
     * @uses AccountValidationResultType::setPaymentConfirmInd()
     * @uses AccountValidationResultType::setFulfillmentNotificationInd()
     * @uses AccountValidationResultType::setPaymentRef()
     * @uses AccountValidationResultType::setReverseFlagInd()
     * @uses AccountValidationResultType::setPreviouslyProcessedRqst()
     * @uses AccountValidationResultType::setNetworkTransactionReference()
     * @uses AccountValidationResultType::setErrorCode()
     * @param string $resultCode
     * @param \SabrePaymentGateway\StructType\CardReaderResult $cardReaderResult
     * @param \SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result
     * @param \SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result
     * @param \SabrePaymentGateway\StructType\PIN_Result $pIN_Result
     * @param \SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result
     * @param \SabrePaymentGateway\StructType\AuthResponseDetail $authResponseDetail
     * @param \SabrePaymentGateway\StructType\TokenizationResultType $tokenizationResult
     * @param \SabrePaymentGateway\StructType\SupplierMessagesType $supplierMessages
     * @param \SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail
     * @param string $returnURL
     * @param string $fulfillmentNotificationURL
     * @param string $redirectHTML
     * @param \SabrePaymentGateway\StructType\AdditionalApprovals $additionalApprovals
     * @param \SabrePaymentGateway\StructType\VoucherDetail $voucherDetail
     * @param \SabrePaymentGateway\StructType\RemarksType $additionalRemarks
     * @param \SabrePaymentGateway\StructType\RemarksType $additionalNonHistoricalRemarks
     * @param \SabrePaymentGateway\StructType\RemarksType $remarks
     * @param \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail
     * @param \SabrePaymentGateway\StructType\ListOfReferenceNbrs $listOfReferenceNbrs
     * @param string $responseCode
     * @param string $description
     * @param string $approvalCode
     * @param float $approvedAmount
     * @param float $authAmountSent
     * @param float $bonusAmount
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $supplierReferenceID
     * @param string $supplierResponseCode
     * @param string $acquirerResponseCode
     * @param string $merchantAccountNumber
     * @param string $cAVV_ResultCode
     * @param string $authRemarks1
     * @param string $authRemarks2
     * @param string $dCC_Remarks
     * @param string $currencyCode
     * @param string $paymentConfirmInd
     * @param bool $fulfillmentNotificationInd
     * @param string $paymentRef
     * @param bool $reverseFlagInd
     * @param bool $previouslyProcessedRqst
     * @param string $networkTransactionReference
     * @param string $errorCode
     */
    public function __construct($resultCode = null, \SabrePaymentGateway\StructType\CardReaderResult $cardReaderResult = null, \SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result = null, \SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result = null, \SabrePaymentGateway\StructType\PIN_Result $pIN_Result = null, \SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result = null, \SabrePaymentGateway\StructType\AuthResponseDetail $authResponseDetail = null, \SabrePaymentGateway\StructType\TokenizationResultType $tokenizationResult = null, \SabrePaymentGateway\StructType\SupplierMessagesType $supplierMessages = null, \SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail = null, $returnURL = null, $fulfillmentNotificationURL = null, $redirectHTML = null, \SabrePaymentGateway\StructType\AdditionalApprovals $additionalApprovals = null, \SabrePaymentGateway\StructType\VoucherDetail $voucherDetail = null, \SabrePaymentGateway\StructType\RemarksType $additionalRemarks = null, \SabrePaymentGateway\StructType\RemarksType $additionalNonHistoricalRemarks = null, \SabrePaymentGateway\StructType\RemarksType $remarks = null, \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail = null, \SabrePaymentGateway\StructType\ListOfReferenceNbrs $listOfReferenceNbrs = null, $responseCode = null, $description = null, $approvalCode = null, $approvedAmount = null, $authAmountSent = null, $bonusAmount = null, $supplierID = null, $supplierTransID = null, $supplierReferenceID = null, $supplierResponseCode = null, $acquirerResponseCode = null, $merchantAccountNumber = null, $cAVV_ResultCode = null, $authRemarks1 = null, $authRemarks2 = null, $dCC_Remarks = null, $currencyCode = null, $paymentConfirmInd = null, $fulfillmentNotificationInd = null, $paymentRef = null, $reverseFlagInd = null, $previouslyProcessedRqst = null, $networkTransactionReference = null, $errorCode = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setCardReaderResult($cardReaderResult)
            ->setT3DS_Result($t3DS_Result)
            ->setCSC_Result($cSC_Result)
            ->setPIN_Result($pIN_Result)
            ->setAVS_Result($aVS_Result)
            ->setAuthResponseDetail($authResponseDetail)
            ->setTokenizationResult($tokenizationResult)
            ->setSupplierMessages($supplierMessages)
            ->setLocalCardDetail($localCardDetail)
            ->setReturnURL($returnURL)
            ->setFulfillmentNotificationURL($fulfillmentNotificationURL)
            ->setRedirectHTML($redirectHTML)
            ->setAdditionalApprovals($additionalApprovals)
            ->setVoucherDetail($voucherDetail)
            ->setAdditionalRemarks($additionalRemarks)
            ->setAdditionalNonHistoricalRemarks($additionalNonHistoricalRemarks)
            ->setRemarks($remarks)
            ->setAdditionalDetail($additionalDetail)
            ->setListOfReferenceNbrs($listOfReferenceNbrs)
            ->setResponseCode($responseCode)
            ->setDescription($description)
            ->setApprovalCode($approvalCode)
            ->setApprovedAmount($approvedAmount)
            ->setAuthAmountSent($authAmountSent)
            ->setBonusAmount($bonusAmount)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierReferenceID($supplierReferenceID)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setAcquirerResponseCode($acquirerResponseCode)
            ->setMerchantAccountNumber($merchantAccountNumber)
            ->setCAVV_ResultCode($cAVV_ResultCode)
            ->setAuthRemarks1($authRemarks1)
            ->setAuthRemarks2($authRemarks2)
            ->setDCC_Remarks($dCC_Remarks)
            ->setCurrencyCode($currencyCode)
            ->setPaymentConfirmInd($paymentConfirmInd)
            ->setFulfillmentNotificationInd($fulfillmentNotificationInd)
            ->setPaymentRef($paymentRef)
            ->setReverseFlagInd($reverseFlagInd)
            ->setPreviouslyProcessedRqst($previouslyProcessedRqst)
            ->setNetworkTransactionReference($networkTransactionReference)
            ->setErrorCode($errorCode);
    }
    /**
     * Get ResultCode value
     * @return string
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get CardReaderResult value
     * @return \SabrePaymentGateway\StructType\CardReaderResult|null
     */
    public function getCardReaderResult()
    {
        return $this->CardReaderResult;
    }
    /**
     * Set CardReaderResult value
     * @param \SabrePaymentGateway\StructType\CardReaderResult $cardReaderResult
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setCardReaderResult(\SabrePaymentGateway\StructType\CardReaderResult $cardReaderResult = null)
    {
        $this->CardReaderResult = $cardReaderResult;
        return $this;
    }
    /**
     * Get T3DS_Result value
     * @return \SabrePaymentGateway\StructType\T3DS_ResultType|null
     */
    public function getT3DS_Result()
    {
        return $this->T3DS_Result;
    }
    /**
     * Set T3DS_Result value
     * @param \SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setT3DS_Result(\SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result = null)
    {
        $this->T3DS_Result = $t3DS_Result;
        return $this;
    }
    /**
     * Get CSC_Result value
     * @return \SabrePaymentGateway\StructType\CSC_ResultType|null
     */
    public function getCSC_Result()
    {
        return $this->CSC_Result;
    }
    /**
     * Set CSC_Result value
     * @param \SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setCSC_Result(\SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result = null)
    {
        $this->CSC_Result = $cSC_Result;
        return $this;
    }
    /**
     * Get PIN_Result value
     * @return \SabrePaymentGateway\StructType\PIN_Result|null
     */
    public function getPIN_Result()
    {
        return $this->PIN_Result;
    }
    /**
     * Set PIN_Result value
     * @param \SabrePaymentGateway\StructType\PIN_Result $pIN_Result
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setPIN_Result(\SabrePaymentGateway\StructType\PIN_Result $pIN_Result = null)
    {
        $this->PIN_Result = $pIN_Result;
        return $this;
    }
    /**
     * Get AVS_Result value
     * @return \SabrePaymentGateway\StructType\AVS_ResultType|null
     */
    public function getAVS_Result()
    {
        return $this->AVS_Result;
    }
    /**
     * Set AVS_Result value
     * @param \SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAVS_Result(\SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result = null)
    {
        $this->AVS_Result = $aVS_Result;
        return $this;
    }
    /**
     * Get AuthResponseDetail value
     * @return \SabrePaymentGateway\StructType\AuthResponseDetail|null
     */
    public function getAuthResponseDetail()
    {
        return $this->AuthResponseDetail;
    }
    /**
     * Set AuthResponseDetail value
     * @param \SabrePaymentGateway\StructType\AuthResponseDetail $authResponseDetail
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAuthResponseDetail(\SabrePaymentGateway\StructType\AuthResponseDetail $authResponseDetail = null)
    {
        $this->AuthResponseDetail = $authResponseDetail;
        return $this;
    }
    /**
     * Get TokenizationResult value
     * @return \SabrePaymentGateway\StructType\TokenizationResultType|null
     */
    public function getTokenizationResult()
    {
        return $this->TokenizationResult;
    }
    /**
     * Set TokenizationResult value
     * @param \SabrePaymentGateway\StructType\TokenizationResultType $tokenizationResult
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setTokenizationResult(\SabrePaymentGateway\StructType\TokenizationResultType $tokenizationResult = null)
    {
        $this->TokenizationResult = $tokenizationResult;
        return $this;
    }
    /**
     * Get SupplierMessages value
     * @return \SabrePaymentGateway\StructType\SupplierMessagesType|null
     */
    public function getSupplierMessages()
    {
        return $this->SupplierMessages;
    }
    /**
     * Set SupplierMessages value
     * @param \SabrePaymentGateway\StructType\SupplierMessagesType $supplierMessages
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setSupplierMessages(\SabrePaymentGateway\StructType\SupplierMessagesType $supplierMessages = null)
    {
        $this->SupplierMessages = $supplierMessages;
        return $this;
    }
    /**
     * Get LocalCardDetail value
     * @return \SabrePaymentGateway\StructType\LocalCardDetail|null
     */
    public function getLocalCardDetail()
    {
        return $this->LocalCardDetail;
    }
    /**
     * Set LocalCardDetail value
     * @param \SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setLocalCardDetail(\SabrePaymentGateway\StructType\LocalCardDetail $localCardDetail = null)
    {
        $this->LocalCardDetail = $localCardDetail;
        return $this;
    }
    /**
     * Get ReturnURL value
     * @return string|null
     */
    public function getReturnURL()
    {
        return $this->ReturnURL;
    }
    /**
     * Set ReturnURL value
     * @param string $returnURL
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setReturnURL($returnURL = null)
    {
        // validation for constraint: string
        if (!is_null($returnURL) && !is_string($returnURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnURL, true), gettype($returnURL)), __LINE__);
        }
        $this->ReturnURL = $returnURL;
        return $this;
    }
    /**
     * Get FulfillmentNotificationURL value
     * @return string|null
     */
    public function getFulfillmentNotificationURL()
    {
        return $this->FulfillmentNotificationURL;
    }
    /**
     * Set FulfillmentNotificationURL value
     * @param string $fulfillmentNotificationURL
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setFulfillmentNotificationURL($fulfillmentNotificationURL = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentNotificationURL) && !is_string($fulfillmentNotificationURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentNotificationURL, true), gettype($fulfillmentNotificationURL)), __LINE__);
        }
        $this->FulfillmentNotificationURL = $fulfillmentNotificationURL;
        return $this;
    }
    /**
     * Get RedirectHTML value
     * @return string|null
     */
    public function getRedirectHTML()
    {
        return $this->RedirectHTML;
    }
    /**
     * Set RedirectHTML value
     * @param string $redirectHTML
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setRedirectHTML($redirectHTML = null)
    {
        // validation for constraint: string
        if (!is_null($redirectHTML) && !is_string($redirectHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectHTML, true), gettype($redirectHTML)), __LINE__);
        }
        $this->RedirectHTML = $redirectHTML;
        return $this;
    }
    /**
     * Get AdditionalApprovals value
     * @return \SabrePaymentGateway\StructType\AdditionalApprovals|null
     */
    public function getAdditionalApprovals()
    {
        return $this->AdditionalApprovals;
    }
    /**
     * Set AdditionalApprovals value
     * @param \SabrePaymentGateway\StructType\AdditionalApprovals $additionalApprovals
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAdditionalApprovals(\SabrePaymentGateway\StructType\AdditionalApprovals $additionalApprovals = null)
    {
        $this->AdditionalApprovals = $additionalApprovals;
        return $this;
    }
    /**
     * Get VoucherDetail value
     * @return \SabrePaymentGateway\StructType\VoucherDetail|null
     */
    public function getVoucherDetail()
    {
        return $this->VoucherDetail;
    }
    /**
     * Set VoucherDetail value
     * @param \SabrePaymentGateway\StructType\VoucherDetail $voucherDetail
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setVoucherDetail(\SabrePaymentGateway\StructType\VoucherDetail $voucherDetail = null)
    {
        $this->VoucherDetail = $voucherDetail;
        return $this;
    }
    /**
     * Get AdditionalRemarks value
     * @return \SabrePaymentGateway\StructType\RemarksType|null
     */
    public function getAdditionalRemarks()
    {
        return $this->AdditionalRemarks;
    }
    /**
     * Set AdditionalRemarks value
     * @param \SabrePaymentGateway\StructType\RemarksType $additionalRemarks
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAdditionalRemarks(\SabrePaymentGateway\StructType\RemarksType $additionalRemarks = null)
    {
        $this->AdditionalRemarks = $additionalRemarks;
        return $this;
    }
    /**
     * Get AdditionalNonHistoricalRemarks value
     * @return \SabrePaymentGateway\StructType\RemarksType|null
     */
    public function getAdditionalNonHistoricalRemarks()
    {
        return $this->AdditionalNonHistoricalRemarks;
    }
    /**
     * Set AdditionalNonHistoricalRemarks value
     * @param \SabrePaymentGateway\StructType\RemarksType $additionalNonHistoricalRemarks
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAdditionalNonHistoricalRemarks(\SabrePaymentGateway\StructType\RemarksType $additionalNonHistoricalRemarks = null)
    {
        $this->AdditionalNonHistoricalRemarks = $additionalNonHistoricalRemarks;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \SabrePaymentGateway\StructType\RemarksType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \SabrePaymentGateway\StructType\RemarksType $remarks
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setRemarks(\SabrePaymentGateway\StructType\RemarksType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get AdditionalDetail value
     * @return \SabrePaymentGateway\StructType\AdditionalDetailType|null
     */
    public function getAdditionalDetail()
    {
        return $this->AdditionalDetail;
    }
    /**
     * Set AdditionalDetail value
     * @param \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAdditionalDetail(\SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail = null)
    {
        $this->AdditionalDetail = $additionalDetail;
        return $this;
    }
    /**
     * Get ListOfReferenceNbrs value
     * @return \SabrePaymentGateway\StructType\ListOfReferenceNbrs|null
     */
    public function getListOfReferenceNbrs()
    {
        return $this->ListOfReferenceNbrs;
    }
    /**
     * Set ListOfReferenceNbrs value
     * @param \SabrePaymentGateway\StructType\ListOfReferenceNbrs $listOfReferenceNbrs
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setListOfReferenceNbrs(\SabrePaymentGateway\StructType\ListOfReferenceNbrs $listOfReferenceNbrs = null)
    {
        $this->ListOfReferenceNbrs = $listOfReferenceNbrs;
        return $this;
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get ApprovedAmount value
     * @return float|null
     */
    public function getApprovedAmount()
    {
        return $this->ApprovedAmount;
    }
    /**
     * Set ApprovedAmount value
     * @param float $approvedAmount
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setApprovedAmount($approvedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($approvedAmount) && !(is_float($approvedAmount) || is_numeric($approvedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($approvedAmount, true), gettype($approvedAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($approvedAmount) && mb_strlen(mb_substr($approvedAmount, false !== mb_strpos($approvedAmount, '.') ? mb_strpos($approvedAmount, '.') + 1 : mb_strlen($approvedAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($approvedAmount, true), mb_strlen(mb_substr($approvedAmount, mb_strpos($approvedAmount, '.') + 1))), __LINE__);
        }
        $this->ApprovedAmount = $approvedAmount;
        return $this;
    }
    /**
     * Get AuthAmountSent value
     * @return float|null
     */
    public function getAuthAmountSent()
    {
        return $this->AuthAmountSent;
    }
    /**
     * Set AuthAmountSent value
     * @param float $authAmountSent
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAuthAmountSent($authAmountSent = null)
    {
        // validation for constraint: float
        if (!is_null($authAmountSent) && !(is_float($authAmountSent) || is_numeric($authAmountSent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($authAmountSent, true), gettype($authAmountSent)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($authAmountSent) && mb_strlen(mb_substr($authAmountSent, false !== mb_strpos($authAmountSent, '.') ? mb_strpos($authAmountSent, '.') + 1 : mb_strlen($authAmountSent))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($authAmountSent, true), mb_strlen(mb_substr($authAmountSent, mb_strpos($authAmountSent, '.') + 1))), __LINE__);
        }
        $this->AuthAmountSent = $authAmountSent;
        return $this;
    }
    /**
     * Get BonusAmount value
     * @return float|null
     */
    public function getBonusAmount()
    {
        return $this->BonusAmount;
    }
    /**
     * Set BonusAmount value
     * @param float $bonusAmount
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setBonusAmount($bonusAmount = null)
    {
        // validation for constraint: float
        if (!is_null($bonusAmount) && !(is_float($bonusAmount) || is_numeric($bonusAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonusAmount, true), gettype($bonusAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($bonusAmount) && mb_strlen(mb_substr($bonusAmount, false !== mb_strpos($bonusAmount, '.') ? mb_strpos($bonusAmount, '.') + 1 : mb_strlen($bonusAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($bonusAmount, true), mb_strlen(mb_substr($bonusAmount, mb_strpos($bonusAmount, '.') + 1))), __LINE__);
        }
        $this->BonusAmount = $bonusAmount;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierReferenceID value
     * @return string|null
     */
    public function getSupplierReferenceID()
    {
        return $this->SupplierReferenceID;
    }
    /**
     * Set SupplierReferenceID value
     * @param string $supplierReferenceID
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setSupplierReferenceID($supplierReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReferenceID) && !is_string($supplierReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierReferenceID, true), gettype($supplierReferenceID)), __LINE__);
        }
        $this->SupplierReferenceID = $supplierReferenceID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get AcquirerResponseCode value
     * @return string|null
     */
    public function getAcquirerResponseCode()
    {
        return $this->AcquirerResponseCode;
    }
    /**
     * Set AcquirerResponseCode value
     * @param string $acquirerResponseCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAcquirerResponseCode($acquirerResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($acquirerResponseCode) && !is_string($acquirerResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquirerResponseCode, true), gettype($acquirerResponseCode)), __LINE__);
        }
        $this->AcquirerResponseCode = $acquirerResponseCode;
        return $this;
    }
    /**
     * Get MerchantAccountNumber value
     * @return string|null
     */
    public function getMerchantAccountNumber()
    {
        return $this->MerchantAccountNumber;
    }
    /**
     * Set MerchantAccountNumber value
     * @param string $merchantAccountNumber
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setMerchantAccountNumber($merchantAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccountNumber) && !is_string($merchantAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccountNumber, true), gettype($merchantAccountNumber)), __LINE__);
        }
        $this->MerchantAccountNumber = $merchantAccountNumber;
        return $this;
    }
    /**
     * Get CAVV_ResultCode value
     * @return string|null
     */
    public function getCAVV_ResultCode()
    {
        return $this->CAVV_ResultCode;
    }
    /**
     * Set CAVV_ResultCode value
     * @param string $cAVV_ResultCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setCAVV_ResultCode($cAVV_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV_ResultCode) && !is_string($cAVV_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV_ResultCode, true), gettype($cAVV_ResultCode)), __LINE__);
        }
        $this->CAVV_ResultCode = $cAVV_ResultCode;
        return $this;
    }
    /**
     * Get AuthRemarks1 value
     * @return string|null
     */
    public function getAuthRemarks1()
    {
        return $this->AuthRemarks1;
    }
    /**
     * Set AuthRemarks1 value
     * @param string $authRemarks1
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAuthRemarks1($authRemarks1 = null)
    {
        // validation for constraint: string
        if (!is_null($authRemarks1) && !is_string($authRemarks1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authRemarks1, true), gettype($authRemarks1)), __LINE__);
        }
        $this->AuthRemarks1 = $authRemarks1;
        return $this;
    }
    /**
     * Get AuthRemarks2 value
     * @return string|null
     */
    public function getAuthRemarks2()
    {
        return $this->AuthRemarks2;
    }
    /**
     * Set AuthRemarks2 value
     * @param string $authRemarks2
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setAuthRemarks2($authRemarks2 = null)
    {
        // validation for constraint: string
        if (!is_null($authRemarks2) && !is_string($authRemarks2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authRemarks2, true), gettype($authRemarks2)), __LINE__);
        }
        $this->AuthRemarks2 = $authRemarks2;
        return $this;
    }
    /**
     * Get DCC_Remarks value
     * @return string|null
     */
    public function getDCC_Remarks()
    {
        return $this->DCC_Remarks;
    }
    /**
     * Set DCC_Remarks value
     * @param string $dCC_Remarks
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setDCC_Remarks($dCC_Remarks = null)
    {
        // validation for constraint: string
        if (!is_null($dCC_Remarks) && !is_string($dCC_Remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dCC_Remarks, true), gettype($dCC_Remarks)), __LINE__);
        }
        $this->DCC_Remarks = $dCC_Remarks;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get PaymentConfirmInd value
     * @return string|null
     */
    public function getPaymentConfirmInd()
    {
        return $this->PaymentConfirmInd;
    }
    /**
     * Set PaymentConfirmInd value
     * @param string $paymentConfirmInd
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setPaymentConfirmInd($paymentConfirmInd = null)
    {
        // validation for constraint: string
        if (!is_null($paymentConfirmInd) && !is_string($paymentConfirmInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentConfirmInd, true), gettype($paymentConfirmInd)), __LINE__);
        }
        $this->PaymentConfirmInd = $paymentConfirmInd;
        return $this;
    }
    /**
     * Get FulfillmentNotificationInd value
     * @return bool|null
     */
    public function getFulfillmentNotificationInd()
    {
        return $this->FulfillmentNotificationInd;
    }
    /**
     * Set FulfillmentNotificationInd value
     * @param bool $fulfillmentNotificationInd
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setFulfillmentNotificationInd($fulfillmentNotificationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($fulfillmentNotificationInd) && !is_bool($fulfillmentNotificationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fulfillmentNotificationInd, true), gettype($fulfillmentNotificationInd)), __LINE__);
        }
        $this->FulfillmentNotificationInd = $fulfillmentNotificationInd;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get ReverseFlagInd value
     * @return bool|null
     */
    public function getReverseFlagInd()
    {
        return $this->ReverseFlagInd;
    }
    /**
     * Set ReverseFlagInd value
     * @param bool $reverseFlagInd
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setReverseFlagInd($reverseFlagInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($reverseFlagInd) && !is_bool($reverseFlagInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reverseFlagInd, true), gettype($reverseFlagInd)), __LINE__);
        }
        $this->ReverseFlagInd = $reverseFlagInd;
        return $this;
    }
    /**
     * Get PreviouslyProcessedRqst value
     * @return bool|null
     */
    public function getPreviouslyProcessedRqst()
    {
        return $this->PreviouslyProcessedRqst;
    }
    /**
     * Set PreviouslyProcessedRqst value
     * @param bool $previouslyProcessedRqst
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setPreviouslyProcessedRqst($previouslyProcessedRqst = null)
    {
        // validation for constraint: boolean
        if (!is_null($previouslyProcessedRqst) && !is_bool($previouslyProcessedRqst)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($previouslyProcessedRqst, true), gettype($previouslyProcessedRqst)), __LINE__);
        }
        $this->PreviouslyProcessedRqst = $previouslyProcessedRqst;
        return $this;
    }
    /**
     * Get NetworkTransactionReference value
     * @return string|null
     */
    public function getNetworkTransactionReference()
    {
        return $this->NetworkTransactionReference;
    }
    /**
     * Set NetworkTransactionReference value
     * @param string $networkTransactionReference
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setNetworkTransactionReference($networkTransactionReference = null)
    {
        // validation for constraint: string
        if (!is_null($networkTransactionReference) && !is_string($networkTransactionReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkTransactionReference, true), gettype($networkTransactionReference)), __LINE__);
        }
        $this->NetworkTransactionReference = $networkTransactionReference;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResultType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
}
