<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignaturePropertiesType StructType
 * @subpackage Structs
 */
class SignaturePropertiesType extends AbstractStructBase
{
    /**
     * The SignatureProperty
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: ds:SignatureProperty
     * @var \SabrePaymentGateway\StructType\SignaturePropertyType[]
     */
    public $SignatureProperty;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignaturePropertiesType
     * @uses SignaturePropertiesType::setSignatureProperty()
     * @uses SignaturePropertiesType::setId()
     * @param \SabrePaymentGateway\StructType\SignaturePropertyType[] $signatureProperty
     * @param string $id
     */
    public function __construct(array $signatureProperty = array(), $id = null)
    {
        $this
            ->setSignatureProperty($signatureProperty)
            ->setId($id);
    }
    /**
     * Get SignatureProperty value
     * @return \SabrePaymentGateway\StructType\SignaturePropertyType[]|null
     */
    public function getSignatureProperty()
    {
        return $this->SignatureProperty;
    }
    /**
     * This method is responsible for validating the values passed to the setSignatureProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignatureProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignaturePropertyForArrayConstraintsFromSetSignatureProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $signaturePropertiesTypeSignaturePropertyItem) {
            // validation for constraint: itemType
            if (!$signaturePropertiesTypeSignaturePropertyItem instanceof \SabrePaymentGateway\StructType\SignaturePropertyType) {
                $invalidValues[] = is_object($signaturePropertiesTypeSignaturePropertyItem) ? get_class($signaturePropertiesTypeSignaturePropertyItem) : sprintf('%s(%s)', gettype($signaturePropertiesTypeSignaturePropertyItem), var_export($signaturePropertiesTypeSignaturePropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SignatureProperty property can only contain items of type \SabrePaymentGateway\StructType\SignaturePropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SignatureProperty value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\SignaturePropertyType[] $signatureProperty
     * @return \SabrePaymentGateway\StructType\SignaturePropertiesType
     */
    public function setSignatureProperty(array $signatureProperty = array())
    {
        // validation for constraint: array
        if ('' !== ($signaturePropertyArrayErrorMessage = self::validateSignaturePropertyForArrayConstraintsFromSetSignatureProperty($signatureProperty))) {
            throw new \InvalidArgumentException($signaturePropertyArrayErrorMessage, __LINE__);
        }
        $this->SignatureProperty = $signatureProperty;
        return $this;
    }
    /**
     * Add item to SignatureProperty value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\SignaturePropertyType $item
     * @return \SabrePaymentGateway\StructType\SignaturePropertiesType
     */
    public function addToSignatureProperty(\SabrePaymentGateway\StructType\SignaturePropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\SignaturePropertyType) {
            throw new \InvalidArgumentException(sprintf('The SignatureProperty property can only contain items of type \SabrePaymentGateway\StructType\SignaturePropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SignatureProperty[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \SabrePaymentGateway\StructType\SignaturePropertiesType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
