<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Result StructType
 * @subpackage Structs
 */
class Result extends AbstractStructBase
{
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResultCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The POSActionCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $POSActionCode;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ErrorCode;
    /**
     * Constructor method for Result
     * @uses Result::setResultCode()
     * @uses Result::setDescription()
     * @uses Result::setPOSActionCode()
     * @uses Result::setErrorCode()
     * @param string $resultCode
     * @param string $description
     * @param string $pOSActionCode
     * @param string $errorCode
     */
    public function __construct($resultCode = null, $description = null, $pOSActionCode = null, $errorCode = null)
    {
        $this
            ->setResultCode($resultCode)
            ->setDescription($description)
            ->setPOSActionCode($pOSActionCode)
            ->setErrorCode($errorCode);
    }
    /**
     * Get ResultCode value
     * @return string
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \SabrePaymentGateway\StructType\Result
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\Result
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get POSActionCode value
     * @return string|null
     */
    public function getPOSActionCode()
    {
        return $this->POSActionCode;
    }
    /**
     * Set POSActionCode value
     * @param string $pOSActionCode
     * @return \SabrePaymentGateway\StructType\Result
     */
    public function setPOSActionCode($pOSActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($pOSActionCode) && !is_string($pOSActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOSActionCode, true), gettype($pOSActionCode)), __LINE__);
        }
        $this->POSActionCode = $pOSActionCode;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \SabrePaymentGateway\StructType\Result
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
}
