<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerDetail StructType
 * @subpackage Structs
 */
class PassengerDetail extends PassengerDetailType
{
    /**
     * The DBIField
     * Meta information extracted from the WSDL
     * - documentation: Descriptive Billing Information (DBI) field
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\NameValueType[]
     */
    public $DBIField;
    /**
     * Constructor method for PassengerDetail
     * @uses PassengerDetail::setDBIField()
     * @param \SabrePaymentGateway\StructType\NameValueType[] $dBIField
     */
    public function __construct(array $dBIField = array())
    {
        $this
            ->setDBIField($dBIField);
    }
    /**
     * Get DBIField value
     * @return \SabrePaymentGateway\StructType\NameValueType[]|null
     */
    public function getDBIField()
    {
        return $this->DBIField;
    }
    /**
     * This method is responsible for validating the values passed to the setDBIField method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDBIField method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDBIFieldForArrayConstraintsFromSetDBIField(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $passengerDetailDBIFieldItem) {
            // validation for constraint: itemType
            if (!$passengerDetailDBIFieldItem instanceof \SabrePaymentGateway\StructType\NameValueType) {
                $invalidValues[] = is_object($passengerDetailDBIFieldItem) ? get_class($passengerDetailDBIFieldItem) : sprintf('%s(%s)', gettype($passengerDetailDBIFieldItem), var_export($passengerDetailDBIFieldItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DBIField property can only contain items of type \SabrePaymentGateway\StructType\NameValueType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DBIField value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\NameValueType[] $dBIField
     * @return \SabrePaymentGateway\StructType\PassengerDetail
     */
    public function setDBIField(array $dBIField = array())
    {
        // validation for constraint: array
        if ('' !== ($dBIFieldArrayErrorMessage = self::validateDBIFieldForArrayConstraintsFromSetDBIField($dBIField))) {
            throw new \InvalidArgumentException($dBIFieldArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($dBIField) && count($dBIField) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($dBIField)), __LINE__);
        }
        $this->DBIField = $dBIField;
        return $this;
    }
    /**
     * Add item to DBIField value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\NameValueType $item
     * @return \SabrePaymentGateway\StructType\PassengerDetail
     */
    public function addToDBIField(\SabrePaymentGateway\StructType\NameValueType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\NameValueType) {
            throw new \InvalidArgumentException(sprintf('The DBIField property can only contain items of type \SabrePaymentGateway\StructType\NameValueType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->DBIField) && count($this->DBIField) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->DBIField)), __LINE__);
        }
        $this->DBIField[] = $item;
        return $this;
    }
}
