<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkTokenDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment tokenization details of transactions that are processed with network tokenization solutions
 * @subpackage Structs
 */
class NetworkTokenDetail extends AbstractStructBase
{
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardNumber;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ExpireDate;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Network tokenization type AltID - Alternate ID (ALT ID) based Guest Checkout solution
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The TokenCryptogram
     * Meta information extracted from the WSDL
     * - documentation: Token Cryptograms - Token Authentication Verification Value (TAVV)
     * - use: optional
     * @var string
     */
    public $TokenCryptogram;
    /**
     * Constructor method for NetworkTokenDetail
     * @uses NetworkTokenDetail::setCardCode()
     * @uses NetworkTokenDetail::setCardNumber()
     * @uses NetworkTokenDetail::setExpireDate()
     * @uses NetworkTokenDetail::setType()
     * @uses NetworkTokenDetail::setTokenCryptogram()
     * @param string $cardCode
     * @param string $cardNumber
     * @param string $expireDate
     * @param string $type
     * @param string $tokenCryptogram
     */
    public function __construct($cardCode = null, $cardNumber = null, $expireDate = null, $type = null, $tokenCryptogram = null)
    {
        $this
            ->setCardCode($cardCode)
            ->setCardNumber($cardNumber)
            ->setExpireDate($expireDate)
            ->setType($type)
            ->setTokenCryptogram($tokenCryptogram);
    }
    /**
     * Get CardCode value
     * @return string
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \SabrePaymentGateway\StructType\NetworkTokenDetail
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \SabrePaymentGateway\StructType\NetworkTokenDetail
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SabrePaymentGateway\StructType\NetworkTokenDetail
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabrePaymentGateway\StructType\NetworkTokenDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TokenCryptogram value
     * @return string|null
     */
    public function getTokenCryptogram()
    {
        return $this->TokenCryptogram;
    }
    /**
     * Set TokenCryptogram value
     * @param string $tokenCryptogram
     * @return \SabrePaymentGateway\StructType\NetworkTokenDetail
     */
    public function setTokenCryptogram($tokenCryptogram = null)
    {
        // validation for constraint: string
        if (!is_null($tokenCryptogram) && !is_string($tokenCryptogram)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenCryptogram, true), gettype($tokenCryptogram)), __LINE__);
        }
        $this->TokenCryptogram = $tokenCryptogram;
        return $this;
    }
}
