<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfirmAuthResultType StructType
 * @subpackage Structs
 */
class ConfirmAuthResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The ConfirmAuthAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public $ConfirmAuthAmount;
    /**
     * The ConfirmAuthRemarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarksType
     */
    public $ConfirmAuthRemarks;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Remarks;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * Constructor method for ConfirmAuthResultType
     * @uses ConfirmAuthResultType::setResponseCode()
     * @uses ConfirmAuthResultType::setConfirmAuthAmount()
     * @uses ConfirmAuthResultType::setConfirmAuthRemarks()
     * @uses ConfirmAuthResultType::setDescription()
     * @uses ConfirmAuthResultType::setRemarks()
     * @uses ConfirmAuthResultType::setSupplierID()
     * @uses ConfirmAuthResultType::setSupplierTransID()
     * @uses ConfirmAuthResultType::setSupplierResponseCode()
     * @uses ConfirmAuthResultType::setApprovalCode()
     * @param string $responseCode
     * @param \SabrePaymentGateway\StructType\CurrencyAmountType $confirmAuthAmount
     * @param \SabrePaymentGateway\StructType\RemarksType $confirmAuthRemarks
     * @param string $description
     * @param string $remarks
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $supplierResponseCode
     * @param string $approvalCode
     */
    public function __construct($responseCode = null, \SabrePaymentGateway\StructType\CurrencyAmountType $confirmAuthAmount = null, \SabrePaymentGateway\StructType\RemarksType $confirmAuthRemarks = null, $description = null, $remarks = null, $supplierID = null, $supplierTransID = null, $supplierResponseCode = null, $approvalCode = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setConfirmAuthAmount($confirmAuthAmount)
            ->setConfirmAuthRemarks($confirmAuthRemarks)
            ->setDescription($description)
            ->setRemarks($remarks)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setApprovalCode($approvalCode);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ConfirmAuthAmount value
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType|null
     */
    public function getConfirmAuthAmount()
    {
        return $this->ConfirmAuthAmount;
    }
    /**
     * Set ConfirmAuthAmount value
     * @param \SabrePaymentGateway\StructType\CurrencyAmountType $confirmAuthAmount
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setConfirmAuthAmount(\SabrePaymentGateway\StructType\CurrencyAmountType $confirmAuthAmount = null)
    {
        $this->ConfirmAuthAmount = $confirmAuthAmount;
        return $this;
    }
    /**
     * Get ConfirmAuthRemarks value
     * @return \SabrePaymentGateway\StructType\RemarksType|null
     */
    public function getConfirmAuthRemarks()
    {
        return $this->ConfirmAuthRemarks;
    }
    /**
     * Set ConfirmAuthRemarks value
     * @param \SabrePaymentGateway\StructType\RemarksType $confirmAuthRemarks
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setConfirmAuthRemarks(\SabrePaymentGateway\StructType\RemarksType $confirmAuthRemarks = null)
    {
        $this->ConfirmAuthRemarks = $confirmAuthRemarks;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setRemarks($remarks = null)
    {
        // validation for constraint: string
        if (!is_null($remarks) && !is_string($remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarks, true), gettype($remarks)), __LINE__);
        }
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \SabrePaymentGateway\StructType\ConfirmAuthResultType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
}
