<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardIssuerName StructType
 * Meta information extracted from the WSDL
 * - documentation: Name of bank or organization issuing the card (e.g., alumni association, bank, fraternal organization). | Issuer of the card.
 * @subpackage Structs
 */
class CardIssuerName extends AbstractStructBase
{
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $BankName;
    /**
     * The BankID
     * Meta information extracted from the WSDL
     * - documentation: Code of bank issuing the card.
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $BankID;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for CardIssuerName
     * @uses CardIssuerName::setBankName()
     * @uses CardIssuerName::setBankID()
     * @uses CardIssuerName::setCountryCode()
     * @param string $bankName
     * @param string $bankID
     * @param string $countryCode
     */
    public function __construct($bankName = null, $bankID = null, $countryCode = null)
    {
        $this
            ->setBankName($bankName)
            ->setBankID($bankID)
            ->setCountryCode($countryCode);
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \SabrePaymentGateway\StructType\CardIssuerName
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get BankID value
     * @return string|null
     */
    public function getBankID()
    {
        return $this->BankID;
    }
    /**
     * Set BankID value
     * @param string $bankID
     * @return \SabrePaymentGateway\StructType\CardIssuerName
     */
    public function setBankID($bankID = null)
    {
        // validation for constraint: string
        if (!is_null($bankID) && !is_string($bankID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankID, true), gettype($bankID)), __LINE__);
        }
        $this->BankID = $bankID;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \SabrePaymentGateway\StructType\CardIssuerName
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
}
