<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reference StructType
 * Meta information extracted from the WSDL
 * - type: ds:ReferenceType
 * @subpackage Structs
 */
class Reference extends AbstractStructBase
{
    /**
     * The href
     * Meta information extracted from the WSDL
     * - ref: xlink:href
     * - use: required
     * @var string
     */
    public $href;
    /**
     * The Schema
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Schema
     * @var \SabrePaymentGateway\StructType\Schema[]
     */
    public $Schema;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: tns:Description
     * @var \SabrePaymentGateway\StructType\Description[]
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - ref: tns:id
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - fixed: simple
     * - ref: xlink:type
     * @var string
     */
    public $type;
    /**
     * The role
     * Meta information extracted from the WSDL
     * - ref: xlink:role
     * @var string
     */
    public $role;
    /**
     * Constructor method for Reference
     * @uses Reference::setHref()
     * @uses Reference::setSchema()
     * @uses Reference::setDescription()
     * @uses Reference::setAny()
     * @uses Reference::setId()
     * @uses Reference::setType()
     * @uses Reference::setRole()
     * @param string $href
     * @param \SabrePaymentGateway\StructType\Schema[] $schema
     * @param \SabrePaymentGateway\StructType\Description[] $description
     * @param \DOMDocument $any
     * @param string $id
     * @param string $type
     * @param string $role
     */
    public function __construct($href = null, array $schema = array(), array $description = array(), \DOMDocument $any = null, $id = null, $type = null, $role = null)
    {
        $this
            ->setHref($href)
            ->setSchema($schema)
            ->setDescription($description)
            ->setAny($any)
            ->setId($id)
            ->setType($type)
            ->setRole($role);
    }
    /**
     * Get href value
     * @return string
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function setHref($href = null)
    {
        // validation for constraint: string
        if (!is_null($href) && !is_string($href)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($href, true), gettype($href)), __LINE__);
        }
        $this->href = $href;
        return $this;
    }
    /**
     * Get Schema value
     * @return \SabrePaymentGateway\StructType\Schema[]|null
     */
    public function getSchema()
    {
        return $this->Schema;
    }
    /**
     * This method is responsible for validating the values passed to the setSchema method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchema method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSchemaForArrayConstraintsFromSetSchema(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referenceSchemaItem) {
            // validation for constraint: itemType
            if (!$referenceSchemaItem instanceof \SabrePaymentGateway\StructType\Schema) {
                $invalidValues[] = is_object($referenceSchemaItem) ? get_class($referenceSchemaItem) : sprintf('%s(%s)', gettype($referenceSchemaItem), var_export($referenceSchemaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schema property can only contain items of type \SabrePaymentGateway\StructType\Schema, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schema value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Schema[] $schema
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function setSchema(array $schema = array())
    {
        // validation for constraint: array
        if ('' !== ($schemaArrayErrorMessage = self::validateSchemaForArrayConstraintsFromSetSchema($schema))) {
            throw new \InvalidArgumentException($schemaArrayErrorMessage, __LINE__);
        }
        $this->Schema = $schema;
        return $this;
    }
    /**
     * Add item to Schema value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Schema $item
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function addToSchema(\SabrePaymentGateway\StructType\Schema $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Schema) {
            throw new \InvalidArgumentException(sprintf('The Schema property can only contain items of type \SabrePaymentGateway\StructType\Schema, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schema[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return \SabrePaymentGateway\StructType\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $referenceDescriptionItem) {
            // validation for constraint: itemType
            if (!$referenceDescriptionItem instanceof \SabrePaymentGateway\StructType\Description) {
                $invalidValues[] = is_object($referenceDescriptionItem) ? get_class($referenceDescriptionItem) : sprintf('%s(%s)', gettype($referenceDescriptionItem), var_export($referenceDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type \SabrePaymentGateway\StructType\Description, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Description[] $description
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Description $item
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function addToDescription(\SabrePaymentGateway\StructType\Description $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Description) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type \SabrePaymentGateway\StructType\Description, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \SabrePaymentGateway\StructType\Reference
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
}
