<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NotificationList StructType
 * @subpackage Structs
 */
class NotificationList extends AbstractStructBase
{
    /**
     * The Notification
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \SabrePaymentGateway\StructType\Notification[]
     */
    public $Notification;
    /**
     * Constructor method for NotificationList
     * @uses NotificationList::setNotification()
     * @param \SabrePaymentGateway\StructType\Notification[] $notification
     */
    public function __construct(array $notification = array())
    {
        $this
            ->setNotification($notification);
    }
    /**
     * Get Notification value
     * @return \SabrePaymentGateway\StructType\Notification[]|null
     */
    public function getNotification()
    {
        return $this->Notification;
    }
    /**
     * This method is responsible for validating the values passed to the setNotification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNotification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNotificationForArrayConstraintsFromSetNotification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $notificationListNotificationItem) {
            // validation for constraint: itemType
            if (!$notificationListNotificationItem instanceof \SabrePaymentGateway\StructType\Notification) {
                $invalidValues[] = is_object($notificationListNotificationItem) ? get_class($notificationListNotificationItem) : sprintf('%s(%s)', gettype($notificationListNotificationItem), var_export($notificationListNotificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Notification property can only contain items of type \SabrePaymentGateway\StructType\Notification, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Notification value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Notification[] $notification
     * @return \SabrePaymentGateway\StructType\NotificationList
     */
    public function setNotification(array $notification = array())
    {
        // validation for constraint: array
        if ('' !== ($notificationArrayErrorMessage = self::validateNotificationForArrayConstraintsFromSetNotification($notification))) {
            throw new \InvalidArgumentException($notificationArrayErrorMessage, __LINE__);
        }
        $this->Notification = $notification;
        return $this;
    }
    /**
     * Add item to Notification value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Notification $item
     * @return \SabrePaymentGateway\StructType\NotificationList
     */
    public function addToNotification(\SabrePaymentGateway\StructType\Notification $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Notification) {
            throw new \InvalidArgumentException(sprintf('The Notification property can only contain items of type \SabrePaymentGateway\StructType\Notification, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Notification[] = $item;
        return $this;
    }
}
