<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCardActivityResultType StructType
 * @subpackage Structs
 */
class GetCardActivityResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The CardActivities
     * Meta information extracted from the WSDL
     * - documentation: List of card activities occured to the virtual card
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CardActivityType[]
     */
    public $CardActivities;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * Constructor method for GetCardActivityResultType
     * @uses GetCardActivityResultType::setResponseCode()
     * @uses GetCardActivityResultType::setCardActivities()
     * @uses GetCardActivityResultType::setDescription()
     * @uses GetCardActivityResultType::setSupplierID()
     * @param string $responseCode
     * @param \SabrePaymentGateway\StructType\CardActivityType[] $cardActivities
     * @param string $description
     * @param string $supplierID
     */
    public function __construct($responseCode = null, array $cardActivities = array(), $description = null, $supplierID = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setCardActivities($cardActivities)
            ->setDescription($description)
            ->setSupplierID($supplierID);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\GetCardActivityResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get CardActivities value
     * @return \SabrePaymentGateway\StructType\CardActivityType[]|null
     */
    public function getCardActivities()
    {
        return $this->CardActivities;
    }
    /**
     * This method is responsible for validating the values passed to the setCardActivities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCardActivities method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardActivitiesForArrayConstraintsFromSetCardActivities(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCardActivityResultTypeCardActivitiesItem) {
            // validation for constraint: itemType
            if (!$getCardActivityResultTypeCardActivitiesItem instanceof \SabrePaymentGateway\StructType\CardActivityType) {
                $invalidValues[] = is_object($getCardActivityResultTypeCardActivitiesItem) ? get_class($getCardActivityResultTypeCardActivitiesItem) : sprintf('%s(%s)', gettype($getCardActivityResultTypeCardActivitiesItem), var_export($getCardActivityResultTypeCardActivitiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CardActivities property can only contain items of type \SabrePaymentGateway\StructType\CardActivityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CardActivities value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\CardActivityType[] $cardActivities
     * @return \SabrePaymentGateway\StructType\GetCardActivityResultType
     */
    public function setCardActivities(array $cardActivities = array())
    {
        // validation for constraint: array
        if ('' !== ($cardActivitiesArrayErrorMessage = self::validateCardActivitiesForArrayConstraintsFromSetCardActivities($cardActivities))) {
            throw new \InvalidArgumentException($cardActivitiesArrayErrorMessage, __LINE__);
        }
        $this->CardActivities = $cardActivities;
        return $this;
    }
    /**
     * Add item to CardActivities value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\CardActivityType $item
     * @return \SabrePaymentGateway\StructType\GetCardActivityResultType
     */
    public function addToCardActivities(\SabrePaymentGateway\StructType\CardActivityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\CardActivityType) {
            throw new \InvalidArgumentException(sprintf('The CardActivities property can only contain items of type \SabrePaymentGateway\StructType\CardActivityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CardActivities[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\GetCardActivityResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\GetCardActivityResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
}
