<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeBreakType StructType
 * @subpackage Structs
 */
class FeeBreakType extends AbstractStructBase
{
    /**
     * The TaxBreak
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\TaxType[]
     */
    public $TaxBreak;
    /**
     * The FeeType
     * @var string
     */
    public $FeeType;
    /**
     * The FeeCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FeeCode;
    /**
     * The BaseFee
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BaseFee;
    /**
     * The FeeTaxes
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $FeeTaxes;
    /**
     * Constructor method for FeeBreakType
     * @uses FeeBreakType::setTaxBreak()
     * @uses FeeBreakType::setFeeType()
     * @uses FeeBreakType::setFeeCode()
     * @uses FeeBreakType::setBaseFee()
     * @uses FeeBreakType::setFeeTaxes()
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @param string $feeType
     * @param string $feeCode
     * @param float $baseFee
     * @param float $feeTaxes
     */
    public function __construct(array $taxBreak = array(), $feeType = null, $feeCode = null, $baseFee = null, $feeTaxes = null)
    {
        $this
            ->setTaxBreak($taxBreak)
            ->setFeeType($feeType)
            ->setFeeCode($feeCode)
            ->setBaseFee($baseFee)
            ->setFeeTaxes($feeTaxes);
    }
    /**
     * Get TaxBreak value
     * @return \SabrePaymentGateway\StructType\TaxType[]|null
     */
    public function getTaxBreak()
    {
        return $this->TaxBreak;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxBreak method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxBreak method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxBreakForArrayConstraintsFromSetTaxBreak(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $feeBreakTypeTaxBreakItem) {
            // validation for constraint: itemType
            if (!$feeBreakTypeTaxBreakItem instanceof \SabrePaymentGateway\StructType\TaxType) {
                $invalidValues[] = is_object($feeBreakTypeTaxBreakItem) ? get_class($feeBreakTypeTaxBreakItem) : sprintf('%s(%s)', gettype($feeBreakTypeTaxBreakItem), var_export($feeBreakTypeTaxBreakItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @return \SabrePaymentGateway\StructType\FeeBreakType
     */
    public function setTaxBreak(array $taxBreak = array())
    {
        // validation for constraint: array
        if ('' !== ($taxBreakArrayErrorMessage = self::validateTaxBreakForArrayConstraintsFromSetTaxBreak($taxBreak))) {
            throw new \InvalidArgumentException($taxBreakArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxBreak) && count($taxBreak) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxBreak)), __LINE__);
        }
        $this->TaxBreak = $taxBreak;
        return $this;
    }
    /**
     * Add item to TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType $item
     * @return \SabrePaymentGateway\StructType\FeeBreakType
     */
    public function addToTaxBreak(\SabrePaymentGateway\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TaxBreak) && count($this->TaxBreak) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TaxBreak)), __LINE__);
        }
        $this->TaxBreak[] = $item;
        return $this;
    }
    /**
     * Get FeeType value
     * @return string|null
     */
    public function getFeeType()
    {
        return $this->FeeType;
    }
    /**
     * Set FeeType value
     * @param string $feeType
     * @return \SabrePaymentGateway\StructType\FeeBreakType
     */
    public function setFeeType($feeType = null)
    {
        // validation for constraint: string
        if (!is_null($feeType) && !is_string($feeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeType, true), gettype($feeType)), __LINE__);
        }
        $this->FeeType = $feeType;
        return $this;
    }
    /**
     * Get FeeCode value
     * @return string|null
     */
    public function getFeeCode()
    {
        return $this->FeeCode;
    }
    /**
     * Set FeeCode value
     * @param string $feeCode
     * @return \SabrePaymentGateway\StructType\FeeBreakType
     */
    public function setFeeCode($feeCode = null)
    {
        // validation for constraint: string
        if (!is_null($feeCode) && !is_string($feeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeCode, true), gettype($feeCode)), __LINE__);
        }
        $this->FeeCode = $feeCode;
        return $this;
    }
    /**
     * Get BaseFee value
     * @return float|null
     */
    public function getBaseFee()
    {
        return $this->BaseFee;
    }
    /**
     * Set BaseFee value
     * @param float $baseFee
     * @return \SabrePaymentGateway\StructType\FeeBreakType
     */
    public function setBaseFee($baseFee = null)
    {
        // validation for constraint: float
        if (!is_null($baseFee) && !(is_float($baseFee) || is_numeric($baseFee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFee, true), gettype($baseFee)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($baseFee) && mb_strlen(mb_substr($baseFee, false !== mb_strpos($baseFee, '.') ? mb_strpos($baseFee, '.') + 1 : mb_strlen($baseFee))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($baseFee, true), mb_strlen(mb_substr($baseFee, mb_strpos($baseFee, '.') + 1))), __LINE__);
        }
        $this->BaseFee = $baseFee;
        return $this;
    }
    /**
     * Get FeeTaxes value
     * @return float|null
     */
    public function getFeeTaxes()
    {
        return $this->FeeTaxes;
    }
    /**
     * Set FeeTaxes value
     * @param float $feeTaxes
     * @return \SabrePaymentGateway\StructType\FeeBreakType
     */
    public function setFeeTaxes($feeTaxes = null)
    {
        // validation for constraint: float
        if (!is_null($feeTaxes) && !(is_float($feeTaxes) || is_numeric($feeTaxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($feeTaxes, true), gettype($feeTaxes)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($feeTaxes) && mb_strlen(mb_substr($feeTaxes, false !== mb_strpos($feeTaxes, '.') ? mb_strpos($feeTaxes, '.') + 1 : mb_strlen($feeTaxes))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($feeTaxes, true), mb_strlen(mb_substr($feeTaxes, mb_strpos($feeTaxes, '.') + 1))), __LINE__);
        }
        $this->FeeTaxes = $feeTaxes;
        return $this;
    }
}
