<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FOP_FareBreakType StructType
 * Meta information extracted from the WSDL
 * - documentation: Farebreak at FOP level
 * @subpackage Structs
 */
class FOP_FareBreakType extends AbstractStructBase
{
    /**
     * The FOP_Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $FOP_Type;
    /**
     * The FOP_TotalAmt
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: required
     * @var float
     */
    public $FOP_TotalAmt;
    /**
     * The FOP_Code
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FOP_Code;
    /**
     * The CardNbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardNbr;
    /**
     * The TokenizedCardNbr
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TokenizedCardNbr;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * The ApprovalCode
     * @var string
     */
    public $ApprovalCode;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BaseFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Fees;
    /**
     * The PaymentCurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentCurrencyAmt
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $PaymentCurrencyAmt;
    /**
     * The FOP_TotalPoints
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $FOP_TotalPoints;
    /**
     * The BasePoints
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $BasePoints;
    /**
     * The TaxPoints
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $TaxPoints;
    /**
     * The FeePoints
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $FeePoints;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentRef;
    /**
     * Constructor method for FOP_FareBreakType
     * @uses FOP_FareBreakType::setFOP_Type()
     * @uses FOP_FareBreakType::setFOP_TotalAmt()
     * @uses FOP_FareBreakType::setFOP_Code()
     * @uses FOP_FareBreakType::setCardNbr()
     * @uses FOP_FareBreakType::setTokenizedCardNbr()
     * @uses FOP_FareBreakType::setExpireDate()
     * @uses FOP_FareBreakType::setApprovalCode()
     * @uses FOP_FareBreakType::setCurrencyCode()
     * @uses FOP_FareBreakType::setBaseFare()
     * @uses FOP_FareBreakType::setTaxes()
     * @uses FOP_FareBreakType::setFees()
     * @uses FOP_FareBreakType::setPaymentCurrencyCode()
     * @uses FOP_FareBreakType::setPaymentCurrencyAmt()
     * @uses FOP_FareBreakType::setFOP_TotalPoints()
     * @uses FOP_FareBreakType::setBasePoints()
     * @uses FOP_FareBreakType::setTaxPoints()
     * @uses FOP_FareBreakType::setFeePoints()
     * @uses FOP_FareBreakType::setPaymentRef()
     * @param string $fOP_Type
     * @param float $fOP_TotalAmt
     * @param string $fOP_Code
     * @param string $cardNbr
     * @param string $tokenizedCardNbr
     * @param string $expireDate
     * @param string $approvalCode
     * @param string $currencyCode
     * @param float $baseFare
     * @param float $taxes
     * @param float $fees
     * @param string $paymentCurrencyCode
     * @param float $paymentCurrencyAmt
     * @param int $fOP_TotalPoints
     * @param int $basePoints
     * @param int $taxPoints
     * @param int $feePoints
     * @param string $paymentRef
     */
    public function __construct($fOP_Type = null, $fOP_TotalAmt = null, $fOP_Code = null, $cardNbr = null, $tokenizedCardNbr = null, $expireDate = null, $approvalCode = null, $currencyCode = null, $baseFare = null, $taxes = null, $fees = null, $paymentCurrencyCode = null, $paymentCurrencyAmt = null, $fOP_TotalPoints = null, $basePoints = null, $taxPoints = null, $feePoints = null, $paymentRef = null)
    {
        $this
            ->setFOP_Type($fOP_Type)
            ->setFOP_TotalAmt($fOP_TotalAmt)
            ->setFOP_Code($fOP_Code)
            ->setCardNbr($cardNbr)
            ->setTokenizedCardNbr($tokenizedCardNbr)
            ->setExpireDate($expireDate)
            ->setApprovalCode($approvalCode)
            ->setCurrencyCode($currencyCode)
            ->setBaseFare($baseFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentCurrencyAmt($paymentCurrencyAmt)
            ->setFOP_TotalPoints($fOP_TotalPoints)
            ->setBasePoints($basePoints)
            ->setTaxPoints($taxPoints)
            ->setFeePoints($feePoints)
            ->setPaymentRef($paymentRef);
    }
    /**
     * Get FOP_Type value
     * @return string
     */
    public function getFOP_Type()
    {
        return $this->FOP_Type;
    }
    /**
     * Set FOP_Type value
     * @param string $fOP_Type
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setFOP_Type($fOP_Type = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_Type) && !is_string($fOP_Type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_Type, true), gettype($fOP_Type)), __LINE__);
        }
        $this->FOP_Type = $fOP_Type;
        return $this;
    }
    /**
     * Get FOP_TotalAmt value
     * @return float
     */
    public function getFOP_TotalAmt()
    {
        return $this->FOP_TotalAmt;
    }
    /**
     * Set FOP_TotalAmt value
     * @param float $fOP_TotalAmt
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setFOP_TotalAmt($fOP_TotalAmt = null)
    {
        // validation for constraint: float
        if (!is_null($fOP_TotalAmt) && !(is_float($fOP_TotalAmt) || is_numeric($fOP_TotalAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fOP_TotalAmt, true), gettype($fOP_TotalAmt)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fOP_TotalAmt) && mb_strlen(mb_substr($fOP_TotalAmt, false !== mb_strpos($fOP_TotalAmt, '.') ? mb_strpos($fOP_TotalAmt, '.') + 1 : mb_strlen($fOP_TotalAmt))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fOP_TotalAmt, true), mb_strlen(mb_substr($fOP_TotalAmt, mb_strpos($fOP_TotalAmt, '.') + 1))), __LINE__);
        }
        $this->FOP_TotalAmt = $fOP_TotalAmt;
        return $this;
    }
    /**
     * Get FOP_Code value
     * @return string|null
     */
    public function getFOP_Code()
    {
        return $this->FOP_Code;
    }
    /**
     * Set FOP_Code value
     * @param string $fOP_Code
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setFOP_Code($fOP_Code = null)
    {
        // validation for constraint: string
        if (!is_null($fOP_Code) && !is_string($fOP_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOP_Code, true), gettype($fOP_Code)), __LINE__);
        }
        $this->FOP_Code = $fOP_Code;
        return $this;
    }
    /**
     * Get CardNbr value
     * @return string|null
     */
    public function getCardNbr()
    {
        return $this->CardNbr;
    }
    /**
     * Set CardNbr value
     * @param string $cardNbr
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setCardNbr($cardNbr = null)
    {
        // validation for constraint: string
        if (!is_null($cardNbr) && !is_string($cardNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNbr, true), gettype($cardNbr)), __LINE__);
        }
        $this->CardNbr = $cardNbr;
        return $this;
    }
    /**
     * Get TokenizedCardNbr value
     * @return string|null
     */
    public function getTokenizedCardNbr()
    {
        return $this->TokenizedCardNbr;
    }
    /**
     * Set TokenizedCardNbr value
     * @param string $tokenizedCardNbr
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setTokenizedCardNbr($tokenizedCardNbr = null)
    {
        // validation for constraint: string
        if (!is_null($tokenizedCardNbr) && !is_string($tokenizedCardNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenizedCardNbr, true), gettype($tokenizedCardNbr)), __LINE__);
        }
        $this->TokenizedCardNbr = $tokenizedCardNbr;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return float|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param float $baseFare
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setBaseFare($baseFare = null)
    {
        // validation for constraint: float
        if (!is_null($baseFare) && !(is_float($baseFare) || is_numeric($baseFare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFare, true), gettype($baseFare)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($baseFare) && mb_strlen(mb_substr($baseFare, false !== mb_strpos($baseFare, '.') ? mb_strpos($baseFare, '.') + 1 : mb_strlen($baseFare))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($baseFare, true), mb_strlen(mb_substr($baseFare, mb_strpos($baseFare, '.') + 1))), __LINE__);
        }
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param float $taxes
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setTaxes($taxes = null)
    {
        // validation for constraint: float
        if (!is_null($taxes) && !(is_float($taxes) || is_numeric($taxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxes, true), gettype($taxes)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($taxes) && mb_strlen(mb_substr($taxes, false !== mb_strpos($taxes, '.') ? mb_strpos($taxes, '.') + 1 : mb_strlen($taxes))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($taxes, true), mb_strlen(mb_substr($taxes, mb_strpos($taxes, '.') + 1))), __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return float|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param float $fees
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setFees($fees = null)
    {
        // validation for constraint: float
        if (!is_null($fees) && !(is_float($fees) || is_numeric($fees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fees, true), gettype($fees)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fees) && mb_strlen(mb_substr($fees, false !== mb_strpos($fees, '.') ? mb_strpos($fees, '.') + 1 : mb_strlen($fees))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fees, true), mb_strlen(mb_substr($fees, mb_strpos($fees, '.') + 1))), __LINE__);
        }
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get PaymentCurrencyCode value
     * @return string|null
     */
    public function getPaymentCurrencyCode()
    {
        return $this->PaymentCurrencyCode;
    }
    /**
     * Set PaymentCurrencyCode value
     * @param string $paymentCurrencyCode
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setPaymentCurrencyCode($paymentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCurrencyCode) && !is_string($paymentCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCurrencyCode, true), gettype($paymentCurrencyCode)), __LINE__);
        }
        $this->PaymentCurrencyCode = $paymentCurrencyCode;
        return $this;
    }
    /**
     * Get PaymentCurrencyAmt value
     * @return float|null
     */
    public function getPaymentCurrencyAmt()
    {
        return $this->PaymentCurrencyAmt;
    }
    /**
     * Set PaymentCurrencyAmt value
     * @param float $paymentCurrencyAmt
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setPaymentCurrencyAmt($paymentCurrencyAmt = null)
    {
        // validation for constraint: float
        if (!is_null($paymentCurrencyAmt) && !(is_float($paymentCurrencyAmt) || is_numeric($paymentCurrencyAmt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($paymentCurrencyAmt, true), gettype($paymentCurrencyAmt)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($paymentCurrencyAmt) && mb_strlen(mb_substr($paymentCurrencyAmt, false !== mb_strpos($paymentCurrencyAmt, '.') ? mb_strpos($paymentCurrencyAmt, '.') + 1 : mb_strlen($paymentCurrencyAmt))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($paymentCurrencyAmt, true), mb_strlen(mb_substr($paymentCurrencyAmt, mb_strpos($paymentCurrencyAmt, '.') + 1))), __LINE__);
        }
        $this->PaymentCurrencyAmt = $paymentCurrencyAmt;
        return $this;
    }
    /**
     * Get FOP_TotalPoints value
     * @return int|null
     */
    public function getFOP_TotalPoints()
    {
        return $this->FOP_TotalPoints;
    }
    /**
     * Set FOP_TotalPoints value
     * @param int $fOP_TotalPoints
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setFOP_TotalPoints($fOP_TotalPoints = null)
    {
        // validation for constraint: int
        if (!is_null($fOP_TotalPoints) && !(is_int($fOP_TotalPoints) || ctype_digit($fOP_TotalPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fOP_TotalPoints, true), gettype($fOP_TotalPoints)), __LINE__);
        }
        $this->FOP_TotalPoints = $fOP_TotalPoints;
        return $this;
    }
    /**
     * Get BasePoints value
     * @return int|null
     */
    public function getBasePoints()
    {
        return $this->BasePoints;
    }
    /**
     * Set BasePoints value
     * @param int $basePoints
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setBasePoints($basePoints = null)
    {
        // validation for constraint: int
        if (!is_null($basePoints) && !(is_int($basePoints) || ctype_digit($basePoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($basePoints, true), gettype($basePoints)), __LINE__);
        }
        $this->BasePoints = $basePoints;
        return $this;
    }
    /**
     * Get TaxPoints value
     * @return int|null
     */
    public function getTaxPoints()
    {
        return $this->TaxPoints;
    }
    /**
     * Set TaxPoints value
     * @param int $taxPoints
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setTaxPoints($taxPoints = null)
    {
        // validation for constraint: int
        if (!is_null($taxPoints) && !(is_int($taxPoints) || ctype_digit($taxPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxPoints, true), gettype($taxPoints)), __LINE__);
        }
        $this->TaxPoints = $taxPoints;
        return $this;
    }
    /**
     * Get FeePoints value
     * @return int|null
     */
    public function getFeePoints()
    {
        return $this->FeePoints;
    }
    /**
     * Set FeePoints value
     * @param int $feePoints
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setFeePoints($feePoints = null)
    {
        // validation for constraint: int
        if (!is_null($feePoints) && !(is_int($feePoints) || ctype_digit($feePoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feePoints, true), gettype($feePoints)), __LINE__);
        }
        $this->FeePoints = $feePoints;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
}
