<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Document detail
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocType
     * Meta information extracted from the WSDL
     * - documentation: TKT - Ticket EMD MSR - Misc Sales Receipt EXB - Excess Baggage RFD - Refund, VCH - Voucher
     * - use: required
     * @var string
     */
    public $DocType;
    /**
     * The FOP_Amount
     * Meta information extracted from the WSDL
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\FOP_FareBreakType[]
     */
    public $FOP_Amount;
    /**
     * The TaxBreak
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\TaxType[]
     */
    public $TaxBreak;
    /**
     * The FeeBreak
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\FeeBreakType[]
     */
    public $FeeBreak;
    /**
     * The MiscItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\MiscItemType[]
     */
    public $MiscItem;
    /**
     * The FareCalc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FareCalc;
    /**
     * The EMD_CouponDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\EMD_CouponDetail[]
     */
    public $EMD_CouponDetail;
    /**
     * The DOC_RPH
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DOC_RPH;
    /**
     * The DocTypeDescription
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DocTypeDescription;
    /**
     * The DocStatus
     * Meta information extracted from the WSDL
     * - documentation: N - New (Default) O - Original (the one being exchanged or refunded)
     * - use: optional
     * @var string
     */
    public $DocStatus;
    /**
     * The IssueLocation
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IssueLocation;
    /**
     * The IssueDateTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IssueDateTime;
    /**
     * The eTicketInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $eTicketInd;
    /**
     * The NetFareInd
     * Meta information extracted from the WSDL
     * - use: optional
     * @var bool
     */
    public $NetFareInd;
    /**
     * The DocNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DocNumber;
    /**
     * The CouponNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CouponNumber;
    /**
     * The DocCurrency
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DocCurrency;
    /**
     * The DocAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $DocAmount;
    /**
     * The BaseFare
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $BaseFare;
    /**
     * The NetFare
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $NetFare;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Taxes;
    /**
     * The Fees
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $Fees;
    /**
     * The Points
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Points;
    /**
     * The CategoryCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CategoryCode;
    /**
     * The FlightDetailIndex
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $FlightDetailIndex;
    /**
     * The InitialDocNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InitialDocNumber;
    /**
     * The InitialDocType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $InitialDocType;
    /**
     * The AssociatedDocNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AssociatedDocNumber;
    /**
     * The DocSubType
     * Meta information extracted from the WSDL
     * - documentation: For EMD, this could be A or S.
     * - use: optional
     * @var string
     */
    public $DocSubType;
    /**
     * The EMD_GroupCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EMD_GroupCode;
    /**
     * The RFI_Code
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RFI_Code;
    /**
     * The CardCurrency
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardCurrency;
    /**
     * The CardCurrencyDocAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $CardCurrencyDocAmount;
    /**
     * The AlternateCurrency
     * Meta information extracted from the WSDL
     * - documentation: Currency that merchants setup and offer
     * - use: optional
     * @var string
     */
    public $AlternateCurrency;
    /**
     * The AlternateCurrencyDocAmount
     * Meta information extracted from the WSDL
     * - documentation: Amount in currency that merchants setup and offer | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $AlternateCurrencyDocAmount;
    /**
     * The TCN_Nbr
     * Meta information extracted from the WSDL
     * - documentation: Transaction Control Number including check digit
     * @var string
     */
    public $TCN_Nbr;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocType()
     * @uses DocumentType::setFOP_Amount()
     * @uses DocumentType::setTaxBreak()
     * @uses DocumentType::setFeeBreak()
     * @uses DocumentType::setMiscItem()
     * @uses DocumentType::setFareCalc()
     * @uses DocumentType::setEMD_CouponDetail()
     * @uses DocumentType::setDOC_RPH()
     * @uses DocumentType::setDocTypeDescription()
     * @uses DocumentType::setDocStatus()
     * @uses DocumentType::setIssueLocation()
     * @uses DocumentType::setIssueDateTime()
     * @uses DocumentType::setETicketInd()
     * @uses DocumentType::setNetFareInd()
     * @uses DocumentType::setDocNumber()
     * @uses DocumentType::setCouponNumber()
     * @uses DocumentType::setDocCurrency()
     * @uses DocumentType::setDocAmount()
     * @uses DocumentType::setBaseFare()
     * @uses DocumentType::setNetFare()
     * @uses DocumentType::setTaxes()
     * @uses DocumentType::setFees()
     * @uses DocumentType::setPoints()
     * @uses DocumentType::setCategoryCode()
     * @uses DocumentType::setFlightDetailIndex()
     * @uses DocumentType::setInitialDocNumber()
     * @uses DocumentType::setInitialDocType()
     * @uses DocumentType::setAssociatedDocNumber()
     * @uses DocumentType::setDocSubType()
     * @uses DocumentType::setEMD_GroupCode()
     * @uses DocumentType::setRFI_Code()
     * @uses DocumentType::setCardCurrency()
     * @uses DocumentType::setCardCurrencyDocAmount()
     * @uses DocumentType::setAlternateCurrency()
     * @uses DocumentType::setAlternateCurrencyDocAmount()
     * @uses DocumentType::setTCN_Nbr()
     * @param string $docType
     * @param \SabrePaymentGateway\StructType\FOP_FareBreakType[] $fOP_Amount
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @param \SabrePaymentGateway\StructType\FeeBreakType[] $feeBreak
     * @param \SabrePaymentGateway\StructType\MiscItemType[] $miscItem
     * @param string $fareCalc
     * @param \SabrePaymentGateway\StructType\EMD_CouponDetail[] $eMD_CouponDetail
     * @param string $dOC_RPH
     * @param string $docTypeDescription
     * @param string $docStatus
     * @param string $issueLocation
     * @param string $issueDateTime
     * @param bool $eTicketInd
     * @param bool $netFareInd
     * @param string $docNumber
     * @param string $couponNumber
     * @param string $docCurrency
     * @param float $docAmount
     * @param float $baseFare
     * @param float $netFare
     * @param float $taxes
     * @param float $fees
     * @param int $points
     * @param string $categoryCode
     * @param int $flightDetailIndex
     * @param string $initialDocNumber
     * @param string $initialDocType
     * @param string $associatedDocNumber
     * @param string $docSubType
     * @param string $eMD_GroupCode
     * @param string $rFI_Code
     * @param string $cardCurrency
     * @param float $cardCurrencyDocAmount
     * @param string $alternateCurrency
     * @param float $alternateCurrencyDocAmount
     * @param string $tCN_Nbr
     */
    public function __construct($docType = null, array $fOP_Amount = array(), array $taxBreak = array(), array $feeBreak = array(), array $miscItem = array(), $fareCalc = null, array $eMD_CouponDetail = array(), $dOC_RPH = null, $docTypeDescription = null, $docStatus = null, $issueLocation = null, $issueDateTime = null, $eTicketInd = null, $netFareInd = null, $docNumber = null, $couponNumber = null, $docCurrency = null, $docAmount = null, $baseFare = null, $netFare = null, $taxes = null, $fees = null, $points = null, $categoryCode = null, $flightDetailIndex = null, $initialDocNumber = null, $initialDocType = null, $associatedDocNumber = null, $docSubType = null, $eMD_GroupCode = null, $rFI_Code = null, $cardCurrency = null, $cardCurrencyDocAmount = null, $alternateCurrency = null, $alternateCurrencyDocAmount = null, $tCN_Nbr = null)
    {
        $this
            ->setDocType($docType)
            ->setFOP_Amount($fOP_Amount)
            ->setTaxBreak($taxBreak)
            ->setFeeBreak($feeBreak)
            ->setMiscItem($miscItem)
            ->setFareCalc($fareCalc)
            ->setEMD_CouponDetail($eMD_CouponDetail)
            ->setDOC_RPH($dOC_RPH)
            ->setDocTypeDescription($docTypeDescription)
            ->setDocStatus($docStatus)
            ->setIssueLocation($issueLocation)
            ->setIssueDateTime($issueDateTime)
            ->setETicketInd($eTicketInd)
            ->setNetFareInd($netFareInd)
            ->setDocNumber($docNumber)
            ->setCouponNumber($couponNumber)
            ->setDocCurrency($docCurrency)
            ->setDocAmount($docAmount)
            ->setBaseFare($baseFare)
            ->setNetFare($netFare)
            ->setTaxes($taxes)
            ->setFees($fees)
            ->setPoints($points)
            ->setCategoryCode($categoryCode)
            ->setFlightDetailIndex($flightDetailIndex)
            ->setInitialDocNumber($initialDocNumber)
            ->setInitialDocType($initialDocType)
            ->setAssociatedDocNumber($associatedDocNumber)
            ->setDocSubType($docSubType)
            ->setEMD_GroupCode($eMD_GroupCode)
            ->setRFI_Code($rFI_Code)
            ->setCardCurrency($cardCurrency)
            ->setCardCurrencyDocAmount($cardCurrencyDocAmount)
            ->setAlternateCurrency($alternateCurrency)
            ->setAlternateCurrencyDocAmount($alternateCurrencyDocAmount)
            ->setTCN_Nbr($tCN_Nbr);
    }
    /**
     * Get DocType value
     * @return string
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docType, true), gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get FOP_Amount value
     * @return \SabrePaymentGateway\StructType\FOP_FareBreakType[]|null
     */
    public function getFOP_Amount()
    {
        return $this->FOP_Amount;
    }
    /**
     * This method is responsible for validating the values passed to the setFOP_Amount method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFOP_Amount method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFOP_AmountForArrayConstraintsFromSetFOP_Amount(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypeFOP_AmountItem) {
            // validation for constraint: itemType
            if (!$documentTypeFOP_AmountItem instanceof \SabrePaymentGateway\StructType\FOP_FareBreakType) {
                $invalidValues[] = is_object($documentTypeFOP_AmountItem) ? get_class($documentTypeFOP_AmountItem) : sprintf('%s(%s)', gettype($documentTypeFOP_AmountItem), var_export($documentTypeFOP_AmountItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FOP_Amount property can only contain items of type \SabrePaymentGateway\StructType\FOP_FareBreakType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FOP_Amount value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\FOP_FareBreakType[] $fOP_Amount
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setFOP_Amount(array $fOP_Amount = array())
    {
        // validation for constraint: array
        if ('' !== ($fOP_AmountArrayErrorMessage = self::validateFOP_AmountForArrayConstraintsFromSetFOP_Amount($fOP_Amount))) {
            throw new \InvalidArgumentException($fOP_AmountArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($fOP_Amount) && count($fOP_Amount) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($fOP_Amount)), __LINE__);
        }
        $this->FOP_Amount = $fOP_Amount;
        return $this;
    }
    /**
     * Add item to FOP_Amount value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\FOP_FareBreakType $item
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function addToFOP_Amount(\SabrePaymentGateway\StructType\FOP_FareBreakType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\FOP_FareBreakType) {
            throw new \InvalidArgumentException(sprintf('The FOP_Amount property can only contain items of type \SabrePaymentGateway\StructType\FOP_FareBreakType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->FOP_Amount) && count($this->FOP_Amount) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->FOP_Amount)), __LINE__);
        }
        $this->FOP_Amount[] = $item;
        return $this;
    }
    /**
     * Get TaxBreak value
     * @return \SabrePaymentGateway\StructType\TaxType[]|null
     */
    public function getTaxBreak()
    {
        return $this->TaxBreak;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxBreak method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxBreak method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxBreakForArrayConstraintsFromSetTaxBreak(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypeTaxBreakItem) {
            // validation for constraint: itemType
            if (!$documentTypeTaxBreakItem instanceof \SabrePaymentGateway\StructType\TaxType) {
                $invalidValues[] = is_object($documentTypeTaxBreakItem) ? get_class($documentTypeTaxBreakItem) : sprintf('%s(%s)', gettype($documentTypeTaxBreakItem), var_export($documentTypeTaxBreakItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType[] $taxBreak
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setTaxBreak(array $taxBreak = array())
    {
        // validation for constraint: array
        if ('' !== ($taxBreakArrayErrorMessage = self::validateTaxBreakForArrayConstraintsFromSetTaxBreak($taxBreak))) {
            throw new \InvalidArgumentException($taxBreakArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($taxBreak) && count($taxBreak) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($taxBreak)), __LINE__);
        }
        $this->TaxBreak = $taxBreak;
        return $this;
    }
    /**
     * Add item to TaxBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\TaxType $item
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function addToTaxBreak(\SabrePaymentGateway\StructType\TaxType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\TaxType) {
            throw new \InvalidArgumentException(sprintf('The TaxBreak property can only contain items of type \SabrePaymentGateway\StructType\TaxType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->TaxBreak) && count($this->TaxBreak) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->TaxBreak)), __LINE__);
        }
        $this->TaxBreak[] = $item;
        return $this;
    }
    /**
     * Get FeeBreak value
     * @return \SabrePaymentGateway\StructType\FeeBreakType[]|null
     */
    public function getFeeBreak()
    {
        return $this->FeeBreak;
    }
    /**
     * This method is responsible for validating the values passed to the setFeeBreak method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFeeBreak method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFeeBreakForArrayConstraintsFromSetFeeBreak(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypeFeeBreakItem) {
            // validation for constraint: itemType
            if (!$documentTypeFeeBreakItem instanceof \SabrePaymentGateway\StructType\FeeBreakType) {
                $invalidValues[] = is_object($documentTypeFeeBreakItem) ? get_class($documentTypeFeeBreakItem) : sprintf('%s(%s)', gettype($documentTypeFeeBreakItem), var_export($documentTypeFeeBreakItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FeeBreak property can only contain items of type \SabrePaymentGateway\StructType\FeeBreakType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FeeBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\FeeBreakType[] $feeBreak
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setFeeBreak(array $feeBreak = array())
    {
        // validation for constraint: array
        if ('' !== ($feeBreakArrayErrorMessage = self::validateFeeBreakForArrayConstraintsFromSetFeeBreak($feeBreak))) {
            throw new \InvalidArgumentException($feeBreakArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($feeBreak) && count($feeBreak) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($feeBreak)), __LINE__);
        }
        $this->FeeBreak = $feeBreak;
        return $this;
    }
    /**
     * Add item to FeeBreak value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\FeeBreakType $item
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function addToFeeBreak(\SabrePaymentGateway\StructType\FeeBreakType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\FeeBreakType) {
            throw new \InvalidArgumentException(sprintf('The FeeBreak property can only contain items of type \SabrePaymentGateway\StructType\FeeBreakType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FeeBreak) && count($this->FeeBreak) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FeeBreak)), __LINE__);
        }
        $this->FeeBreak[] = $item;
        return $this;
    }
    /**
     * Get MiscItem value
     * @return \SabrePaymentGateway\StructType\MiscItemType[]|null
     */
    public function getMiscItem()
    {
        return $this->MiscItem;
    }
    /**
     * This method is responsible for validating the values passed to the setMiscItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiscItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiscItemForArrayConstraintsFromSetMiscItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypeMiscItemItem) {
            // validation for constraint: itemType
            if (!$documentTypeMiscItemItem instanceof \SabrePaymentGateway\StructType\MiscItemType) {
                $invalidValues[] = is_object($documentTypeMiscItemItem) ? get_class($documentTypeMiscItemItem) : sprintf('%s(%s)', gettype($documentTypeMiscItemItem), var_export($documentTypeMiscItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiscItem property can only contain items of type \SabrePaymentGateway\StructType\MiscItemType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiscItem value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\MiscItemType[] $miscItem
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setMiscItem(array $miscItem = array())
    {
        // validation for constraint: array
        if ('' !== ($miscItemArrayErrorMessage = self::validateMiscItemForArrayConstraintsFromSetMiscItem($miscItem))) {
            throw new \InvalidArgumentException($miscItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($miscItem) && count($miscItem) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($miscItem)), __LINE__);
        }
        $this->MiscItem = $miscItem;
        return $this;
    }
    /**
     * Add item to MiscItem value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\MiscItemType $item
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function addToMiscItem(\SabrePaymentGateway\StructType\MiscItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\MiscItemType) {
            throw new \InvalidArgumentException(sprintf('The MiscItem property can only contain items of type \SabrePaymentGateway\StructType\MiscItemType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->MiscItem) && count($this->MiscItem) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->MiscItem)), __LINE__);
        }
        $this->MiscItem[] = $item;
        return $this;
    }
    /**
     * Get FareCalc value
     * @return string|null
     */
    public function getFareCalc()
    {
        return $this->FareCalc;
    }
    /**
     * Set FareCalc value
     * @param string $fareCalc
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setFareCalc($fareCalc = null)
    {
        // validation for constraint: string
        if (!is_null($fareCalc) && !is_string($fareCalc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareCalc, true), gettype($fareCalc)), __LINE__);
        }
        $this->FareCalc = $fareCalc;
        return $this;
    }
    /**
     * Get EMD_CouponDetail value
     * @return \SabrePaymentGateway\StructType\EMD_CouponDetail[]|null
     */
    public function getEMD_CouponDetail()
    {
        return $this->EMD_CouponDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setEMD_CouponDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEMD_CouponDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEMD_CouponDetailForArrayConstraintsFromSetEMD_CouponDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentTypeEMD_CouponDetailItem) {
            // validation for constraint: itemType
            if (!$documentTypeEMD_CouponDetailItem instanceof \SabrePaymentGateway\StructType\EMD_CouponDetail) {
                $invalidValues[] = is_object($documentTypeEMD_CouponDetailItem) ? get_class($documentTypeEMD_CouponDetailItem) : sprintf('%s(%s)', gettype($documentTypeEMD_CouponDetailItem), var_export($documentTypeEMD_CouponDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EMD_CouponDetail property can only contain items of type \SabrePaymentGateway\StructType\EMD_CouponDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EMD_CouponDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\EMD_CouponDetail[] $eMD_CouponDetail
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setEMD_CouponDetail(array $eMD_CouponDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($eMD_CouponDetailArrayErrorMessage = self::validateEMD_CouponDetailForArrayConstraintsFromSetEMD_CouponDetail($eMD_CouponDetail))) {
            throw new \InvalidArgumentException($eMD_CouponDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($eMD_CouponDetail) && count($eMD_CouponDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($eMD_CouponDetail)), __LINE__);
        }
        $this->EMD_CouponDetail = $eMD_CouponDetail;
        return $this;
    }
    /**
     * Add item to EMD_CouponDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\EMD_CouponDetail $item
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function addToEMD_CouponDetail(\SabrePaymentGateway\StructType\EMD_CouponDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\EMD_CouponDetail) {
            throw new \InvalidArgumentException(sprintf('The EMD_CouponDetail property can only contain items of type \SabrePaymentGateway\StructType\EMD_CouponDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->EMD_CouponDetail) && count($this->EMD_CouponDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->EMD_CouponDetail)), __LINE__);
        }
        $this->EMD_CouponDetail[] = $item;
        return $this;
    }
    /**
     * Get DOC_RPH value
     * @return string|null
     */
    public function getDOC_RPH()
    {
        return $this->DOC_RPH;
    }
    /**
     * Set DOC_RPH value
     * @param string $dOC_RPH
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDOC_RPH($dOC_RPH = null)
    {
        // validation for constraint: string
        if (!is_null($dOC_RPH) && !is_string($dOC_RPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dOC_RPH, true), gettype($dOC_RPH)), __LINE__);
        }
        $this->DOC_RPH = $dOC_RPH;
        return $this;
    }
    /**
     * Get DocTypeDescription value
     * @return string|null
     */
    public function getDocTypeDescription()
    {
        return $this->DocTypeDescription;
    }
    /**
     * Set DocTypeDescription value
     * @param string $docTypeDescription
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDocTypeDescription($docTypeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($docTypeDescription) && !is_string($docTypeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docTypeDescription, true), gettype($docTypeDescription)), __LINE__);
        }
        $this->DocTypeDescription = $docTypeDescription;
        return $this;
    }
    /**
     * Get DocStatus value
     * @return string|null
     */
    public function getDocStatus()
    {
        return $this->DocStatus;
    }
    /**
     * Set DocStatus value
     * @param string $docStatus
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDocStatus($docStatus = null)
    {
        // validation for constraint: string
        if (!is_null($docStatus) && !is_string($docStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docStatus, true), gettype($docStatus)), __LINE__);
        }
        $this->DocStatus = $docStatus;
        return $this;
    }
    /**
     * Get IssueLocation value
     * @return string|null
     */
    public function getIssueLocation()
    {
        return $this->IssueLocation;
    }
    /**
     * Set IssueLocation value
     * @param string $issueLocation
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setIssueLocation($issueLocation = null)
    {
        // validation for constraint: string
        if (!is_null($issueLocation) && !is_string($issueLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueLocation, true), gettype($issueLocation)), __LINE__);
        }
        $this->IssueLocation = $issueLocation;
        return $this;
    }
    /**
     * Get IssueDateTime value
     * @return string|null
     */
    public function getIssueDateTime()
    {
        return $this->IssueDateTime;
    }
    /**
     * Set IssueDateTime value
     * @param string $issueDateTime
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setIssueDateTime($issueDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueDateTime) && !is_string($issueDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDateTime, true), gettype($issueDateTime)), __LINE__);
        }
        $this->IssueDateTime = $issueDateTime;
        return $this;
    }
    /**
     * Get eTicketInd value
     * @return bool|null
     */
    public function getETicketInd()
    {
        return $this->eTicketInd;
    }
    /**
     * Set eTicketInd value
     * @param bool $eTicketInd
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setETicketInd($eTicketInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($eTicketInd) && !is_bool($eTicketInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eTicketInd, true), gettype($eTicketInd)), __LINE__);
        }
        $this->eTicketInd = $eTicketInd;
        return $this;
    }
    /**
     * Get NetFareInd value
     * @return bool|null
     */
    public function getNetFareInd()
    {
        return $this->NetFareInd;
    }
    /**
     * Set NetFareInd value
     * @param bool $netFareInd
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setNetFareInd($netFareInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($netFareInd) && !is_bool($netFareInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($netFareInd, true), gettype($netFareInd)), __LINE__);
        }
        $this->NetFareInd = $netFareInd;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docNumber, true), gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get CouponNumber value
     * @return string|null
     */
    public function getCouponNumber()
    {
        return $this->CouponNumber;
    }
    /**
     * Set CouponNumber value
     * @param string $couponNumber
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setCouponNumber($couponNumber = null)
    {
        // validation for constraint: string
        if (!is_null($couponNumber) && !is_string($couponNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponNumber, true), gettype($couponNumber)), __LINE__);
        }
        $this->CouponNumber = $couponNumber;
        return $this;
    }
    /**
     * Get DocCurrency value
     * @return string|null
     */
    public function getDocCurrency()
    {
        return $this->DocCurrency;
    }
    /**
     * Set DocCurrency value
     * @param string $docCurrency
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDocCurrency($docCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($docCurrency) && !is_string($docCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docCurrency, true), gettype($docCurrency)), __LINE__);
        }
        $this->DocCurrency = $docCurrency;
        return $this;
    }
    /**
     * Get DocAmount value
     * @return float|null
     */
    public function getDocAmount()
    {
        return $this->DocAmount;
    }
    /**
     * Set DocAmount value
     * @param float $docAmount
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDocAmount($docAmount = null)
    {
        // validation for constraint: float
        if (!is_null($docAmount) && !(is_float($docAmount) || is_numeric($docAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($docAmount, true), gettype($docAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($docAmount) && mb_strlen(mb_substr($docAmount, false !== mb_strpos($docAmount, '.') ? mb_strpos($docAmount, '.') + 1 : mb_strlen($docAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($docAmount, true), mb_strlen(mb_substr($docAmount, mb_strpos($docAmount, '.') + 1))), __LINE__);
        }
        $this->DocAmount = $docAmount;
        return $this;
    }
    /**
     * Get BaseFare value
     * @return float|null
     */
    public function getBaseFare()
    {
        return $this->BaseFare;
    }
    /**
     * Set BaseFare value
     * @param float $baseFare
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setBaseFare($baseFare = null)
    {
        // validation for constraint: float
        if (!is_null($baseFare) && !(is_float($baseFare) || is_numeric($baseFare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseFare, true), gettype($baseFare)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($baseFare) && mb_strlen(mb_substr($baseFare, false !== mb_strpos($baseFare, '.') ? mb_strpos($baseFare, '.') + 1 : mb_strlen($baseFare))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($baseFare, true), mb_strlen(mb_substr($baseFare, mb_strpos($baseFare, '.') + 1))), __LINE__);
        }
        $this->BaseFare = $baseFare;
        return $this;
    }
    /**
     * Get NetFare value
     * @return float|null
     */
    public function getNetFare()
    {
        return $this->NetFare;
    }
    /**
     * Set NetFare value
     * @param float $netFare
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setNetFare($netFare = null)
    {
        // validation for constraint: float
        if (!is_null($netFare) && !(is_float($netFare) || is_numeric($netFare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($netFare, true), gettype($netFare)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($netFare) && mb_strlen(mb_substr($netFare, false !== mb_strpos($netFare, '.') ? mb_strpos($netFare, '.') + 1 : mb_strlen($netFare))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($netFare, true), mb_strlen(mb_substr($netFare, mb_strpos($netFare, '.') + 1))), __LINE__);
        }
        $this->NetFare = $netFare;
        return $this;
    }
    /**
     * Get Taxes value
     * @return float|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param float $taxes
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setTaxes($taxes = null)
    {
        // validation for constraint: float
        if (!is_null($taxes) && !(is_float($taxes) || is_numeric($taxes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxes, true), gettype($taxes)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($taxes) && mb_strlen(mb_substr($taxes, false !== mb_strpos($taxes, '.') ? mb_strpos($taxes, '.') + 1 : mb_strlen($taxes))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($taxes, true), mb_strlen(mb_substr($taxes, mb_strpos($taxes, '.') + 1))), __LINE__);
        }
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get Fees value
     * @return float|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param float $fees
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setFees($fees = null)
    {
        // validation for constraint: float
        if (!is_null($fees) && !(is_float($fees) || is_numeric($fees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fees, true), gettype($fees)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($fees) && mb_strlen(mb_substr($fees, false !== mb_strpos($fees, '.') ? mb_strpos($fees, '.') + 1 : mb_strlen($fees))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($fees, true), mb_strlen(mb_substr($fees, mb_strpos($fees, '.') + 1))), __LINE__);
        }
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get Points value
     * @return int|null
     */
    public function getPoints()
    {
        return $this->Points;
    }
    /**
     * Set Points value
     * @param int $points
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setPoints($points = null)
    {
        // validation for constraint: int
        if (!is_null($points) && !(is_int($points) || ctype_digit($points))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($points, true), gettype($points)), __LINE__);
        }
        $this->Points = $points;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get FlightDetailIndex value
     * @return int|null
     */
    public function getFlightDetailIndex()
    {
        return $this->FlightDetailIndex;
    }
    /**
     * Set FlightDetailIndex value
     * @param int $flightDetailIndex
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setFlightDetailIndex($flightDetailIndex = null)
    {
        // validation for constraint: int
        if (!is_null($flightDetailIndex) && !(is_int($flightDetailIndex) || ctype_digit($flightDetailIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($flightDetailIndex, true), gettype($flightDetailIndex)), __LINE__);
        }
        $this->FlightDetailIndex = $flightDetailIndex;
        return $this;
    }
    /**
     * Get InitialDocNumber value
     * @return string|null
     */
    public function getInitialDocNumber()
    {
        return $this->InitialDocNumber;
    }
    /**
     * Set InitialDocNumber value
     * @param string $initialDocNumber
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setInitialDocNumber($initialDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($initialDocNumber) && !is_string($initialDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialDocNumber, true), gettype($initialDocNumber)), __LINE__);
        }
        $this->InitialDocNumber = $initialDocNumber;
        return $this;
    }
    /**
     * Get InitialDocType value
     * @return string|null
     */
    public function getInitialDocType()
    {
        return $this->InitialDocType;
    }
    /**
     * Set InitialDocType value
     * @param string $initialDocType
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setInitialDocType($initialDocType = null)
    {
        // validation for constraint: string
        if (!is_null($initialDocType) && !is_string($initialDocType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initialDocType, true), gettype($initialDocType)), __LINE__);
        }
        $this->InitialDocType = $initialDocType;
        return $this;
    }
    /**
     * Get AssociatedDocNumber value
     * @return string|null
     */
    public function getAssociatedDocNumber()
    {
        return $this->AssociatedDocNumber;
    }
    /**
     * Set AssociatedDocNumber value
     * @param string $associatedDocNumber
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setAssociatedDocNumber($associatedDocNumber = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDocNumber) && !is_string($associatedDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDocNumber, true), gettype($associatedDocNumber)), __LINE__);
        }
        $this->AssociatedDocNumber = $associatedDocNumber;
        return $this;
    }
    /**
     * Get DocSubType value
     * @return string|null
     */
    public function getDocSubType()
    {
        return $this->DocSubType;
    }
    /**
     * Set DocSubType value
     * @param string $docSubType
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setDocSubType($docSubType = null)
    {
        // validation for constraint: string
        if (!is_null($docSubType) && !is_string($docSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docSubType, true), gettype($docSubType)), __LINE__);
        }
        $this->DocSubType = $docSubType;
        return $this;
    }
    /**
     * Get EMD_GroupCode value
     * @return string|null
     */
    public function getEMD_GroupCode()
    {
        return $this->EMD_GroupCode;
    }
    /**
     * Set EMD_GroupCode value
     * @param string $eMD_GroupCode
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setEMD_GroupCode($eMD_GroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($eMD_GroupCode) && !is_string($eMD_GroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMD_GroupCode, true), gettype($eMD_GroupCode)), __LINE__);
        }
        $this->EMD_GroupCode = $eMD_GroupCode;
        return $this;
    }
    /**
     * Get RFI_Code value
     * @return string|null
     */
    public function getRFI_Code()
    {
        return $this->RFI_Code;
    }
    /**
     * Set RFI_Code value
     * @param string $rFI_Code
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setRFI_Code($rFI_Code = null)
    {
        // validation for constraint: string
        if (!is_null($rFI_Code) && !is_string($rFI_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFI_Code, true), gettype($rFI_Code)), __LINE__);
        }
        $this->RFI_Code = $rFI_Code;
        return $this;
    }
    /**
     * Get CardCurrency value
     * @return string|null
     */
    public function getCardCurrency()
    {
        return $this->CardCurrency;
    }
    /**
     * Set CardCurrency value
     * @param string $cardCurrency
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setCardCurrency($cardCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($cardCurrency) && !is_string($cardCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCurrency, true), gettype($cardCurrency)), __LINE__);
        }
        $this->CardCurrency = $cardCurrency;
        return $this;
    }
    /**
     * Get CardCurrencyDocAmount value
     * @return float|null
     */
    public function getCardCurrencyDocAmount()
    {
        return $this->CardCurrencyDocAmount;
    }
    /**
     * Set CardCurrencyDocAmount value
     * @param float $cardCurrencyDocAmount
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setCardCurrencyDocAmount($cardCurrencyDocAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cardCurrencyDocAmount) && !(is_float($cardCurrencyDocAmount) || is_numeric($cardCurrencyDocAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cardCurrencyDocAmount, true), gettype($cardCurrencyDocAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($cardCurrencyDocAmount) && mb_strlen(mb_substr($cardCurrencyDocAmount, false !== mb_strpos($cardCurrencyDocAmount, '.') ? mb_strpos($cardCurrencyDocAmount, '.') + 1 : mb_strlen($cardCurrencyDocAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($cardCurrencyDocAmount, true), mb_strlen(mb_substr($cardCurrencyDocAmount, mb_strpos($cardCurrencyDocAmount, '.') + 1))), __LINE__);
        }
        $this->CardCurrencyDocAmount = $cardCurrencyDocAmount;
        return $this;
    }
    /**
     * Get AlternateCurrency value
     * @return string|null
     */
    public function getAlternateCurrency()
    {
        return $this->AlternateCurrency;
    }
    /**
     * Set AlternateCurrency value
     * @param string $alternateCurrency
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setAlternateCurrency($alternateCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($alternateCurrency) && !is_string($alternateCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternateCurrency, true), gettype($alternateCurrency)), __LINE__);
        }
        $this->AlternateCurrency = $alternateCurrency;
        return $this;
    }
    /**
     * Get AlternateCurrencyDocAmount value
     * @return float|null
     */
    public function getAlternateCurrencyDocAmount()
    {
        return $this->AlternateCurrencyDocAmount;
    }
    /**
     * Set AlternateCurrencyDocAmount value
     * @param float $alternateCurrencyDocAmount
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setAlternateCurrencyDocAmount($alternateCurrencyDocAmount = null)
    {
        // validation for constraint: float
        if (!is_null($alternateCurrencyDocAmount) && !(is_float($alternateCurrencyDocAmount) || is_numeric($alternateCurrencyDocAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($alternateCurrencyDocAmount, true), gettype($alternateCurrencyDocAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($alternateCurrencyDocAmount) && mb_strlen(mb_substr($alternateCurrencyDocAmount, false !== mb_strpos($alternateCurrencyDocAmount, '.') ? mb_strpos($alternateCurrencyDocAmount, '.') + 1 : mb_strlen($alternateCurrencyDocAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($alternateCurrencyDocAmount, true), mb_strlen(mb_substr($alternateCurrencyDocAmount, mb_strpos($alternateCurrencyDocAmount, '.') + 1))), __LINE__);
        }
        $this->AlternateCurrencyDocAmount = $alternateCurrencyDocAmount;
        return $this;
    }
    /**
     * Get TCN_Nbr value
     * @return string|null
     */
    public function getTCN_Nbr()
    {
        return $this->TCN_Nbr;
    }
    /**
     * Set TCN_Nbr value
     * @param string $tCN_Nbr
     * @return \SabrePaymentGateway\StructType\DocumentType
     */
    public function setTCN_Nbr($tCN_Nbr = null)
    {
        // validation for constraint: string
        if (!is_null($tCN_Nbr) && !is_string($tCN_Nbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tCN_Nbr, true), gettype($tCN_Nbr)), __LINE__);
        }
        $this->TCN_Nbr = $tCN_Nbr;
        return $this;
    }
}
