<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardDetail StructType
 * @subpackage Structs
 */
class CardDetail extends AbstractStructBase
{
    /**
     * The CardCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CardCode;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardNumber;
    /**
     * The TokenizedCardNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TokenizedCardNumber;
    /**
     * The MaskedCardNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MaskedCardNumber;
    /**
     * The ExpireDate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExpireDate;
    /**
     * Constructor method for CardDetail
     * @uses CardDetail::setCardCode()
     * @uses CardDetail::setCardNumber()
     * @uses CardDetail::setTokenizedCardNumber()
     * @uses CardDetail::setMaskedCardNumber()
     * @uses CardDetail::setExpireDate()
     * @param string $cardCode
     * @param string $cardNumber
     * @param string $tokenizedCardNumber
     * @param string $maskedCardNumber
     * @param string $expireDate
     */
    public function __construct($cardCode = null, $cardNumber = null, $tokenizedCardNumber = null, $maskedCardNumber = null, $expireDate = null)
    {
        $this
            ->setCardCode($cardCode)
            ->setCardNumber($cardNumber)
            ->setTokenizedCardNumber($tokenizedCardNumber)
            ->setMaskedCardNumber($maskedCardNumber)
            ->setExpireDate($expireDate);
    }
    /**
     * Get CardCode value
     * @return string
     */
    public function getCardCode()
    {
        return $this->CardCode;
    }
    /**
     * Set CardCode value
     * @param string $cardCode
     * @return \SabrePaymentGateway\StructType\CardDetail
     */
    public function setCardCode($cardCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCode) && !is_string($cardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCode, true), gettype($cardCode)), __LINE__);
        }
        $this->CardCode = $cardCode;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \SabrePaymentGateway\StructType\CardDetail
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get TokenizedCardNumber value
     * @return string|null
     */
    public function getTokenizedCardNumber()
    {
        return $this->TokenizedCardNumber;
    }
    /**
     * Set TokenizedCardNumber value
     * @param string $tokenizedCardNumber
     * @return \SabrePaymentGateway\StructType\CardDetail
     */
    public function setTokenizedCardNumber($tokenizedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tokenizedCardNumber) && !is_string($tokenizedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenizedCardNumber, true), gettype($tokenizedCardNumber)), __LINE__);
        }
        $this->TokenizedCardNumber = $tokenizedCardNumber;
        return $this;
    }
    /**
     * Get MaskedCardNumber value
     * @return string|null
     */
    public function getMaskedCardNumber()
    {
        return $this->MaskedCardNumber;
    }
    /**
     * Set MaskedCardNumber value
     * @param string $maskedCardNumber
     * @return \SabrePaymentGateway\StructType\CardDetail
     */
    public function setMaskedCardNumber($maskedCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($maskedCardNumber) && !is_string($maskedCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maskedCardNumber, true), gettype($maskedCardNumber)), __LINE__);
        }
        $this->MaskedCardNumber = $maskedCardNumber;
        return $this;
    }
    /**
     * Get ExpireDate value
     * @return string|null
     */
    public function getExpireDate()
    {
        return $this->ExpireDate;
    }
    /**
     * Set ExpireDate value
     * @param string $expireDate
     * @return \SabrePaymentGateway\StructType\CardDetail
     */
    public function setExpireDate($expireDate = null)
    {
        // validation for constraint: string
        if (!is_null($expireDate) && !is_string($expireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expireDate, true), gettype($expireDate)), __LINE__);
        }
        $this->ExpireDate = $expireDate;
        return $this;
    }
}
