<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarRentalType StructType
 * @subpackage Structs
 */
class CarRentalType extends AbstractStructBase
{
    /**
     * The AgreementNbr
     * Meta information extracted from the WSDL
     * - documentation: Required by Amex (max 14 chars)
     * - use: required
     * @var string
     */
    public $AgreementNbr;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ReferenceNbr;
    /**
     * The Pickup
     * @var \SabrePaymentGateway\StructType\Pickup
     */
    public $Pickup;
    /**
     * The Return
     * @var \SabrePaymentGateway\StructType\_Return
     */
    public $Return;
    /**
     * The Renter
     * @var \SabrePaymentGateway\StructType\Renter
     */
    public $Renter;
    /**
     * The ProviderInfo
     * @var \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public $ProviderInfo;
    /**
     * The Cost
     * @var \SabrePaymentGateway\StructType\CostType
     */
    public $Cost;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PaymentInfoType
     */
    public $PaymentInfo;
    /**
     * The ServiceNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceNote;
    /**
     * The VehicleClassID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $VehicleClassID;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $Distance;
    /**
     * The DistanceUnit
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DistanceUnit;
    /**
     * Constructor method for CarRentalType
     * @uses CarRentalType::setAgreementNbr()
     * @uses CarRentalType::setReferenceNbr()
     * @uses CarRentalType::setPickup()
     * @uses CarRentalType::setReturn()
     * @uses CarRentalType::setRenter()
     * @uses CarRentalType::setProviderInfo()
     * @uses CarRentalType::setCost()
     * @uses CarRentalType::setPaymentInfo()
     * @uses CarRentalType::setServiceNote()
     * @uses CarRentalType::setVehicleClassID()
     * @uses CarRentalType::setDistance()
     * @uses CarRentalType::setDistanceUnit()
     * @param string $agreementNbr
     * @param string $referenceNbr
     * @param \SabrePaymentGateway\StructType\Pickup $pickup
     * @param \SabrePaymentGateway\StructType\_Return $return
     * @param \SabrePaymentGateway\StructType\Renter $renter
     * @param \SabrePaymentGateway\StructType\ProviderInfoType $providerInfo
     * @param \SabrePaymentGateway\StructType\CostType $cost
     * @param \SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo
     * @param string $serviceNote
     * @param string $vehicleClassID
     * @param int $distance
     * @param string $distanceUnit
     */
    public function __construct($agreementNbr = null, $referenceNbr = null, \SabrePaymentGateway\StructType\Pickup $pickup = null, \SabrePaymentGateway\StructType\_Return $return = null, \SabrePaymentGateway\StructType\Renter $renter = null, \SabrePaymentGateway\StructType\ProviderInfoType $providerInfo = null, \SabrePaymentGateway\StructType\CostType $cost = null, \SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo = null, $serviceNote = null, $vehicleClassID = null, $distance = null, $distanceUnit = null)
    {
        $this
            ->setAgreementNbr($agreementNbr)
            ->setReferenceNbr($referenceNbr)
            ->setPickup($pickup)
            ->setReturn($return)
            ->setRenter($renter)
            ->setProviderInfo($providerInfo)
            ->setCost($cost)
            ->setPaymentInfo($paymentInfo)
            ->setServiceNote($serviceNote)
            ->setVehicleClassID($vehicleClassID)
            ->setDistance($distance)
            ->setDistanceUnit($distanceUnit);
    }
    /**
     * Get AgreementNbr value
     * @return string
     */
    public function getAgreementNbr()
    {
        return $this->AgreementNbr;
    }
    /**
     * Set AgreementNbr value
     * @param string $agreementNbr
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setAgreementNbr($agreementNbr = null)
    {
        // validation for constraint: string
        if (!is_null($agreementNbr) && !is_string($agreementNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agreementNbr, true), gettype($agreementNbr)), __LINE__);
        }
        $this->AgreementNbr = $agreementNbr;
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * @return string
     */
    public function getReferenceNbr()
    {
        return $this->ReferenceNbr;
    }
    /**
     * Set ReferenceNbr value
     * @param string $referenceNbr
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setReferenceNbr($referenceNbr = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNbr) && !is_string($referenceNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNbr, true), gettype($referenceNbr)), __LINE__);
        }
        $this->ReferenceNbr = $referenceNbr;
        return $this;
    }
    /**
     * Get Pickup value
     * @return \SabrePaymentGateway\StructType\Pickup|null
     */
    public function getPickup()
    {
        return $this->Pickup;
    }
    /**
     * Set Pickup value
     * @param \SabrePaymentGateway\StructType\Pickup $pickup
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setPickup(\SabrePaymentGateway\StructType\Pickup $pickup = null)
    {
        $this->Pickup = $pickup;
        return $this;
    }
    /**
     * Get Return value
     * @return \SabrePaymentGateway\StructType\_Return|null
     */
    public function getReturn()
    {
        return $this->Return;
    }
    /**
     * Set Return value
     * @param \SabrePaymentGateway\StructType\_Return $return
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setReturn(\SabrePaymentGateway\StructType\_Return $return = null)
    {
        $this->Return = $return;
        return $this;
    }
    /**
     * Get Renter value
     * @return \SabrePaymentGateway\StructType\Renter|null
     */
    public function getRenter()
    {
        return $this->Renter;
    }
    /**
     * Set Renter value
     * @param \SabrePaymentGateway\StructType\Renter $renter
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setRenter(\SabrePaymentGateway\StructType\Renter $renter = null)
    {
        $this->Renter = $renter;
        return $this;
    }
    /**
     * Get ProviderInfo value
     * @return \SabrePaymentGateway\StructType\ProviderInfoType|null
     */
    public function getProviderInfo()
    {
        return $this->ProviderInfo;
    }
    /**
     * Set ProviderInfo value
     * @param \SabrePaymentGateway\StructType\ProviderInfoType $providerInfo
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setProviderInfo(\SabrePaymentGateway\StructType\ProviderInfoType $providerInfo = null)
    {
        $this->ProviderInfo = $providerInfo;
        return $this;
    }
    /**
     * Get Cost value
     * @return \SabrePaymentGateway\StructType\CostType|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param \SabrePaymentGateway\StructType\CostType $cost
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setCost(\SabrePaymentGateway\StructType\CostType $cost = null)
    {
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \SabrePaymentGateway\StructType\PaymentInfoType|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setPaymentInfo(\SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get ServiceNote value
     * @return string|null
     */
    public function getServiceNote()
    {
        return $this->ServiceNote;
    }
    /**
     * Set ServiceNote value
     * @param string $serviceNote
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setServiceNote($serviceNote = null)
    {
        // validation for constraint: string
        if (!is_null($serviceNote) && !is_string($serviceNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceNote, true), gettype($serviceNote)), __LINE__);
        }
        $this->ServiceNote = $serviceNote;
        return $this;
    }
    /**
     * Get VehicleClassID value
     * @return string|null
     */
    public function getVehicleClassID()
    {
        return $this->VehicleClassID;
    }
    /**
     * Set VehicleClassID value
     * @param string $vehicleClassID
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setVehicleClassID($vehicleClassID = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleClassID) && !is_string($vehicleClassID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vehicleClassID, true), gettype($vehicleClassID)), __LINE__);
        }
        $this->VehicleClassID = $vehicleClassID;
        return $this;
    }
    /**
     * Get Distance value
     * @return int|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param int $distance
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get DistanceUnit value
     * @return string|null
     */
    public function getDistanceUnit()
    {
        return $this->DistanceUnit;
    }
    /**
     * Set DistanceUnit value
     * @param string $distanceUnit
     * @return \SabrePaymentGateway\StructType\CarRentalType
     */
    public function setDistanceUnit($distanceUnit = null)
    {
        // validation for constraint: string
        if (!is_null($distanceUnit) && !is_string($distanceUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($distanceUnit, true), gettype($distanceUnit)), __LINE__);
        }
        $this->DistanceUnit = $distanceUnit;
        return $this;
    }
}
