<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VirtualPaymentDetail StructType
 * Meta information extracted from the WSDL
 * - documentation: Information that identifies a scope of a business purchase of virtual card
 * @subpackage Structs
 */
class VirtualPaymentDetail extends AbstractStructBase
{
    /**
     * The CustomIdentifiers
     * Meta information extracted from the WSDL
     * - documentation: Custom identifier data are submitted into Financial Partners system to report data via electronic reporting systems or to be printed on the paper statement
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CustomIdentifiersType
     */
    public $CustomIdentifiers;
    /**
     * The PurchaseType
     * Meta information extracted from the WSDL
     * - documentation: Purchase type e.g. Generic
     * - use: optional
     * @var string
     */
    public $PurchaseType;
    /**
     * The PaymentStartDate
     * Meta information extracted from the WSDL
     * - documentation: Payment start date e.g. 2022-12-15
     * - use: optional
     * @var string
     */
    public $PaymentStartDate;
    /**
     * The PaymentEndDate
     * Meta information extracted from the WSDL
     * - documentation: Payment end date e.g. 2022-12-23
     * - use: optional
     * @var string
     */
    public $PaymentEndDate;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - documentation: Custom ID for the supplier
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The UpdateNote
     * Meta information extracted from the WSDL
     * - documentation: The note that describes virtual card updates/cancellation
     * - use: optional
     * @var string
     */
    public $UpdateNote;
    /**
     * The WebhookNotificationPayload
     * Meta information extracted from the WSDL
     * - documentation: Webhook notification payload from vendor
     * - use: optional
     * @var string
     */
    public $WebhookNotificationPayload;
    /**
     * Constructor method for VirtualPaymentDetail
     * @uses VirtualPaymentDetail::setCustomIdentifiers()
     * @uses VirtualPaymentDetail::setPurchaseType()
     * @uses VirtualPaymentDetail::setPaymentStartDate()
     * @uses VirtualPaymentDetail::setPaymentEndDate()
     * @uses VirtualPaymentDetail::setSupplierID()
     * @uses VirtualPaymentDetail::setUpdateNote()
     * @uses VirtualPaymentDetail::setWebhookNotificationPayload()
     * @param \SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers
     * @param string $purchaseType
     * @param string $paymentStartDate
     * @param string $paymentEndDate
     * @param string $supplierID
     * @param string $updateNote
     * @param string $webhookNotificationPayload
     */
    public function __construct(\SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers = null, $purchaseType = null, $paymentStartDate = null, $paymentEndDate = null, $supplierID = null, $updateNote = null, $webhookNotificationPayload = null)
    {
        $this
            ->setCustomIdentifiers($customIdentifiers)
            ->setPurchaseType($purchaseType)
            ->setPaymentStartDate($paymentStartDate)
            ->setPaymentEndDate($paymentEndDate)
            ->setSupplierID($supplierID)
            ->setUpdateNote($updateNote)
            ->setWebhookNotificationPayload($webhookNotificationPayload);
    }
    /**
     * Get CustomIdentifiers value
     * @return \SabrePaymentGateway\StructType\CustomIdentifiersType|null
     */
    public function getCustomIdentifiers()
    {
        return $this->CustomIdentifiers;
    }
    /**
     * Set CustomIdentifiers value
     * @param \SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public function setCustomIdentifiers(\SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers = null)
    {
        $this->CustomIdentifiers = $customIdentifiers;
        return $this;
    }
    /**
     * Get PurchaseType value
     * @return string|null
     */
    public function getPurchaseType()
    {
        return $this->PurchaseType;
    }
    /**
     * Set PurchaseType value
     * @param string $purchaseType
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public function setPurchaseType($purchaseType = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseType) && !is_string($purchaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseType, true), gettype($purchaseType)), __LINE__);
        }
        $this->PurchaseType = $purchaseType;
        return $this;
    }
    /**
     * Get PaymentStartDate value
     * @return string|null
     */
    public function getPaymentStartDate()
    {
        return $this->PaymentStartDate;
    }
    /**
     * Set PaymentStartDate value
     * @param string $paymentStartDate
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public function setPaymentStartDate($paymentStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStartDate) && !is_string($paymentStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStartDate, true), gettype($paymentStartDate)), __LINE__);
        }
        $this->PaymentStartDate = $paymentStartDate;
        return $this;
    }
    /**
     * Get PaymentEndDate value
     * @return string|null
     */
    public function getPaymentEndDate()
    {
        return $this->PaymentEndDate;
    }
    /**
     * Set PaymentEndDate value
     * @param string $paymentEndDate
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public function setPaymentEndDate($paymentEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentEndDate) && !is_string($paymentEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentEndDate, true), gettype($paymentEndDate)), __LINE__);
        }
        $this->PaymentEndDate = $paymentEndDate;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get UpdateNote value
     * @return string|null
     */
    public function getUpdateNote()
    {
        return $this->UpdateNote;
    }
    /**
     * Set UpdateNote value
     * @param string $updateNote
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public function setUpdateNote($updateNote = null)
    {
        // validation for constraint: string
        if (!is_null($updateNote) && !is_string($updateNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateNote, true), gettype($updateNote)), __LINE__);
        }
        $this->UpdateNote = $updateNote;
        return $this;
    }
    /**
     * Get WebhookNotificationPayload value
     * @return string|null
     */
    public function getWebhookNotificationPayload()
    {
        return $this->WebhookNotificationPayload;
    }
    /**
     * Set WebhookNotificationPayload value
     * @param string $webhookNotificationPayload
     * @return \SabrePaymentGateway\StructType\VirtualPaymentDetail
     */
    public function setWebhookNotificationPayload($webhookNotificationPayload = null)
    {
        // validation for constraint: string
        if (!is_null($webhookNotificationPayload) && !is_string($webhookNotificationPayload)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webhookNotificationPayload, true), gettype($webhookNotificationPayload)), __LINE__);
        }
        $this->WebhookNotificationPayload = $webhookNotificationPayload;
        return $this;
    }
}
