<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDeploymentResultType StructType
 * @subpackage Structs
 */
class UpdateDeploymentResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * Constructor method for UpdateDeploymentResultType
     * @uses UpdateDeploymentResultType::setResponseCode()
     * @uses UpdateDeploymentResultType::setDescription()
     * @uses UpdateDeploymentResultType::setSupplierID()
     * @param string $responseCode
     * @param string $description
     * @param string $supplierID
     */
    public function __construct($responseCode = null, $description = null, $supplierID = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setDescription($description)
            ->setSupplierID($supplierID);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\UpdateDeploymentResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\UpdateDeploymentResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\UpdateDeploymentResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
}
