<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for T3DS StructType
 * @subpackage Structs
 */
class T3DS extends AbstractStructBase
{
    /**
     * The AdditionalDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AdditionalDetailType
     */
    public $AdditionalDetail;
    /**
     * The CAVV
     * Meta information extracted from the WSDL
     * - documentation: A string token provided by Issuing bank as a response from 3DSecure authentication request for Verified By Visa or MasterCard Secure Code.
     * - use: optional
     * @var string
     */
    public $CAVV;
    /**
     * The CAVV_Algorithm
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CAVV_Algorithm;
    /**
     * The CAVV_ResultCode
     * Meta information extracted from the WSDL
     * - documentation: Cardholder Authentication Verification Value Result Code
     * - use: optional
     * @var string
     */
    public $CAVV_ResultCode;
    /**
     * The ECI
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ECI;
    /**
     * The XID
     * Meta information extracted from the WSDL
     * - documentation: Authentication Transaction ID
     * - use: optional
     * @var string
     */
    public $XID;
    /**
     * The CaseNumber
     * @var int
     */
    public $CaseNumber;
    /**
     * The MD
     * Meta information extracted from the WSDL
     * - documentation: Merchant Datafield
     * - use: optional
     * @var string
     */
    public $MD;
    /**
     * The PA_Response
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PA_Response;
    /**
     * The VerificationResult
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $VerificationResult;
    /**
     * The AuthenticationResult
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $AuthenticationResult;
    /**
     * The MachineCookie
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MachineCookie;
    /**
     * The OriginalPaymentRef
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $OriginalPaymentRef;
    /**
     * The DirectoryServerTrxID
     * Meta information extracted from the WSDL
     * - documentation: Directory Server Transaction ID
     * - use: optional
     * @var string
     */
    public $DirectoryServerTrxID;
    /**
     * The LiabilityShiftInd
     * Meta information extracted from the WSDL
     * - documentation: Set to true if 3D-Secure resulted in merchant liability shift
     * - use: optional
     * @var bool
     */
    public $LiabilityShiftInd;
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: 3DS Version
     * - use: optional
     * @var string
     */
    public $Version;
    /**
     * The ThreeDSServerTransID
     * Meta information extracted from the WSDL
     * - documentation: A unique transaction identifier assigned by 3DS Server to identify the authentication.
     * - use: optional
     * @var string
     */
    public $ThreeDSServerTransID;
    /**
     * Constructor method for T3DS
     * @uses T3DS::setAdditionalDetail()
     * @uses T3DS::setCAVV()
     * @uses T3DS::setCAVV_Algorithm()
     * @uses T3DS::setCAVV_ResultCode()
     * @uses T3DS::setECI()
     * @uses T3DS::setXID()
     * @uses T3DS::setCaseNumber()
     * @uses T3DS::setMD()
     * @uses T3DS::setPA_Response()
     * @uses T3DS::setVerificationResult()
     * @uses T3DS::setAuthenticationResult()
     * @uses T3DS::setMachineCookie()
     * @uses T3DS::setOriginalPaymentRef()
     * @uses T3DS::setDirectoryServerTrxID()
     * @uses T3DS::setLiabilityShiftInd()
     * @uses T3DS::setVersion()
     * @uses T3DS::setThreeDSServerTransID()
     * @param \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail
     * @param string $cAVV
     * @param string $cAVV_Algorithm
     * @param string $cAVV_ResultCode
     * @param string $eCI
     * @param string $xID
     * @param int $caseNumber
     * @param string $mD
     * @param string $pA_Response
     * @param string $verificationResult
     * @param string $authenticationResult
     * @param string $machineCookie
     * @param string $originalPaymentRef
     * @param string $directoryServerTrxID
     * @param bool $liabilityShiftInd
     * @param string $version
     * @param string $threeDSServerTransID
     */
    public function __construct(\SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail = null, $cAVV = null, $cAVV_Algorithm = null, $cAVV_ResultCode = null, $eCI = null, $xID = null, $caseNumber = null, $mD = null, $pA_Response = null, $verificationResult = null, $authenticationResult = null, $machineCookie = null, $originalPaymentRef = null, $directoryServerTrxID = null, $liabilityShiftInd = null, $version = null, $threeDSServerTransID = null)
    {
        $this
            ->setAdditionalDetail($additionalDetail)
            ->setCAVV($cAVV)
            ->setCAVV_Algorithm($cAVV_Algorithm)
            ->setCAVV_ResultCode($cAVV_ResultCode)
            ->setECI($eCI)
            ->setXID($xID)
            ->setCaseNumber($caseNumber)
            ->setMD($mD)
            ->setPA_Response($pA_Response)
            ->setVerificationResult($verificationResult)
            ->setAuthenticationResult($authenticationResult)
            ->setMachineCookie($machineCookie)
            ->setOriginalPaymentRef($originalPaymentRef)
            ->setDirectoryServerTrxID($directoryServerTrxID)
            ->setLiabilityShiftInd($liabilityShiftInd)
            ->setVersion($version)
            ->setThreeDSServerTransID($threeDSServerTransID);
    }
    /**
     * Get AdditionalDetail value
     * @return \SabrePaymentGateway\StructType\AdditionalDetailType|null
     */
    public function getAdditionalDetail()
    {
        return $this->AdditionalDetail;
    }
    /**
     * Set AdditionalDetail value
     * @param \SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setAdditionalDetail(\SabrePaymentGateway\StructType\AdditionalDetailType $additionalDetail = null)
    {
        $this->AdditionalDetail = $additionalDetail;
        return $this;
    }
    /**
     * Get CAVV value
     * @return string|null
     */
    public function getCAVV()
    {
        return $this->CAVV;
    }
    /**
     * Set CAVV value
     * @param string $cAVV
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setCAVV($cAVV = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV) && !is_string($cAVV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV, true), gettype($cAVV)), __LINE__);
        }
        $this->CAVV = $cAVV;
        return $this;
    }
    /**
     * Get CAVV_Algorithm value
     * @return string|null
     */
    public function getCAVV_Algorithm()
    {
        return $this->CAVV_Algorithm;
    }
    /**
     * Set CAVV_Algorithm value
     * @param string $cAVV_Algorithm
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setCAVV_Algorithm($cAVV_Algorithm = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV_Algorithm) && !is_string($cAVV_Algorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV_Algorithm, true), gettype($cAVV_Algorithm)), __LINE__);
        }
        $this->CAVV_Algorithm = $cAVV_Algorithm;
        return $this;
    }
    /**
     * Get CAVV_ResultCode value
     * @return string|null
     */
    public function getCAVV_ResultCode()
    {
        return $this->CAVV_ResultCode;
    }
    /**
     * Set CAVV_ResultCode value
     * @param string $cAVV_ResultCode
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setCAVV_ResultCode($cAVV_ResultCode = null)
    {
        // validation for constraint: string
        if (!is_null($cAVV_ResultCode) && !is_string($cAVV_ResultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cAVV_ResultCode, true), gettype($cAVV_ResultCode)), __LINE__);
        }
        $this->CAVV_ResultCode = $cAVV_ResultCode;
        return $this;
    }
    /**
     * Get ECI value
     * @return string|null
     */
    public function getECI()
    {
        return $this->ECI;
    }
    /**
     * Set ECI value
     * @param string $eCI
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setECI($eCI = null)
    {
        // validation for constraint: string
        if (!is_null($eCI) && !is_string($eCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCI, true), gettype($eCI)), __LINE__);
        }
        $this->ECI = $eCI;
        return $this;
    }
    /**
     * Get XID value
     * @return string|null
     */
    public function getXID()
    {
        return $this->XID;
    }
    /**
     * Set XID value
     * @param string $xID
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setXID($xID = null)
    {
        // validation for constraint: string
        if (!is_null($xID) && !is_string($xID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xID, true), gettype($xID)), __LINE__);
        }
        $this->XID = $xID;
        return $this;
    }
    /**
     * Get CaseNumber value
     * @return int|null
     */
    public function getCaseNumber()
    {
        return $this->CaseNumber;
    }
    /**
     * Set CaseNumber value
     * @param int $caseNumber
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setCaseNumber($caseNumber = null)
    {
        // validation for constraint: int
        if (!is_null($caseNumber) && !(is_int($caseNumber) || ctype_digit($caseNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($caseNumber, true), gettype($caseNumber)), __LINE__);
        }
        $this->CaseNumber = $caseNumber;
        return $this;
    }
    /**
     * Get MD value
     * @return string|null
     */
    public function getMD()
    {
        return $this->MD;
    }
    /**
     * Set MD value
     * @param string $mD
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setMD($mD = null)
    {
        // validation for constraint: string
        if (!is_null($mD) && !is_string($mD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mD, true), gettype($mD)), __LINE__);
        }
        $this->MD = $mD;
        return $this;
    }
    /**
     * Get PA_Response value
     * @return string|null
     */
    public function getPA_Response()
    {
        return $this->PA_Response;
    }
    /**
     * Set PA_Response value
     * @param string $pA_Response
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setPA_Response($pA_Response = null)
    {
        // validation for constraint: string
        if (!is_null($pA_Response) && !is_string($pA_Response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pA_Response, true), gettype($pA_Response)), __LINE__);
        }
        $this->PA_Response = $pA_Response;
        return $this;
    }
    /**
     * Get VerificationResult value
     * @return string|null
     */
    public function getVerificationResult()
    {
        return $this->VerificationResult;
    }
    /**
     * Set VerificationResult value
     * @param string $verificationResult
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setVerificationResult($verificationResult = null)
    {
        // validation for constraint: string
        if (!is_null($verificationResult) && !is_string($verificationResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verificationResult, true), gettype($verificationResult)), __LINE__);
        }
        $this->VerificationResult = $verificationResult;
        return $this;
    }
    /**
     * Get AuthenticationResult value
     * @return string|null
     */
    public function getAuthenticationResult()
    {
        return $this->AuthenticationResult;
    }
    /**
     * Set AuthenticationResult value
     * @param string $authenticationResult
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setAuthenticationResult($authenticationResult = null)
    {
        // validation for constraint: string
        if (!is_null($authenticationResult) && !is_string($authenticationResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authenticationResult, true), gettype($authenticationResult)), __LINE__);
        }
        $this->AuthenticationResult = $authenticationResult;
        return $this;
    }
    /**
     * Get MachineCookie value
     * @return string|null
     */
    public function getMachineCookie()
    {
        return $this->MachineCookie;
    }
    /**
     * Set MachineCookie value
     * @param string $machineCookie
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setMachineCookie($machineCookie = null)
    {
        // validation for constraint: string
        if (!is_null($machineCookie) && !is_string($machineCookie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($machineCookie, true), gettype($machineCookie)), __LINE__);
        }
        $this->MachineCookie = $machineCookie;
        return $this;
    }
    /**
     * Get OriginalPaymentRef value
     * @return string|null
     */
    public function getOriginalPaymentRef()
    {
        return $this->OriginalPaymentRef;
    }
    /**
     * Set OriginalPaymentRef value
     * @param string $originalPaymentRef
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setOriginalPaymentRef($originalPaymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($originalPaymentRef) && !is_string($originalPaymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPaymentRef, true), gettype($originalPaymentRef)), __LINE__);
        }
        $this->OriginalPaymentRef = $originalPaymentRef;
        return $this;
    }
    /**
     * Get DirectoryServerTrxID value
     * @return string|null
     */
    public function getDirectoryServerTrxID()
    {
        return $this->DirectoryServerTrxID;
    }
    /**
     * Set DirectoryServerTrxID value
     * @param string $directoryServerTrxID
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setDirectoryServerTrxID($directoryServerTrxID = null)
    {
        // validation for constraint: string
        if (!is_null($directoryServerTrxID) && !is_string($directoryServerTrxID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directoryServerTrxID, true), gettype($directoryServerTrxID)), __LINE__);
        }
        $this->DirectoryServerTrxID = $directoryServerTrxID;
        return $this;
    }
    /**
     * Get LiabilityShiftInd value
     * @return bool|null
     */
    public function getLiabilityShiftInd()
    {
        return $this->LiabilityShiftInd;
    }
    /**
     * Set LiabilityShiftInd value
     * @param bool $liabilityShiftInd
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setLiabilityShiftInd($liabilityShiftInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($liabilityShiftInd) && !is_bool($liabilityShiftInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($liabilityShiftInd, true), gettype($liabilityShiftInd)), __LINE__);
        }
        $this->LiabilityShiftInd = $liabilityShiftInd;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get ThreeDSServerTransID value
     * @return string|null
     */
    public function getThreeDSServerTransID()
    {
        return $this->ThreeDSServerTransID;
    }
    /**
     * Set ThreeDSServerTransID value
     * @param string $threeDSServerTransID
     * @return \SabrePaymentGateway\StructType\T3DS
     */
    public function setThreeDSServerTransID($threeDSServerTransID = null)
    {
        // validation for constraint: string
        if (!is_null($threeDSServerTransID) && !is_string($threeDSServerTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($threeDSServerTransID, true), gettype($threeDSServerTransID)), __LINE__);
        }
        $this->ThreeDSServerTransID = $threeDSServerTransID;
        return $this;
    }
}
