<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceIndicator StructType
 * @subpackage Structs
 */
class ServiceIndicator extends AbstractStructBase
{
    /**
     * The MultiFOPsProcessInd
     * @var string
     */
    public $MultiFOPsProcessInd;
    /**
     * The FraudScreenInd
     * @var bool
     */
    public $FraudScreenInd;
    /**
     * Constructor method for ServiceIndicator
     * @uses ServiceIndicator::setMultiFOPsProcessInd()
     * @uses ServiceIndicator::setFraudScreenInd()
     * @param string $multiFOPsProcessInd
     * @param bool $fraudScreenInd
     */
    public function __construct($multiFOPsProcessInd = null, $fraudScreenInd = null)
    {
        $this
            ->setMultiFOPsProcessInd($multiFOPsProcessInd)
            ->setFraudScreenInd($fraudScreenInd);
    }
    /**
     * Get MultiFOPsProcessInd value
     * @return string|null
     */
    public function getMultiFOPsProcessInd()
    {
        return $this->MultiFOPsProcessInd;
    }
    /**
     * Set MultiFOPsProcessInd value
     * @param string $multiFOPsProcessInd
     * @return \SabrePaymentGateway\StructType\ServiceIndicator
     */
    public function setMultiFOPsProcessInd($multiFOPsProcessInd = null)
    {
        // validation for constraint: string
        if (!is_null($multiFOPsProcessInd) && !is_string($multiFOPsProcessInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($multiFOPsProcessInd, true), gettype($multiFOPsProcessInd)), __LINE__);
        }
        $this->MultiFOPsProcessInd = $multiFOPsProcessInd;
        return $this;
    }
    /**
     * Get FraudScreenInd value
     * @return bool|null
     */
    public function getFraudScreenInd()
    {
        return $this->FraudScreenInd;
    }
    /**
     * Set FraudScreenInd value
     * @param bool $fraudScreenInd
     * @return \SabrePaymentGateway\StructType\ServiceIndicator
     */
    public function setFraudScreenInd($fraudScreenInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($fraudScreenInd) && !is_bool($fraudScreenInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fraudScreenInd, true), gettype($fraudScreenInd)), __LINE__);
        }
        $this->FraudScreenInd = $fraudScreenInd;
        return $this;
    }
}
