<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security StructType
 * Meta information extracted from the WSDL
 * - Prefix: wsse
 * @subpackage Structs
 */
class Security extends AbstractStructBase
{
    /**
     * The UsernameToken
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\UsernameToken
     */
    public $UsernameToken;
    /**
     * The SabreAth
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $SabreAth;
    /**
     * The BinarySecurityToken
     * Meta information extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $BinarySecurityToken;
    /**
     * Constructor method for Security
     * @uses Security::setUsernameToken()
     * @uses Security::setSabreAth()
     * @uses Security::setBinarySecurityToken()
     * @param \SabrePaymentGateway\StructType\UsernameToken $usernameToken
     * @param string $sabreAth
     * @param string $binarySecurityToken
     */
    public function __construct(\SabrePaymentGateway\StructType\UsernameToken $usernameToken = null, $sabreAth = null, $binarySecurityToken = null)
    {
        $this
            ->setUsernameToken($usernameToken)
            ->setSabreAth($sabreAth)
            ->setBinarySecurityToken($binarySecurityToken);
    }
    /**
     * Get UsernameToken value
     * @return \SabrePaymentGateway\StructType\UsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \SabrePaymentGateway\StructType\UsernameToken $usernameToken
     * @return \SabrePaymentGateway\StructType\Security
     */
    public function setUsernameToken(\SabrePaymentGateway\StructType\UsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get SabreAth value
     * @return string|null
     */
    public function getSabreAth()
    {
        return $this->SabreAth;
    }
    /**
     * Set SabreAth value
     * @param string $sabreAth
     * @return \SabrePaymentGateway\StructType\Security
     */
    public function setSabreAth($sabreAth = null)
    {
        // validation for constraint: string
        if (!is_null($sabreAth) && !is_string($sabreAth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sabreAth, true), gettype($sabreAth)), __LINE__);
        }
        $this->SabreAth = $sabreAth;
        return $this;
    }
    /**
     * Get BinarySecurityToken value
     * @return string|null
     */
    public function getBinarySecurityToken()
    {
        return $this->BinarySecurityToken;
    }
    /**
     * Set BinarySecurityToken value
     * @param string $binarySecurityToken
     * @return \SabrePaymentGateway\StructType\Security
     */
    public function setBinarySecurityToken($binarySecurityToken = null)
    {
        // validation for constraint: string
        if (!is_null($binarySecurityToken) && !is_string($binarySecurityToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binarySecurityToken, true), gettype($binarySecurityToken)), __LINE__);
        }
        $this->BinarySecurityToken = $binarySecurityToken;
        return $this;
    }
}
