<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProviderInfoType StructType
 * @subpackage Structs
 */
class ProviderInfoType extends AbstractStructBase
{
    /**
     * The ProviderName
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ProviderName;
    /**
     * The ProviderAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AddressType
     */
    public $ProviderAddress;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\ContactInfoType
     */
    public $Contact;
    /**
     * The ProviderID
     * @var string
     */
    public $ProviderID;
    /**
     * The ProviderSiteID
     * @var string
     */
    public $ProviderSiteID;
    /**
     * The ProviderSiteNote
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ProviderSiteNote;
    /**
     * Constructor method for ProviderInfoType
     * @uses ProviderInfoType::setProviderName()
     * @uses ProviderInfoType::setProviderAddress()
     * @uses ProviderInfoType::setContact()
     * @uses ProviderInfoType::setProviderID()
     * @uses ProviderInfoType::setProviderSiteID()
     * @uses ProviderInfoType::setProviderSiteNote()
     * @param string $providerName
     * @param \SabrePaymentGateway\StructType\AddressType $providerAddress
     * @param \SabrePaymentGateway\StructType\ContactInfoType $contact
     * @param string $providerID
     * @param string $providerSiteID
     * @param string $providerSiteNote
     */
    public function __construct($providerName = null, \SabrePaymentGateway\StructType\AddressType $providerAddress = null, \SabrePaymentGateway\StructType\ContactInfoType $contact = null, $providerID = null, $providerSiteID = null, $providerSiteNote = null)
    {
        $this
            ->setProviderName($providerName)
            ->setProviderAddress($providerAddress)
            ->setContact($contact)
            ->setProviderID($providerID)
            ->setProviderSiteID($providerSiteID)
            ->setProviderSiteNote($providerSiteNote);
    }
    /**
     * Get ProviderName value
     * @return string
     */
    public function getProviderName()
    {
        return $this->ProviderName;
    }
    /**
     * Set ProviderName value
     * @param string $providerName
     * @return \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public function setProviderName($providerName = null)
    {
        // validation for constraint: string
        if (!is_null($providerName) && !is_string($providerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerName, true), gettype($providerName)), __LINE__);
        }
        $this->ProviderName = $providerName;
        return $this;
    }
    /**
     * Get ProviderAddress value
     * @return \SabrePaymentGateway\StructType\AddressType|null
     */
    public function getProviderAddress()
    {
        return $this->ProviderAddress;
    }
    /**
     * Set ProviderAddress value
     * @param \SabrePaymentGateway\StructType\AddressType $providerAddress
     * @return \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public function setProviderAddress(\SabrePaymentGateway\StructType\AddressType $providerAddress = null)
    {
        $this->ProviderAddress = $providerAddress;
        return $this;
    }
    /**
     * Get Contact value
     * @return \SabrePaymentGateway\StructType\ContactInfoType|null
     */
    public function getContact()
    {
        return $this->Contact;
    }
    /**
     * Set Contact value
     * @param \SabrePaymentGateway\StructType\ContactInfoType $contact
     * @return \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public function setContact(\SabrePaymentGateway\StructType\ContactInfoType $contact = null)
    {
        $this->Contact = $contact;
        return $this;
    }
    /**
     * Get ProviderID value
     * @return string|null
     */
    public function getProviderID()
    {
        return $this->ProviderID;
    }
    /**
     * Set ProviderID value
     * @param string $providerID
     * @return \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public function setProviderID($providerID = null)
    {
        // validation for constraint: string
        if (!is_null($providerID) && !is_string($providerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerID, true), gettype($providerID)), __LINE__);
        }
        $this->ProviderID = $providerID;
        return $this;
    }
    /**
     * Get ProviderSiteID value
     * @return string|null
     */
    public function getProviderSiteID()
    {
        return $this->ProviderSiteID;
    }
    /**
     * Set ProviderSiteID value
     * @param string $providerSiteID
     * @return \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public function setProviderSiteID($providerSiteID = null)
    {
        // validation for constraint: string
        if (!is_null($providerSiteID) && !is_string($providerSiteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSiteID, true), gettype($providerSiteID)), __LINE__);
        }
        $this->ProviderSiteID = $providerSiteID;
        return $this;
    }
    /**
     * Get ProviderSiteNote value
     * @return string|null
     */
    public function getProviderSiteNote()
    {
        return $this->ProviderSiteNote;
    }
    /**
     * Set ProviderSiteNote value
     * @param string $providerSiteNote
     * @return \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public function setProviderSiteNote($providerSiteNote = null)
    {
        // validation for constraint: string
        if (!is_null($providerSiteNote) && !is_string($providerSiteNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSiteNote, true), gettype($providerSiteNote)), __LINE__);
        }
        $this->ProviderSiteNote = $providerSiteNote;
        return $this;
    }
}
