<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Root element for any Payment service request
 * @subpackage Structs
 */
class PaymentRQ extends AbstractStructBase
{
    /**
     * The Version
     * Meta information extracted from the WSDL
     * - documentation: Schema version (4.37.0)
     * - use: required
     * @var string
     */
    public $Version;
    /**
     * The Action
     * @var \SabrePaymentGateway\StructType\Action
     */
    public $Action;
    /**
     * The POS
     * @var \SabrePaymentGateway\StructType\POS_Type
     */
    public $POS;
    /**
     * The ServiceIndicator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\ServiceIndicator
     */
    public $ServiceIndicator;
    /**
     * The MerchantDetail
     * @var \SabrePaymentGateway\StructType\MerchantDetailType
     */
    public $MerchantDetail;
    /**
     * The AuthenticationDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AuthenticationDetailType
     */
    public $AuthenticationDetail;
    /**
     * The OrderDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\OrderDetail
     */
    public $OrderDetail;
    /**
     * The AccountDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AccountDetailType[]
     */
    public $AccountDetail;
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PaymentDetailType[]
     */
    public $PaymentDetail;
    /**
     * The CustomerDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CustomerDetail
     */
    public $CustomerDetail;
    /**
     * The SystemDateTime
     * Meta information extracted from the WSDL
     * - documentation: Indicates the creation date and time of the message in UTC format
     * @var string
     */
    public $SystemDateTime;
    /**
     * The SabreTransactionID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier generated by PWS
     * - use: optional
     * @var string
     */
    public $SabreTransactionID;
    /**
     * The LinkageID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier Used for linking PWS transactions
     * - use: optional
     * @var string
     */
    public $LinkageID;
    /**
     * The DeferredPaymentID
     * @var string
     */
    public $DeferredPaymentID;
    /**
     * The ReturnSupplierMessagesInd
     * Meta information extracted from the WSDL
     * - documentation: For test environment only. If set to true, supplier request/response will be included in PaymentRS
     * - use: optional
     * @var bool
     */
    public $ReturnSupplierMessagesInd;
    /**
     * The RetransmissionIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, indicates the message is being re-sent after a failure. It is recommended that this attribute is used (i.e., set to TRUE) only when a message is retransmitted.
     * - use: optional
     * @var bool
     */
    public $RetransmissionIndicator;
    /**
     * The POSActionCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $POSActionCode;
    /**
     * Constructor method for PaymentRQ
     * @uses PaymentRQ::setVersion()
     * @uses PaymentRQ::setAction()
     * @uses PaymentRQ::setPOS()
     * @uses PaymentRQ::setServiceIndicator()
     * @uses PaymentRQ::setMerchantDetail()
     * @uses PaymentRQ::setAuthenticationDetail()
     * @uses PaymentRQ::setOrderDetail()
     * @uses PaymentRQ::setAccountDetail()
     * @uses PaymentRQ::setPaymentDetail()
     * @uses PaymentRQ::setCustomerDetail()
     * @uses PaymentRQ::setSystemDateTime()
     * @uses PaymentRQ::setSabreTransactionID()
     * @uses PaymentRQ::setLinkageID()
     * @uses PaymentRQ::setDeferredPaymentID()
     * @uses PaymentRQ::setReturnSupplierMessagesInd()
     * @uses PaymentRQ::setRetransmissionIndicator()
     * @uses PaymentRQ::setPOSActionCode()
     * @param string $version
     * @param \SabrePaymentGateway\StructType\Action $action
     * @param \SabrePaymentGateway\StructType\POS_Type $pOS
     * @param \SabrePaymentGateway\StructType\ServiceIndicator $serviceIndicator
     * @param \SabrePaymentGateway\StructType\MerchantDetailType $merchantDetail
     * @param \SabrePaymentGateway\StructType\AuthenticationDetailType $authenticationDetail
     * @param \SabrePaymentGateway\StructType\OrderDetail $orderDetail
     * @param \SabrePaymentGateway\StructType\AccountDetailType[] $accountDetail
     * @param \SabrePaymentGateway\StructType\PaymentDetailType[] $paymentDetail
     * @param \SabrePaymentGateway\StructType\CustomerDetail $customerDetail
     * @param string $systemDateTime
     * @param string $sabreTransactionID
     * @param string $linkageID
     * @param string $deferredPaymentID
     * @param bool $returnSupplierMessagesInd
     * @param bool $retransmissionIndicator
     * @param string $pOSActionCode
     */
    public function __construct($version = null, \SabrePaymentGateway\StructType\Action $action = null, \SabrePaymentGateway\StructType\POS_Type $pOS = null, \SabrePaymentGateway\StructType\ServiceIndicator $serviceIndicator = null, \SabrePaymentGateway\StructType\MerchantDetailType $merchantDetail = null, \SabrePaymentGateway\StructType\AuthenticationDetailType $authenticationDetail = null, \SabrePaymentGateway\StructType\OrderDetail $orderDetail = null, array $accountDetail = array(), array $paymentDetail = array(), \SabrePaymentGateway\StructType\CustomerDetail $customerDetail = null, $systemDateTime = null, $sabreTransactionID = null, $linkageID = null, $deferredPaymentID = null, $returnSupplierMessagesInd = null, $retransmissionIndicator = null, $pOSActionCode = null)
    {
        $this
            ->setVersion($version)
            ->setAction($action)
            ->setPOS($pOS)
            ->setServiceIndicator($serviceIndicator)
            ->setMerchantDetail($merchantDetail)
            ->setAuthenticationDetail($authenticationDetail)
            ->setOrderDetail($orderDetail)
            ->setAccountDetail($accountDetail)
            ->setPaymentDetail($paymentDetail)
            ->setCustomerDetail($customerDetail)
            ->setSystemDateTime($systemDateTime)
            ->setSabreTransactionID($sabreTransactionID)
            ->setLinkageID($linkageID)
            ->setDeferredPaymentID($deferredPaymentID)
            ->setReturnSupplierMessagesInd($returnSupplierMessagesInd)
            ->setRetransmissionIndicator($retransmissionIndicator)
            ->setPOSActionCode($pOSActionCode);
    }
    /**
     * Get Version value
     * @return string
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Action value
     * @return \SabrePaymentGateway\StructType\Action|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * Set Action value
     * @param \SabrePaymentGateway\StructType\Action $action
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setAction(\SabrePaymentGateway\StructType\Action $action = null)
    {
        $this->Action = $action;
        return $this;
    }
    /**
     * Get POS value
     * @return \SabrePaymentGateway\StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \SabrePaymentGateway\StructType\POS_Type $pOS
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setPOS(\SabrePaymentGateway\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get ServiceIndicator value
     * @return \SabrePaymentGateway\StructType\ServiceIndicator|null
     */
    public function getServiceIndicator()
    {
        return $this->ServiceIndicator;
    }
    /**
     * Set ServiceIndicator value
     * @param \SabrePaymentGateway\StructType\ServiceIndicator $serviceIndicator
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setServiceIndicator(\SabrePaymentGateway\StructType\ServiceIndicator $serviceIndicator = null)
    {
        $this->ServiceIndicator = $serviceIndicator;
        return $this;
    }
    /**
     * Get MerchantDetail value
     * @return \SabrePaymentGateway\StructType\MerchantDetailType|null
     */
    public function getMerchantDetail()
    {
        return $this->MerchantDetail;
    }
    /**
     * Set MerchantDetail value
     * @param \SabrePaymentGateway\StructType\MerchantDetailType $merchantDetail
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setMerchantDetail(\SabrePaymentGateway\StructType\MerchantDetailType $merchantDetail = null)
    {
        $this->MerchantDetail = $merchantDetail;
        return $this;
    }
    /**
     * Get AuthenticationDetail value
     * @return \SabrePaymentGateway\StructType\AuthenticationDetailType|null
     */
    public function getAuthenticationDetail()
    {
        return $this->AuthenticationDetail;
    }
    /**
     * Set AuthenticationDetail value
     * @param \SabrePaymentGateway\StructType\AuthenticationDetailType $authenticationDetail
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setAuthenticationDetail(\SabrePaymentGateway\StructType\AuthenticationDetailType $authenticationDetail = null)
    {
        $this->AuthenticationDetail = $authenticationDetail;
        return $this;
    }
    /**
     * Get OrderDetail value
     * @return \SabrePaymentGateway\StructType\OrderDetail|null
     */
    public function getOrderDetail()
    {
        return $this->OrderDetail;
    }
    /**
     * Set OrderDetail value
     * @param \SabrePaymentGateway\StructType\OrderDetail $orderDetail
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setOrderDetail(\SabrePaymentGateway\StructType\OrderDetail $orderDetail = null)
    {
        $this->OrderDetail = $orderDetail;
        return $this;
    }
    /**
     * Get AccountDetail value
     * @return \SabrePaymentGateway\StructType\AccountDetailType[]|null
     */
    public function getAccountDetail()
    {
        return $this->AccountDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setAccountDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccountDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccountDetailForArrayConstraintsFromSetAccountDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRQAccountDetailItem) {
            // validation for constraint: itemType
            if (!$paymentRQAccountDetailItem instanceof \SabrePaymentGateway\StructType\AccountDetailType) {
                $invalidValues[] = is_object($paymentRQAccountDetailItem) ? get_class($paymentRQAccountDetailItem) : sprintf('%s(%s)', gettype($paymentRQAccountDetailItem), var_export($paymentRQAccountDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AccountDetail property can only contain items of type \SabrePaymentGateway\StructType\AccountDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccountDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\AccountDetailType[] $accountDetail
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setAccountDetail(array $accountDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($accountDetailArrayErrorMessage = self::validateAccountDetailForArrayConstraintsFromSetAccountDetail($accountDetail))) {
            throw new \InvalidArgumentException($accountDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($accountDetail) && count($accountDetail) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($accountDetail)), __LINE__);
        }
        $this->AccountDetail = $accountDetail;
        return $this;
    }
    /**
     * Add item to AccountDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\AccountDetailType $item
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function addToAccountDetail(\SabrePaymentGateway\StructType\AccountDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\AccountDetailType) {
            throw new \InvalidArgumentException(sprintf('The AccountDetail property can only contain items of type \SabrePaymentGateway\StructType\AccountDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->AccountDetail) && count($this->AccountDetail) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->AccountDetail)), __LINE__);
        }
        $this->AccountDetail[] = $item;
        return $this;
    }
    /**
     * Get PaymentDetail value
     * @return \SabrePaymentGateway\StructType\PaymentDetailType[]|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentDetailForArrayConstraintsFromSetPaymentDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $paymentRQPaymentDetailItem) {
            // validation for constraint: itemType
            if (!$paymentRQPaymentDetailItem instanceof \SabrePaymentGateway\StructType\PaymentDetailType) {
                $invalidValues[] = is_object($paymentRQPaymentDetailItem) ? get_class($paymentRQPaymentDetailItem) : sprintf('%s(%s)', gettype($paymentRQPaymentDetailItem), var_export($paymentRQPaymentDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentDetail property can only contain items of type \SabrePaymentGateway\StructType\PaymentDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PaymentDetailType[] $paymentDetail
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setPaymentDetail(array $paymentDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentDetailArrayErrorMessage = self::validatePaymentDetailForArrayConstraintsFromSetPaymentDetail($paymentDetail))) {
            throw new \InvalidArgumentException($paymentDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($paymentDetail) && count($paymentDetail) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($paymentDetail)), __LINE__);
        }
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Add item to PaymentDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PaymentDetailType $item
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function addToPaymentDetail(\SabrePaymentGateway\StructType\PaymentDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\PaymentDetailType) {
            throw new \InvalidArgumentException(sprintf('The PaymentDetail property can only contain items of type \SabrePaymentGateway\StructType\PaymentDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->PaymentDetail) && count($this->PaymentDetail) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->PaymentDetail)), __LINE__);
        }
        $this->PaymentDetail[] = $item;
        return $this;
    }
    /**
     * Get CustomerDetail value
     * @return \SabrePaymentGateway\StructType\CustomerDetail|null
     */
    public function getCustomerDetail()
    {
        return $this->CustomerDetail;
    }
    /**
     * Set CustomerDetail value
     * @param \SabrePaymentGateway\StructType\CustomerDetail $customerDetail
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setCustomerDetail(\SabrePaymentGateway\StructType\CustomerDetail $customerDetail = null)
    {
        $this->CustomerDetail = $customerDetail;
        return $this;
    }
    /**
     * Get SystemDateTime value
     * @return string|null
     */
    public function getSystemDateTime()
    {
        return $this->SystemDateTime;
    }
    /**
     * Set SystemDateTime value
     * @param string $systemDateTime
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setSystemDateTime($systemDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($systemDateTime) && !is_string($systemDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemDateTime, true), gettype($systemDateTime)), __LINE__);
        }
        $this->SystemDateTime = $systemDateTime;
        return $this;
    }
    /**
     * Get SabreTransactionID value
     * @return string|null
     */
    public function getSabreTransactionID()
    {
        return $this->SabreTransactionID;
    }
    /**
     * Set SabreTransactionID value
     * @param string $sabreTransactionID
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setSabreTransactionID($sabreTransactionID = null)
    {
        // validation for constraint: string
        if (!is_null($sabreTransactionID) && !is_string($sabreTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sabreTransactionID, true), gettype($sabreTransactionID)), __LINE__);
        }
        $this->SabreTransactionID = $sabreTransactionID;
        return $this;
    }
    /**
     * Get LinkageID value
     * @return string|null
     */
    public function getLinkageID()
    {
        return $this->LinkageID;
    }
    /**
     * Set LinkageID value
     * @param string $linkageID
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setLinkageID($linkageID = null)
    {
        // validation for constraint: string
        if (!is_null($linkageID) && !is_string($linkageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkageID, true), gettype($linkageID)), __LINE__);
        }
        $this->LinkageID = $linkageID;
        return $this;
    }
    /**
     * Get DeferredPaymentID value
     * @return string|null
     */
    public function getDeferredPaymentID()
    {
        return $this->DeferredPaymentID;
    }
    /**
     * Set DeferredPaymentID value
     * @param string $deferredPaymentID
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setDeferredPaymentID($deferredPaymentID = null)
    {
        // validation for constraint: string
        if (!is_null($deferredPaymentID) && !is_string($deferredPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deferredPaymentID, true), gettype($deferredPaymentID)), __LINE__);
        }
        $this->DeferredPaymentID = $deferredPaymentID;
        return $this;
    }
    /**
     * Get ReturnSupplierMessagesInd value
     * @return bool|null
     */
    public function getReturnSupplierMessagesInd()
    {
        return $this->ReturnSupplierMessagesInd;
    }
    /**
     * Set ReturnSupplierMessagesInd value
     * @param bool $returnSupplierMessagesInd
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setReturnSupplierMessagesInd($returnSupplierMessagesInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnSupplierMessagesInd) && !is_bool($returnSupplierMessagesInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnSupplierMessagesInd, true), gettype($returnSupplierMessagesInd)), __LINE__);
        }
        $this->ReturnSupplierMessagesInd = $returnSupplierMessagesInd;
        return $this;
    }
    /**
     * Get RetransmissionIndicator value
     * @return bool|null
     */
    public function getRetransmissionIndicator()
    {
        return $this->RetransmissionIndicator;
    }
    /**
     * Set RetransmissionIndicator value
     * @param bool $retransmissionIndicator
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setRetransmissionIndicator($retransmissionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($retransmissionIndicator) && !is_bool($retransmissionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retransmissionIndicator, true), gettype($retransmissionIndicator)), __LINE__);
        }
        $this->RetransmissionIndicator = $retransmissionIndicator;
        return $this;
    }
    /**
     * Get POSActionCode value
     * @return string|null
     */
    public function getPOSActionCode()
    {
        return $this->POSActionCode;
    }
    /**
     * Set POSActionCode value
     * @param string $pOSActionCode
     * @return \SabrePaymentGateway\StructType\PaymentRQ
     */
    public function setPOSActionCode($pOSActionCode = null)
    {
        // validation for constraint: string
        if (!is_null($pOSActionCode) && !is_string($pOSActionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pOSActionCode, true), gettype($pOSActionCode)), __LINE__);
        }
        $this->POSActionCode = $pOSActionCode;
        return $this;
    }
}
