<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PassengerDetailType StructType
 * @subpackage Structs
 */
class PassengerDetailType extends AbstractStructBase
{
    /**
     * The Identifications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PersonID_Type
     */
    public $Identifications;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\Document[]
     */
    public $Document;
    /**
     * The FlightDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 32
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\FlightDetailType[]
     */
    public $FlightDetail;
    /**
     * The LoyaltyMemberDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType
     */
    public $LoyaltyMemberDetail;
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\ContactInfoType
     */
    public $ContactInfo;
    /**
     * The RemarkLines
     * Meta information extracted from the WSDL
     * - documentation: e.g. PNR Remarks
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarkLinesType[]
     */
    public $RemarkLines;
    /**
     * The NameInPNR
     * Meta information extracted from the WSDL
     * - documentation: e.g. SMITH/JOHN MR
     * - use: optional
     * @var string
     */
    public $NameInPNR;
    /**
     * The NameNumberInPNR
     * Meta information extracted from the WSDL
     * - documentation: e.g. 1.1
     * - use: optional
     * @var string
     */
    public $NameNumberInPNR;
    /**
     * The PsgrType
     * Meta information extracted from the WSDL
     * - documentation: ADT - Adult CHD - Child INF - Infant MIL - Military etc.
     * - use: optional
     * @var string
     */
    public $PsgrType;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - documentation: M/F
     * - use: optional
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: 1980-07-31
     * - use: optional
     * @var string
     */
    public $BirthDate;
    /**
     * The FrequentFlyerID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FrequentFlyerID;
    /**
     * The FrequentFlyerStatus
     * Meta information extracted from the WSDL
     * - documentation: e.g. PLATINUM
     * - use: optional
     * @var string
     */
    public $FrequentFlyerStatus;
    /**
     * The FrequentFlierID
     * Meta information extracted from the WSDL
     * - documentation: Deprecated
     * - use: optional
     * @var string
     */
    public $FrequentFlierID;
    /**
     * The FrequentFlierStatus
     * Meta information extracted from the WSDL
     * - documentation: Deprecated
     * - use: optional
     * @var string
     */
    public $FrequentFlierStatus;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $Title;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $FirstName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $MiddleName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - type: xs:string
     * - use: optional
     * @var string
     */
    public $LastName;
    /**
     * Constructor method for PassengerDetailType
     * @uses PassengerDetailType::setIdentifications()
     * @uses PassengerDetailType::setDocument()
     * @uses PassengerDetailType::setFlightDetail()
     * @uses PassengerDetailType::setLoyaltyMemberDetail()
     * @uses PassengerDetailType::setContactInfo()
     * @uses PassengerDetailType::setRemarkLines()
     * @uses PassengerDetailType::setNameInPNR()
     * @uses PassengerDetailType::setNameNumberInPNR()
     * @uses PassengerDetailType::setPsgrType()
     * @uses PassengerDetailType::setGender()
     * @uses PassengerDetailType::setBirthDate()
     * @uses PassengerDetailType::setFrequentFlyerID()
     * @uses PassengerDetailType::setFrequentFlyerStatus()
     * @uses PassengerDetailType::setFrequentFlierID()
     * @uses PassengerDetailType::setFrequentFlierStatus()
     * @uses PassengerDetailType::setName()
     * @uses PassengerDetailType::setTitle()
     * @uses PassengerDetailType::setFirstName()
     * @uses PassengerDetailType::setMiddleName()
     * @uses PassengerDetailType::setLastName()
     * @param \SabrePaymentGateway\StructType\PersonID_Type $identifications
     * @param \SabrePaymentGateway\StructType\Document[] $document
     * @param \SabrePaymentGateway\StructType\FlightDetailType[] $flightDetail
     * @param \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail
     * @param \SabrePaymentGateway\StructType\ContactInfoType $contactInfo
     * @param \SabrePaymentGateway\StructType\RemarkLinesType[] $remarkLines
     * @param string $nameInPNR
     * @param string $nameNumberInPNR
     * @param string $psgrType
     * @param string $gender
     * @param string $birthDate
     * @param string $frequentFlyerID
     * @param string $frequentFlyerStatus
     * @param string $frequentFlierID
     * @param string $frequentFlierStatus
     * @param string $name
     * @param string $title
     * @param string $firstName
     * @param string $middleName
     * @param string $lastName
     */
    public function __construct(\SabrePaymentGateway\StructType\PersonID_Type $identifications = null, array $document = array(), array $flightDetail = array(), \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail = null, \SabrePaymentGateway\StructType\ContactInfoType $contactInfo = null, array $remarkLines = array(), $nameInPNR = null, $nameNumberInPNR = null, $psgrType = null, $gender = null, $birthDate = null, $frequentFlyerID = null, $frequentFlyerStatus = null, $frequentFlierID = null, $frequentFlierStatus = null, $name = null, $title = null, $firstName = null, $middleName = null, $lastName = null)
    {
        $this
            ->setIdentifications($identifications)
            ->setDocument($document)
            ->setFlightDetail($flightDetail)
            ->setLoyaltyMemberDetail($loyaltyMemberDetail)
            ->setContactInfo($contactInfo)
            ->setRemarkLines($remarkLines)
            ->setNameInPNR($nameInPNR)
            ->setNameNumberInPNR($nameNumberInPNR)
            ->setPsgrType($psgrType)
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setFrequentFlyerID($frequentFlyerID)
            ->setFrequentFlyerStatus($frequentFlyerStatus)
            ->setFrequentFlierID($frequentFlierID)
            ->setFrequentFlierStatus($frequentFlierStatus)
            ->setName($name)
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setMiddleName($middleName)
            ->setLastName($lastName);
    }
    /**
     * Get Identifications value
     * @return \SabrePaymentGateway\StructType\PersonID_Type|null
     */
    public function getIdentifications()
    {
        return $this->Identifications;
    }
    /**
     * Set Identifications value
     * @param \SabrePaymentGateway\StructType\PersonID_Type $identifications
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setIdentifications(\SabrePaymentGateway\StructType\PersonID_Type $identifications = null)
    {
        $this->Identifications = $identifications;
        return $this;
    }
    /**
     * Get Document value
     * @return \SabrePaymentGateway\StructType\Document[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $passengerDetailTypeDocumentItem) {
            // validation for constraint: itemType
            if (!$passengerDetailTypeDocumentItem instanceof \SabrePaymentGateway\StructType\Document) {
                $invalidValues[] = is_object($passengerDetailTypeDocumentItem) ? get_class($passengerDetailTypeDocumentItem) : sprintf('%s(%s)', gettype($passengerDetailTypeDocumentItem), var_export($passengerDetailTypeDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \SabrePaymentGateway\StructType\Document, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Document[] $document
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($document) && count($document) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($document)), __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\Document $item
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function addToDocument(\SabrePaymentGateway\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \SabrePaymentGateway\StructType\Document, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Document) && count($this->Document) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Document)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Get FlightDetail value
     * @return \SabrePaymentGateway\StructType\FlightDetailType[]|null
     */
    public function getFlightDetail()
    {
        return $this->FlightDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightDetailForArrayConstraintsFromSetFlightDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $passengerDetailTypeFlightDetailItem) {
            // validation for constraint: itemType
            if (!$passengerDetailTypeFlightDetailItem instanceof \SabrePaymentGateway\StructType\FlightDetailType) {
                $invalidValues[] = is_object($passengerDetailTypeFlightDetailItem) ? get_class($passengerDetailTypeFlightDetailItem) : sprintf('%s(%s)', gettype($passengerDetailTypeFlightDetailItem), var_export($passengerDetailTypeFlightDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightDetail property can only contain items of type \SabrePaymentGateway\StructType\FlightDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\FlightDetailType[] $flightDetail
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setFlightDetail(array $flightDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($flightDetailArrayErrorMessage = self::validateFlightDetailForArrayConstraintsFromSetFlightDetail($flightDetail))) {
            throw new \InvalidArgumentException($flightDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(32)
        if (is_array($flightDetail) && count($flightDetail) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 32', count($flightDetail)), __LINE__);
        }
        $this->FlightDetail = $flightDetail;
        return $this;
    }
    /**
     * Add item to FlightDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\FlightDetailType $item
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function addToFlightDetail(\SabrePaymentGateway\StructType\FlightDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\FlightDetailType) {
            throw new \InvalidArgumentException(sprintf('The FlightDetail property can only contain items of type \SabrePaymentGateway\StructType\FlightDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(32)
        if (is_array($this->FlightDetail) && count($this->FlightDetail) >= 32) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 32', count($this->FlightDetail)), __LINE__);
        }
        $this->FlightDetail[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyMemberDetail value
     * @return \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType|null
     */
    public function getLoyaltyMemberDetail()
    {
        return $this->LoyaltyMemberDetail;
    }
    /**
     * Set LoyaltyMemberDetail value
     * @param \SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setLoyaltyMemberDetail(\SabrePaymentGateway\StructType\LoyaltyMembershipDetailType $loyaltyMemberDetail = null)
    {
        $this->LoyaltyMemberDetail = $loyaltyMemberDetail;
        return $this;
    }
    /**
     * Get ContactInfo value
     * @return \SabrePaymentGateway\StructType\ContactInfoType|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * Set ContactInfo value
     * @param \SabrePaymentGateway\StructType\ContactInfoType $contactInfo
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setContactInfo(\SabrePaymentGateway\StructType\ContactInfoType $contactInfo = null)
    {
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Get RemarkLines value
     * @return \SabrePaymentGateway\StructType\RemarkLinesType[]|null
     */
    public function getRemarkLines()
    {
        return $this->RemarkLines;
    }
    /**
     * This method is responsible for validating the values passed to the setRemarkLines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRemarkLines method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRemarkLinesForArrayConstraintsFromSetRemarkLines(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $passengerDetailTypeRemarkLinesItem) {
            // validation for constraint: itemType
            if (!$passengerDetailTypeRemarkLinesItem instanceof \SabrePaymentGateway\StructType\RemarkLinesType) {
                $invalidValues[] = is_object($passengerDetailTypeRemarkLinesItem) ? get_class($passengerDetailTypeRemarkLinesItem) : sprintf('%s(%s)', gettype($passengerDetailTypeRemarkLinesItem), var_export($passengerDetailTypeRemarkLinesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RemarkLines property can only contain items of type \SabrePaymentGateway\StructType\RemarkLinesType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RemarkLines value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\RemarkLinesType[] $remarkLines
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setRemarkLines(array $remarkLines = array())
    {
        // validation for constraint: array
        if ('' !== ($remarkLinesArrayErrorMessage = self::validateRemarkLinesForArrayConstraintsFromSetRemarkLines($remarkLines))) {
            throw new \InvalidArgumentException($remarkLinesArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($remarkLines) && count($remarkLines) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($remarkLines)), __LINE__);
        }
        $this->RemarkLines = $remarkLines;
        return $this;
    }
    /**
     * Add item to RemarkLines value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\RemarkLinesType $item
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function addToRemarkLines(\SabrePaymentGateway\StructType\RemarkLinesType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\RemarkLinesType) {
            throw new \InvalidArgumentException(sprintf('The RemarkLines property can only contain items of type \SabrePaymentGateway\StructType\RemarkLinesType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->RemarkLines) && count($this->RemarkLines) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->RemarkLines)), __LINE__);
        }
        $this->RemarkLines[] = $item;
        return $this;
    }
    /**
     * Get NameInPNR value
     * @return string|null
     */
    public function getNameInPNR()
    {
        return $this->NameInPNR;
    }
    /**
     * Set NameInPNR value
     * @param string $nameInPNR
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setNameInPNR($nameInPNR = null)
    {
        // validation for constraint: string
        if (!is_null($nameInPNR) && !is_string($nameInPNR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameInPNR, true), gettype($nameInPNR)), __LINE__);
        }
        $this->NameInPNR = $nameInPNR;
        return $this;
    }
    /**
     * Get NameNumberInPNR value
     * @return string|null
     */
    public function getNameNumberInPNR()
    {
        return $this->NameNumberInPNR;
    }
    /**
     * Set NameNumberInPNR value
     * @param string $nameNumberInPNR
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setNameNumberInPNR($nameNumberInPNR = null)
    {
        // validation for constraint: string
        if (!is_null($nameNumberInPNR) && !is_string($nameNumberInPNR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameNumberInPNR, true), gettype($nameNumberInPNR)), __LINE__);
        }
        $this->NameNumberInPNR = $nameNumberInPNR;
        return $this;
    }
    /**
     * Get PsgrType value
     * @return string|null
     */
    public function getPsgrType()
    {
        return $this->PsgrType;
    }
    /**
     * Set PsgrType value
     * @param string $psgrType
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setPsgrType($psgrType = null)
    {
        // validation for constraint: string
        if (!is_null($psgrType) && !is_string($psgrType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($psgrType, true), gettype($psgrType)), __LINE__);
        }
        $this->PsgrType = $psgrType;
        return $this;
    }
    /**
     * Get Gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->Gender;
    }
    /**
     * Set Gender value
     * @param string $gender
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        $this->Gender = $gender;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get FrequentFlyerID value
     * @return string|null
     */
    public function getFrequentFlyerID()
    {
        return $this->FrequentFlyerID;
    }
    /**
     * Set FrequentFlyerID value
     * @param string $frequentFlyerID
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setFrequentFlyerID($frequentFlyerID = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerID) && !is_string($frequentFlyerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerID, true), gettype($frequentFlyerID)), __LINE__);
        }
        $this->FrequentFlyerID = $frequentFlyerID;
        return $this;
    }
    /**
     * Get FrequentFlyerStatus value
     * @return string|null
     */
    public function getFrequentFlyerStatus()
    {
        return $this->FrequentFlyerStatus;
    }
    /**
     * Set FrequentFlyerStatus value
     * @param string $frequentFlyerStatus
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setFrequentFlyerStatus($frequentFlyerStatus = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlyerStatus) && !is_string($frequentFlyerStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlyerStatus, true), gettype($frequentFlyerStatus)), __LINE__);
        }
        $this->FrequentFlyerStatus = $frequentFlyerStatus;
        return $this;
    }
    /**
     * Get FrequentFlierID value
     * @return string|null
     */
    public function getFrequentFlierID()
    {
        return $this->FrequentFlierID;
    }
    /**
     * Set FrequentFlierID value
     * @param string $frequentFlierID
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setFrequentFlierID($frequentFlierID = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlierID) && !is_string($frequentFlierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlierID, true), gettype($frequentFlierID)), __LINE__);
        }
        $this->FrequentFlierID = $frequentFlierID;
        return $this;
    }
    /**
     * Get FrequentFlierStatus value
     * @return string|null
     */
    public function getFrequentFlierStatus()
    {
        return $this->FrequentFlierStatus;
    }
    /**
     * Set FrequentFlierStatus value
     * @param string $frequentFlierStatus
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setFrequentFlierStatus($frequentFlierStatus = null)
    {
        // validation for constraint: string
        if (!is_null($frequentFlierStatus) && !is_string($frequentFlierStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($frequentFlierStatus, true), gettype($frequentFlierStatus)), __LINE__);
        }
        $this->FrequentFlierStatus = $frequentFlierStatus;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get LastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->LastName;
    }
    /**
     * Set LastName value
     * @param string $lastName
     * @return \SabrePaymentGateway\StructType\PassengerDetailType
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        $this->LastName = $lastName;
        return $this;
    }
}
