<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MerchantDetailType StructType
 * @subpackage Structs
 */
class MerchantDetailType extends AbstractStructBase
{
    /**
     * The MerchantID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $MerchantID;
    /**
     * The MerchantName
     * @var string
     */
    public $MerchantName;
    /**
     * The MerchantCategoryCode
     * @var string
     */
    public $MerchantCategoryCode;
    /**
     * Constructor method for MerchantDetailType
     * @uses MerchantDetailType::setMerchantID()
     * @uses MerchantDetailType::setMerchantName()
     * @uses MerchantDetailType::setMerchantCategoryCode()
     * @param string $merchantID
     * @param string $merchantName
     * @param string $merchantCategoryCode
     */
    public function __construct($merchantID = null, $merchantName = null, $merchantCategoryCode = null)
    {
        $this
            ->setMerchantID($merchantID)
            ->setMerchantName($merchantName)
            ->setMerchantCategoryCode($merchantCategoryCode);
    }
    /**
     * Get MerchantID value
     * @return string
     */
    public function getMerchantID()
    {
        return $this->MerchantID;
    }
    /**
     * Set MerchantID value
     * @param string $merchantID
     * @return \SabrePaymentGateway\StructType\MerchantDetailType
     */
    public function setMerchantID($merchantID = null)
    {
        // validation for constraint: string
        if (!is_null($merchantID) && !is_string($merchantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantID, true), gettype($merchantID)), __LINE__);
        }
        $this->MerchantID = $merchantID;
        return $this;
    }
    /**
     * Get MerchantName value
     * @return string|null
     */
    public function getMerchantName()
    {
        return $this->MerchantName;
    }
    /**
     * Set MerchantName value
     * @param string $merchantName
     * @return \SabrePaymentGateway\StructType\MerchantDetailType
     */
    public function setMerchantName($merchantName = null)
    {
        // validation for constraint: string
        if (!is_null($merchantName) && !is_string($merchantName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantName, true), gettype($merchantName)), __LINE__);
        }
        $this->MerchantName = $merchantName;
        return $this;
    }
    /**
     * Get MerchantCategoryCode value
     * @return string|null
     */
    public function getMerchantCategoryCode()
    {
        return $this->MerchantCategoryCode;
    }
    /**
     * Set MerchantCategoryCode value
     * @param string $merchantCategoryCode
     * @return \SabrePaymentGateway\StructType\MerchantDetailType
     */
    public function setMerchantCategoryCode($merchantCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($merchantCategoryCode) && !is_string($merchantCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantCategoryCode, true), gettype($merchantCategoryCode)), __LINE__);
        }
        $this->MerchantCategoryCode = $merchantCategoryCode;
        return $this;
    }
}
