<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDeploymentResultType StructType
 * @subpackage Structs
 */
class GetDeploymentResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The PaymentCard
     * @var \SabrePaymentGateway\StructType\PaymentCardType
     */
    public $PaymentCard;
    /**
     * The AmountDetail
     * @var \SabrePaymentGateway\StructType\CurrencyAmountType
     */
    public $AmountDetail;
    /**
     * The CustomIdentifiers
     * Meta information extracted from the WSDL
     * - documentation: Custom identifier data are submitted into Financial Partners system to report data via electronic reporting systems or to be printed on the paper statement
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CustomIdentifiersType
     */
    public $CustomIdentifiers;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The CardDeploymentID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardDeploymentID;
    /**
     * The CardStatus
     * Meta information extracted from the WSDL
     * - documentation: Card status e.g. Deployed
     * - use: optional
     * @var string
     */
    public $CardStatus;
    /**
     * The PurchaseType
     * Meta information extracted from the WSDL
     * - documentation: Type of purchase that the virtual card is deployed e.g. Generic
     * - use: optional
     * @var string
     */
    public $PurchaseType;
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Booking identifier as shown in the supplier/vendor system. This could also be The PNR locator in GDS/CRS system
     * - use: optional
     * @var string
     */
    public $BookingID;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * Constructor method for GetDeploymentResultType
     * @uses GetDeploymentResultType::setResponseCode()
     * @uses GetDeploymentResultType::setPaymentCard()
     * @uses GetDeploymentResultType::setAmountDetail()
     * @uses GetDeploymentResultType::setCustomIdentifiers()
     * @uses GetDeploymentResultType::setDescription()
     * @uses GetDeploymentResultType::setCardDeploymentID()
     * @uses GetDeploymentResultType::setCardStatus()
     * @uses GetDeploymentResultType::setPurchaseType()
     * @uses GetDeploymentResultType::setBookingID()
     * @uses GetDeploymentResultType::setSupplierID()
     * @param string $responseCode
     * @param \SabrePaymentGateway\StructType\PaymentCardType $paymentCard
     * @param \SabrePaymentGateway\StructType\CurrencyAmountType $amountDetail
     * @param \SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers
     * @param string $description
     * @param string $cardDeploymentID
     * @param string $cardStatus
     * @param string $purchaseType
     * @param string $bookingID
     * @param string $supplierID
     */
    public function __construct($responseCode = null, \SabrePaymentGateway\StructType\PaymentCardType $paymentCard = null, \SabrePaymentGateway\StructType\CurrencyAmountType $amountDetail = null, \SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers = null, $description = null, $cardDeploymentID = null, $cardStatus = null, $purchaseType = null, $bookingID = null, $supplierID = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setPaymentCard($paymentCard)
            ->setAmountDetail($amountDetail)
            ->setCustomIdentifiers($customIdentifiers)
            ->setDescription($description)
            ->setCardDeploymentID($cardDeploymentID)
            ->setCardStatus($cardStatus)
            ->setPurchaseType($purchaseType)
            ->setBookingID($bookingID)
            ->setSupplierID($supplierID);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \SabrePaymentGateway\StructType\PaymentCardType|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * Set PaymentCard value
     * @param \SabrePaymentGateway\StructType\PaymentCardType $paymentCard
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setPaymentCard(\SabrePaymentGateway\StructType\PaymentCardType $paymentCard = null)
    {
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Get AmountDetail value
     * @return \SabrePaymentGateway\StructType\CurrencyAmountType|null
     */
    public function getAmountDetail()
    {
        return $this->AmountDetail;
    }
    /**
     * Set AmountDetail value
     * @param \SabrePaymentGateway\StructType\CurrencyAmountType $amountDetail
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setAmountDetail(\SabrePaymentGateway\StructType\CurrencyAmountType $amountDetail = null)
    {
        $this->AmountDetail = $amountDetail;
        return $this;
    }
    /**
     * Get CustomIdentifiers value
     * @return \SabrePaymentGateway\StructType\CustomIdentifiersType|null
     */
    public function getCustomIdentifiers()
    {
        return $this->CustomIdentifiers;
    }
    /**
     * Set CustomIdentifiers value
     * @param \SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setCustomIdentifiers(\SabrePaymentGateway\StructType\CustomIdentifiersType $customIdentifiers = null)
    {
        $this->CustomIdentifiers = $customIdentifiers;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CardDeploymentID value
     * @return string|null
     */
    public function getCardDeploymentID()
    {
        return $this->CardDeploymentID;
    }
    /**
     * Set CardDeploymentID value
     * @param string $cardDeploymentID
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setCardDeploymentID($cardDeploymentID = null)
    {
        // validation for constraint: string
        if (!is_null($cardDeploymentID) && !is_string($cardDeploymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardDeploymentID, true), gettype($cardDeploymentID)), __LINE__);
        }
        $this->CardDeploymentID = $cardDeploymentID;
        return $this;
    }
    /**
     * Get CardStatus value
     * @return string|null
     */
    public function getCardStatus()
    {
        return $this->CardStatus;
    }
    /**
     * Set CardStatus value
     * @param string $cardStatus
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setCardStatus($cardStatus = null)
    {
        // validation for constraint: string
        if (!is_null($cardStatus) && !is_string($cardStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardStatus, true), gettype($cardStatus)), __LINE__);
        }
        $this->CardStatus = $cardStatus;
        return $this;
    }
    /**
     * Get PurchaseType value
     * @return string|null
     */
    public function getPurchaseType()
    {
        return $this->PurchaseType;
    }
    /**
     * Set PurchaseType value
     * @param string $purchaseType
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setPurchaseType($purchaseType = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseType) && !is_string($purchaseType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseType, true), gettype($purchaseType)), __LINE__);
        }
        $this->PurchaseType = $purchaseType;
        return $this;
    }
    /**
     * Get BookingID value
     * @return string|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param string $bookingID
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: string
        if (!is_null($bookingID) && !is_string($bookingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\GetDeploymentResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
}
