<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DCC_Result StructType
 * @subpackage Structs
 */
class DCC_Result extends AbstractStructBase
{
    /**
     * The DCC_Offered
     * Meta information extracted from the WSDL
     * - documentation: DCC Indicator
     * - use: required
     * @var bool
     */
    public $DCC_Offered;
    /**
     * The PassengerDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PassengerDetailType[]
     */
    public $PassengerDetail;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The CardCurrencyCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardCurrencyCode;
    /**
     * The CardCurrencyAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $CardCurrencyAmount;
    /**
     * The CalculatedCardCurrencyAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $CalculatedCardCurrencyAmount;
    /**
     * The ExchangeRate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $ExchangeRate;
    /**
     * The ExchangeRateSourceName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExchangeRateSourceName;
    /**
     * The ExchangeRateSourceDateTime
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ExchangeRateSourceDateTime;
    /**
     * The MarginPercentRate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $MarginPercentRate;
    /**
     * The CommissionPercentRate
     * Meta information extracted from the WSDL
     * - use: optional
     * @var float
     */
    public $CommissionPercentRate;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ReasonCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The DCC_Remarks
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DCC_Remarks;
    /**
     * Constructor method for DCC_Result
     * @uses DCC_Result::setDCC_Offered()
     * @uses DCC_Result::setPassengerDetail()
     * @uses DCC_Result::setSupplierResponseCode()
     * @uses DCC_Result::setSupplierID()
     * @uses DCC_Result::setSupplierTransID()
     * @uses DCC_Result::setCardCurrencyCode()
     * @uses DCC_Result::setCardCurrencyAmount()
     * @uses DCC_Result::setCalculatedCardCurrencyAmount()
     * @uses DCC_Result::setExchangeRate()
     * @uses DCC_Result::setExchangeRateSourceName()
     * @uses DCC_Result::setExchangeRateSourceDateTime()
     * @uses DCC_Result::setMarginPercentRate()
     * @uses DCC_Result::setCommissionPercentRate()
     * @uses DCC_Result::setReasonCode()
     * @uses DCC_Result::setDescription()
     * @uses DCC_Result::setDCC_Remarks()
     * @param bool $dCC_Offered
     * @param \SabrePaymentGateway\StructType\PassengerDetailType[] $passengerDetail
     * @param string $supplierResponseCode
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $cardCurrencyCode
     * @param float $cardCurrencyAmount
     * @param float $calculatedCardCurrencyAmount
     * @param float $exchangeRate
     * @param string $exchangeRateSourceName
     * @param string $exchangeRateSourceDateTime
     * @param float $marginPercentRate
     * @param float $commissionPercentRate
     * @param string $reasonCode
     * @param string $description
     * @param string $dCC_Remarks
     */
    public function __construct($dCC_Offered = null, array $passengerDetail = array(), $supplierResponseCode = null, $supplierID = null, $supplierTransID = null, $cardCurrencyCode = null, $cardCurrencyAmount = null, $calculatedCardCurrencyAmount = null, $exchangeRate = null, $exchangeRateSourceName = null, $exchangeRateSourceDateTime = null, $marginPercentRate = null, $commissionPercentRate = null, $reasonCode = null, $description = null, $dCC_Remarks = null)
    {
        $this
            ->setDCC_Offered($dCC_Offered)
            ->setPassengerDetail($passengerDetail)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setCardCurrencyCode($cardCurrencyCode)
            ->setCardCurrencyAmount($cardCurrencyAmount)
            ->setCalculatedCardCurrencyAmount($calculatedCardCurrencyAmount)
            ->setExchangeRate($exchangeRate)
            ->setExchangeRateSourceName($exchangeRateSourceName)
            ->setExchangeRateSourceDateTime($exchangeRateSourceDateTime)
            ->setMarginPercentRate($marginPercentRate)
            ->setCommissionPercentRate($commissionPercentRate)
            ->setReasonCode($reasonCode)
            ->setDescription($description)
            ->setDCC_Remarks($dCC_Remarks);
    }
    /**
     * Get DCC_Offered value
     * @return bool
     */
    public function getDCC_Offered()
    {
        return $this->DCC_Offered;
    }
    /**
     * Set DCC_Offered value
     * @param bool $dCC_Offered
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setDCC_Offered($dCC_Offered = null)
    {
        // validation for constraint: boolean
        if (!is_null($dCC_Offered) && !is_bool($dCC_Offered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($dCC_Offered, true), gettype($dCC_Offered)), __LINE__);
        }
        $this->DCC_Offered = $dCC_Offered;
        return $this;
    }
    /**
     * Get PassengerDetail value
     * @return \SabrePaymentGateway\StructType\PassengerDetailType[]|null
     */
    public function getPassengerDetail()
    {
        return $this->PassengerDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setPassengerDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPassengerDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePassengerDetailForArrayConstraintsFromSetPassengerDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dCC_ResultPassengerDetailItem) {
            // validation for constraint: itemType
            if (!$dCC_ResultPassengerDetailItem instanceof \SabrePaymentGateway\StructType\PassengerDetailType) {
                $invalidValues[] = is_object($dCC_ResultPassengerDetailItem) ? get_class($dCC_ResultPassengerDetailItem) : sprintf('%s(%s)', gettype($dCC_ResultPassengerDetailItem), var_export($dCC_ResultPassengerDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PassengerDetail property can only contain items of type \SabrePaymentGateway\StructType\PassengerDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PassengerDetailType[] $passengerDetail
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setPassengerDetail(array $passengerDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($passengerDetailArrayErrorMessage = self::validatePassengerDetailForArrayConstraintsFromSetPassengerDetail($passengerDetail))) {
            throw new \InvalidArgumentException($passengerDetailArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($passengerDetail) && count($passengerDetail) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($passengerDetail)), __LINE__);
        }
        $this->PassengerDetail = $passengerDetail;
        return $this;
    }
    /**
     * Add item to PassengerDetail value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PassengerDetailType $item
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function addToPassengerDetail(\SabrePaymentGateway\StructType\PassengerDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\PassengerDetailType) {
            throw new \InvalidArgumentException(sprintf('The PassengerDetail property can only contain items of type \SabrePaymentGateway\StructType\PassengerDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->PassengerDetail) && count($this->PassengerDetail) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->PassengerDetail)), __LINE__);
        }
        $this->PassengerDetail[] = $item;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get CardCurrencyCode value
     * @return string|null
     */
    public function getCardCurrencyCode()
    {
        return $this->CardCurrencyCode;
    }
    /**
     * Set CardCurrencyCode value
     * @param string $cardCurrencyCode
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setCardCurrencyCode($cardCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardCurrencyCode) && !is_string($cardCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardCurrencyCode, true), gettype($cardCurrencyCode)), __LINE__);
        }
        $this->CardCurrencyCode = $cardCurrencyCode;
        return $this;
    }
    /**
     * Get CardCurrencyAmount value
     * @return float|null
     */
    public function getCardCurrencyAmount()
    {
        return $this->CardCurrencyAmount;
    }
    /**
     * Set CardCurrencyAmount value
     * @param float $cardCurrencyAmount
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setCardCurrencyAmount($cardCurrencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($cardCurrencyAmount) && !(is_float($cardCurrencyAmount) || is_numeric($cardCurrencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cardCurrencyAmount, true), gettype($cardCurrencyAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($cardCurrencyAmount) && mb_strlen(mb_substr($cardCurrencyAmount, false !== mb_strpos($cardCurrencyAmount, '.') ? mb_strpos($cardCurrencyAmount, '.') + 1 : mb_strlen($cardCurrencyAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($cardCurrencyAmount, true), mb_strlen(mb_substr($cardCurrencyAmount, mb_strpos($cardCurrencyAmount, '.') + 1))), __LINE__);
        }
        $this->CardCurrencyAmount = $cardCurrencyAmount;
        return $this;
    }
    /**
     * Get CalculatedCardCurrencyAmount value
     * @return float|null
     */
    public function getCalculatedCardCurrencyAmount()
    {
        return $this->CalculatedCardCurrencyAmount;
    }
    /**
     * Set CalculatedCardCurrencyAmount value
     * @param float $calculatedCardCurrencyAmount
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setCalculatedCardCurrencyAmount($calculatedCardCurrencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($calculatedCardCurrencyAmount) && !(is_float($calculatedCardCurrencyAmount) || is_numeric($calculatedCardCurrencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calculatedCardCurrencyAmount, true), gettype($calculatedCardCurrencyAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($calculatedCardCurrencyAmount) && mb_strlen(mb_substr($calculatedCardCurrencyAmount, false !== mb_strpos($calculatedCardCurrencyAmount, '.') ? mb_strpos($calculatedCardCurrencyAmount, '.') + 1 : mb_strlen($calculatedCardCurrencyAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($calculatedCardCurrencyAmount, true), mb_strlen(mb_substr($calculatedCardCurrencyAmount, mb_strpos($calculatedCardCurrencyAmount, '.') + 1))), __LINE__);
        }
        $this->CalculatedCardCurrencyAmount = $calculatedCardCurrencyAmount;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float|null
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setExchangeRate($exchangeRate = null)
    {
        // validation for constraint: float
        if (!is_null($exchangeRate) && !(is_float($exchangeRate) || is_numeric($exchangeRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($exchangeRate, true), gettype($exchangeRate)), __LINE__);
        }
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get ExchangeRateSourceName value
     * @return string|null
     */
    public function getExchangeRateSourceName()
    {
        return $this->ExchangeRateSourceName;
    }
    /**
     * Set ExchangeRateSourceName value
     * @param string $exchangeRateSourceName
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setExchangeRateSourceName($exchangeRateSourceName = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateSourceName) && !is_string($exchangeRateSourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateSourceName, true), gettype($exchangeRateSourceName)), __LINE__);
        }
        $this->ExchangeRateSourceName = $exchangeRateSourceName;
        return $this;
    }
    /**
     * Get ExchangeRateSourceDateTime value
     * @return string|null
     */
    public function getExchangeRateSourceDateTime()
    {
        return $this->ExchangeRateSourceDateTime;
    }
    /**
     * Set ExchangeRateSourceDateTime value
     * @param string $exchangeRateSourceDateTime
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setExchangeRateSourceDateTime($exchangeRateSourceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($exchangeRateSourceDateTime) && !is_string($exchangeRateSourceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exchangeRateSourceDateTime, true), gettype($exchangeRateSourceDateTime)), __LINE__);
        }
        $this->ExchangeRateSourceDateTime = $exchangeRateSourceDateTime;
        return $this;
    }
    /**
     * Get MarginPercentRate value
     * @return float|null
     */
    public function getMarginPercentRate()
    {
        return $this->MarginPercentRate;
    }
    /**
     * Set MarginPercentRate value
     * @param float $marginPercentRate
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setMarginPercentRate($marginPercentRate = null)
    {
        // validation for constraint: float
        if (!is_null($marginPercentRate) && !(is_float($marginPercentRate) || is_numeric($marginPercentRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($marginPercentRate, true), gettype($marginPercentRate)), __LINE__);
        }
        $this->MarginPercentRate = $marginPercentRate;
        return $this;
    }
    /**
     * Get CommissionPercentRate value
     * @return float|null
     */
    public function getCommissionPercentRate()
    {
        return $this->CommissionPercentRate;
    }
    /**
     * Set CommissionPercentRate value
     * @param float $commissionPercentRate
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setCommissionPercentRate($commissionPercentRate = null)
    {
        // validation for constraint: float
        if (!is_null($commissionPercentRate) && !(is_float($commissionPercentRate) || is_numeric($commissionPercentRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionPercentRate, true), gettype($commissionPercentRate)), __LINE__);
        }
        $this->CommissionPercentRate = $commissionPercentRate;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return string|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param string $reasonCode
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reasonCode, true), gettype($reasonCode)), __LINE__);
        }
        $this->ReasonCode = $reasonCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DCC_Remarks value
     * @return string|null
     */
    public function getDCC_Remarks()
    {
        return $this->DCC_Remarks;
    }
    /**
     * Set DCC_Remarks value
     * @param string $dCC_Remarks
     * @return \SabrePaymentGateway\StructType\DCC_Result
     */
    public function setDCC_Remarks($dCC_Remarks = null)
    {
        // validation for constraint: string
        if (!is_null($dCC_Remarks) && !is_string($dCC_Remarks)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dCC_Remarks, true), gettype($dCC_Remarks)), __LINE__);
        }
        $this->DCC_Remarks = $dCC_Remarks;
        return $this;
    }
}
