<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardReader StructType
 * @subpackage Structs
 */
class CardReader extends TokensType
{
    /**
     * The DeviceType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DeviceType;
    /**
     * The DeviceID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $DeviceID;
    /**
     * The ChipCardInd
     * @var bool
     */
    public $ChipCardInd;
    /**
     * Constructor method for CardReader
     * @uses CardReader::setDeviceType()
     * @uses CardReader::setDeviceID()
     * @uses CardReader::setChipCardInd()
     * @param string $deviceType
     * @param string $deviceID
     * @param bool $chipCardInd
     */
    public function __construct($deviceType = null, $deviceID = null, $chipCardInd = null)
    {
        $this
            ->setDeviceType($deviceType)
            ->setDeviceID($deviceID)
            ->setChipCardInd($chipCardInd);
    }
    /**
     * Get DeviceType value
     * @return string|null
     */
    public function getDeviceType()
    {
        return $this->DeviceType;
    }
    /**
     * Set DeviceType value
     * @param string $deviceType
     * @return \SabrePaymentGateway\StructType\CardReader
     */
    public function setDeviceType($deviceType = null)
    {
        // validation for constraint: string
        if (!is_null($deviceType) && !is_string($deviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceType, true), gettype($deviceType)), __LINE__);
        }
        $this->DeviceType = $deviceType;
        return $this;
    }
    /**
     * Get DeviceID value
     * @return string|null
     */
    public function getDeviceID()
    {
        return $this->DeviceID;
    }
    /**
     * Set DeviceID value
     * @param string $deviceID
     * @return \SabrePaymentGateway\StructType\CardReader
     */
    public function setDeviceID($deviceID = null)
    {
        // validation for constraint: string
        if (!is_null($deviceID) && !is_string($deviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceID, true), gettype($deviceID)), __LINE__);
        }
        $this->DeviceID = $deviceID;
        return $this;
    }
    /**
     * Get ChipCardInd value
     * @return bool|null
     */
    public function getChipCardInd()
    {
        return $this->ChipCardInd;
    }
    /**
     * Set ChipCardInd value
     * @param bool $chipCardInd
     * @return \SabrePaymentGateway\StructType\CardReader
     */
    public function setChipCardInd($chipCardInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($chipCardInd) && !is_bool($chipCardInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chipCardInd, true), gettype($chipCardInd)), __LINE__);
        }
        $this->ChipCardInd = $chipCardInd;
        return $this;
    }
}
