<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountValidationResult StructType
 * @subpackage Structs
 */
class AccountValidationResult extends AbstractStructBase
{
    /**
     * The CSC_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\CSC_ResultType
     */
    public $CSC_Result;
    /**
     * The AVS_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\AVS_ResultType
     */
    public $AVS_Result;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RemarksType
     */
    public $Remarks;
    /**
     * The T3DS_Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\T3DS_ResultType
     */
    public $T3DS_Result;
    /**
     * The ReturnURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReturnURL;
    /**
     * The RedirectHTML
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RedirectHTML;
    /**
     * The ResultCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ResultCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The ApprovalCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ApprovalCode;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * The SupplierTransID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierTransID;
    /**
     * The SupplierResponseCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierResponseCode;
    /**
     * The SupplierReferenceID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierReferenceID;
    /**
     * The NetworkTransactionReference
     * Meta information extracted from the WSDL
     * - documentation: Transaction ID that supports merchant-initiated transaction (MIT) exemptions
     * - use: optional
     * @var string
     */
    public $NetworkTransactionReference;
    /**
     * The PaymentRef
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $PaymentRef;
    /**
     * The ErrorCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ErrorCode;
    /**
     * The SupplierFOP_Code
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierFOP_Code;
    /**
     * The MerchantAccountNumber
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MerchantAccountNumber;
    /**
     * Constructor method for AccountValidationResult
     * @uses AccountValidationResult::setCSC_Result()
     * @uses AccountValidationResult::setAVS_Result()
     * @uses AccountValidationResult::setRemarks()
     * @uses AccountValidationResult::setT3DS_Result()
     * @uses AccountValidationResult::setReturnURL()
     * @uses AccountValidationResult::setRedirectHTML()
     * @uses AccountValidationResult::setResultCode()
     * @uses AccountValidationResult::setDescription()
     * @uses AccountValidationResult::setApprovalCode()
     * @uses AccountValidationResult::setSupplierID()
     * @uses AccountValidationResult::setSupplierTransID()
     * @uses AccountValidationResult::setSupplierResponseCode()
     * @uses AccountValidationResult::setSupplierReferenceID()
     * @uses AccountValidationResult::setNetworkTransactionReference()
     * @uses AccountValidationResult::setPaymentRef()
     * @uses AccountValidationResult::setErrorCode()
     * @uses AccountValidationResult::setSupplierFOP_Code()
     * @uses AccountValidationResult::setMerchantAccountNumber()
     * @param \SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result
     * @param \SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result
     * @param \SabrePaymentGateway\StructType\RemarksType $remarks
     * @param \SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result
     * @param string $returnURL
     * @param string $redirectHTML
     * @param string $resultCode
     * @param string $description
     * @param string $approvalCode
     * @param string $supplierID
     * @param string $supplierTransID
     * @param string $supplierResponseCode
     * @param string $supplierReferenceID
     * @param string $networkTransactionReference
     * @param string $paymentRef
     * @param string $errorCode
     * @param string $supplierFOP_Code
     * @param string $merchantAccountNumber
     */
    public function __construct(\SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result = null, \SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result = null, \SabrePaymentGateway\StructType\RemarksType $remarks = null, \SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result = null, $returnURL = null, $redirectHTML = null, $resultCode = null, $description = null, $approvalCode = null, $supplierID = null, $supplierTransID = null, $supplierResponseCode = null, $supplierReferenceID = null, $networkTransactionReference = null, $paymentRef = null, $errorCode = null, $supplierFOP_Code = null, $merchantAccountNumber = null)
    {
        $this
            ->setCSC_Result($cSC_Result)
            ->setAVS_Result($aVS_Result)
            ->setRemarks($remarks)
            ->setT3DS_Result($t3DS_Result)
            ->setReturnURL($returnURL)
            ->setRedirectHTML($redirectHTML)
            ->setResultCode($resultCode)
            ->setDescription($description)
            ->setApprovalCode($approvalCode)
            ->setSupplierID($supplierID)
            ->setSupplierTransID($supplierTransID)
            ->setSupplierResponseCode($supplierResponseCode)
            ->setSupplierReferenceID($supplierReferenceID)
            ->setNetworkTransactionReference($networkTransactionReference)
            ->setPaymentRef($paymentRef)
            ->setErrorCode($errorCode)
            ->setSupplierFOP_Code($supplierFOP_Code)
            ->setMerchantAccountNumber($merchantAccountNumber);
    }
    /**
     * Get CSC_Result value
     * @return \SabrePaymentGateway\StructType\CSC_ResultType|null
     */
    public function getCSC_Result()
    {
        return $this->CSC_Result;
    }
    /**
     * Set CSC_Result value
     * @param \SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setCSC_Result(\SabrePaymentGateway\StructType\CSC_ResultType $cSC_Result = null)
    {
        $this->CSC_Result = $cSC_Result;
        return $this;
    }
    /**
     * Get AVS_Result value
     * @return \SabrePaymentGateway\StructType\AVS_ResultType|null
     */
    public function getAVS_Result()
    {
        return $this->AVS_Result;
    }
    /**
     * Set AVS_Result value
     * @param \SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setAVS_Result(\SabrePaymentGateway\StructType\AVS_ResultType $aVS_Result = null)
    {
        $this->AVS_Result = $aVS_Result;
        return $this;
    }
    /**
     * Get Remarks value
     * @return \SabrePaymentGateway\StructType\RemarksType|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param \SabrePaymentGateway\StructType\RemarksType $remarks
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setRemarks(\SabrePaymentGateway\StructType\RemarksType $remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get T3DS_Result value
     * @return \SabrePaymentGateway\StructType\T3DS_ResultType|null
     */
    public function getT3DS_Result()
    {
        return $this->T3DS_Result;
    }
    /**
     * Set T3DS_Result value
     * @param \SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setT3DS_Result(\SabrePaymentGateway\StructType\T3DS_ResultType $t3DS_Result = null)
    {
        $this->T3DS_Result = $t3DS_Result;
        return $this;
    }
    /**
     * Get ReturnURL value
     * @return string|null
     */
    public function getReturnURL()
    {
        return $this->ReturnURL;
    }
    /**
     * Set ReturnURL value
     * @param string $returnURL
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setReturnURL($returnURL = null)
    {
        // validation for constraint: string
        if (!is_null($returnURL) && !is_string($returnURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($returnURL, true), gettype($returnURL)), __LINE__);
        }
        $this->ReturnURL = $returnURL;
        return $this;
    }
    /**
     * Get RedirectHTML value
     * @return string|null
     */
    public function getRedirectHTML()
    {
        return $this->RedirectHTML;
    }
    /**
     * Set RedirectHTML value
     * @param string $redirectHTML
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setRedirectHTML($redirectHTML = null)
    {
        // validation for constraint: string
        if (!is_null($redirectHTML) && !is_string($redirectHTML)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectHTML, true), gettype($redirectHTML)), __LINE__);
        }
        $this->RedirectHTML = $redirectHTML;
        return $this;
    }
    /**
     * Get ResultCode value
     * @return string|null
     */
    public function getResultCode()
    {
        return $this->ResultCode;
    }
    /**
     * Set ResultCode value
     * @param string $resultCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setResultCode($resultCode = null)
    {
        // validation for constraint: string
        if (!is_null($resultCode) && !is_string($resultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultCode, true), gettype($resultCode)), __LINE__);
        }
        $this->ResultCode = $resultCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setApprovalCode($approvalCode = null)
    {
        // validation for constraint: string
        if (!is_null($approvalCode) && !is_string($approvalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($approvalCode, true), gettype($approvalCode)), __LINE__);
        }
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransID) && !is_string($supplierTransID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransID, true), gettype($supplierTransID)), __LINE__);
        }
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get SupplierResponseCode value
     * @return string|null
     */
    public function getSupplierResponseCode()
    {
        return $this->SupplierResponseCode;
    }
    /**
     * Set SupplierResponseCode value
     * @param string $supplierResponseCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setSupplierResponseCode($supplierResponseCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierResponseCode) && !is_string($supplierResponseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierResponseCode, true), gettype($supplierResponseCode)), __LINE__);
        }
        $this->SupplierResponseCode = $supplierResponseCode;
        return $this;
    }
    /**
     * Get SupplierReferenceID value
     * @return string|null
     */
    public function getSupplierReferenceID()
    {
        return $this->SupplierReferenceID;
    }
    /**
     * Set SupplierReferenceID value
     * @param string $supplierReferenceID
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setSupplierReferenceID($supplierReferenceID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierReferenceID) && !is_string($supplierReferenceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierReferenceID, true), gettype($supplierReferenceID)), __LINE__);
        }
        $this->SupplierReferenceID = $supplierReferenceID;
        return $this;
    }
    /**
     * Get NetworkTransactionReference value
     * @return string|null
     */
    public function getNetworkTransactionReference()
    {
        return $this->NetworkTransactionReference;
    }
    /**
     * Set NetworkTransactionReference value
     * @param string $networkTransactionReference
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setNetworkTransactionReference($networkTransactionReference = null)
    {
        // validation for constraint: string
        if (!is_null($networkTransactionReference) && !is_string($networkTransactionReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($networkTransactionReference, true), gettype($networkTransactionReference)), __LINE__);
        }
        $this->NetworkTransactionReference = $networkTransactionReference;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setPaymentRef($paymentRef = null)
    {
        // validation for constraint: string
        if (!is_null($paymentRef) && !is_string($paymentRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentRef, true), gettype($paymentRef)), __LINE__);
        }
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get ErrorCode value
     * @return string|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param string $errorCode
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: string
        if (!is_null($errorCode) && !is_string($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorCode, true), gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get SupplierFOP_Code value
     * @return string|null
     */
    public function getSupplierFOP_Code()
    {
        return $this->SupplierFOP_Code;
    }
    /**
     * Set SupplierFOP_Code value
     * @param string $supplierFOP_Code
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setSupplierFOP_Code($supplierFOP_Code = null)
    {
        // validation for constraint: string
        if (!is_null($supplierFOP_Code) && !is_string($supplierFOP_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierFOP_Code, true), gettype($supplierFOP_Code)), __LINE__);
        }
        $this->SupplierFOP_Code = $supplierFOP_Code;
        return $this;
    }
    /**
     * Get MerchantAccountNumber value
     * @return string|null
     */
    public function getMerchantAccountNumber()
    {
        return $this->MerchantAccountNumber;
    }
    /**
     * Set MerchantAccountNumber value
     * @param string $merchantAccountNumber
     * @return \SabrePaymentGateway\StructType\AccountValidationResult
     */
    public function setMerchantAccountNumber($merchantAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($merchantAccountNumber) && !is_string($merchantAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchantAccountNumber, true), gettype($merchantAccountNumber)), __LINE__);
        }
        $this->MerchantAccountNumber = $merchantAccountNumber;
        return $this;
    }
}
