<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Tax Code and Amount
 * @subpackage Structs
 */
class TaxType extends AbstractStructBase
{
    /**
     * The TaxType
     * Meta information extracted from the WSDL
     * - documentation: e.g. PD, XT, TE
     * - use: optional
     * @var string
     */
    public $TaxType;
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $TaxAmount;
    /**
     * Constructor method for TaxType
     * @uses TaxType::setTaxType()
     * @uses TaxType::setTaxCode()
     * @uses TaxType::setTaxAmount()
     * @param string $taxType
     * @param string $taxCode
     * @param float $taxAmount
     */
    public function __construct($taxType = null, $taxCode = null, $taxAmount = null)
    {
        $this
            ->setTaxType($taxType)
            ->setTaxCode($taxCode)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get TaxType value
     * @return string|null
     */
    public function getTaxType()
    {
        return $this->TaxType;
    }
    /**
     * Set TaxType value
     * @param string $taxType
     * @return \SabrePaymentGateway\StructType\TaxType
     */
    public function setTaxType($taxType = null)
    {
        // validation for constraint: string
        if (!is_null($taxType) && !is_string($taxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxType, true), gettype($taxType)), __LINE__);
        }
        $this->TaxType = $taxType;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \SabrePaymentGateway\StructType\TaxType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \SabrePaymentGateway\StructType\TaxType
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($taxAmount) && mb_strlen(mb_substr($taxAmount, false !== mb_strpos($taxAmount, '.') ? mb_strpos($taxAmount, '.') + 1 : mb_strlen($taxAmount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($taxAmount, true), mb_strlen(mb_substr($taxAmount, mb_strpos($taxAmount, '.') + 1))), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
}
