<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RailJourneyType StructType
 * @subpackage Structs
 */
class RailJourneyType extends AbstractStructBase
{
    /**
     * The SupplierCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SupplierCode;
    /**
     * The JourneyID
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $JourneyID;
    /**
     * The Ticket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\Ticket
     */
    public $Ticket;
    /**
     * The SupplierName
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierName;
    /**
     * The StartDateTime
     * @var string
     */
    public $StartDateTime;
    /**
     * The EndDateTime
     * @var string
     */
    public $EndDateTime;
    /**
     * The StartLocation
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $StartLocation;
    /**
     * The EndLocation
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $EndLocation;
    /**
     * Constructor method for RailJourneyType
     * @uses RailJourneyType::setSupplierCode()
     * @uses RailJourneyType::setJourneyID()
     * @uses RailJourneyType::setTicket()
     * @uses RailJourneyType::setSupplierName()
     * @uses RailJourneyType::setStartDateTime()
     * @uses RailJourneyType::setEndDateTime()
     * @uses RailJourneyType::setStartLocation()
     * @uses RailJourneyType::setEndLocation()
     * @param string $supplierCode
     * @param string $journeyID
     * @param \SabrePaymentGateway\StructType\Ticket $ticket
     * @param string $supplierName
     * @param string $startDateTime
     * @param string $endDateTime
     * @param string $startLocation
     * @param string $endLocation
     */
    public function __construct($supplierCode = null, $journeyID = null, \SabrePaymentGateway\StructType\Ticket $ticket = null, $supplierName = null, $startDateTime = null, $endDateTime = null, $startLocation = null, $endLocation = null)
    {
        $this
            ->setSupplierCode($supplierCode)
            ->setJourneyID($journeyID)
            ->setTicket($ticket)
            ->setSupplierName($supplierName)
            ->setStartDateTime($startDateTime)
            ->setEndDateTime($endDateTime)
            ->setStartLocation($startLocation)
            ->setEndLocation($endLocation);
    }
    /**
     * Get SupplierCode value
     * @return string
     */
    public function getSupplierCode()
    {
        return $this->SupplierCode;
    }
    /**
     * Set SupplierCode value
     * @param string $supplierCode
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setSupplierCode($supplierCode = null)
    {
        // validation for constraint: string
        if (!is_null($supplierCode) && !is_string($supplierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierCode, true), gettype($supplierCode)), __LINE__);
        }
        $this->SupplierCode = $supplierCode;
        return $this;
    }
    /**
     * Get JourneyID value
     * @return string
     */
    public function getJourneyID()
    {
        return $this->JourneyID;
    }
    /**
     * Set JourneyID value
     * @param string $journeyID
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setJourneyID($journeyID = null)
    {
        // validation for constraint: string
        if (!is_null($journeyID) && !is_string($journeyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyID, true), gettype($journeyID)), __LINE__);
        }
        $this->JourneyID = $journeyID;
        return $this;
    }
    /**
     * Get Ticket value
     * @return \SabrePaymentGateway\StructType\Ticket|null
     */
    public function getTicket()
    {
        return $this->Ticket;
    }
    /**
     * Set Ticket value
     * @param \SabrePaymentGateway\StructType\Ticket $ticket
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setTicket(\SabrePaymentGateway\StructType\Ticket $ticket = null)
    {
        $this->Ticket = $ticket;
        return $this;
    }
    /**
     * Get SupplierName value
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->SupplierName;
    }
    /**
     * Set SupplierName value
     * @param string $supplierName
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setSupplierName($supplierName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierName) && !is_string($supplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierName, true), gettype($supplierName)), __LINE__);
        }
        $this->SupplierName = $supplierName;
        return $this;
    }
    /**
     * Get StartDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->StartDateTime;
    }
    /**
     * Set StartDateTime value
     * @param string $startDateTime
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setStartDateTime($startDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startDateTime) && !is_string($startDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateTime, true), gettype($startDateTime)), __LINE__);
        }
        $this->StartDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get EndDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->EndDateTime;
    }
    /**
     * Set EndDateTime value
     * @param string $endDateTime
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setEndDateTime($endDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endDateTime) && !is_string($endDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateTime, true), gettype($endDateTime)), __LINE__);
        }
        $this->EndDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get StartLocation value
     * @return string|null
     */
    public function getStartLocation()
    {
        return $this->StartLocation;
    }
    /**
     * Set StartLocation value
     * @param string $startLocation
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setStartLocation($startLocation = null)
    {
        // validation for constraint: string
        if (!is_null($startLocation) && !is_string($startLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startLocation, true), gettype($startLocation)), __LINE__);
        }
        $this->StartLocation = $startLocation;
        return $this;
    }
    /**
     * Get EndLocation value
     * @return string|null
     */
    public function getEndLocation()
    {
        return $this->EndLocation;
    }
    /**
     * Set EndLocation value
     * @param string $endLocation
     * @return \SabrePaymentGateway\StructType\RailJourneyType
     */
    public function setEndLocation($endLocation = null)
    {
        // validation for constraint: string
        if (!is_null($endLocation) && !is_string($endLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endLocation, true), gettype($endLocation)), __LINE__);
        }
        $this->EndLocation = $endLocation;
        return $this;
    }
}
