<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PhoneType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies type of phone.
 * @subpackage Structs
 */
class PhoneType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - documentation: e.g. 682-605-1818 6826051818
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Type of phone: H - Home or Origin D - Destination M - Mobile C - Cell O - Office W - Work F - Fax I - ID
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for PhoneType
     * @uses PhoneType::setNumber()
     * @uses PhoneType::setType()
     * @param string $number
     * @param string $type
     */
    public function __construct($number = null, $type = null)
    {
        $this
            ->setNumber($number)
            ->setType($type);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \SabrePaymentGateway\StructType\PhoneType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \SabrePaymentGateway\StructType\PhoneType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
