<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelType StructType
 * @subpackage Structs
 */
class HotelType extends AbstractStructBase
{
    /**
     * The AgreementNbr
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $AgreementNbr;
    /**
     * The CheckInDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CheckInDate;
    /**
     * The CheckOutDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CheckOutDate;
    /**
     * The ReferenceNbr
     * Meta information extracted from the WSDL
     * - documentation: External Voucher Number for EY
     * - use: required
     * @var string
     */
    public $ReferenceNbr;
    /**
     * The ProviderInfo
     * @var \SabrePaymentGateway\StructType\ProviderInfoType
     */
    public $ProviderInfo;
    /**
     * The Room
     * Meta information extracted from the WSDL
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\RoomStayType[]
     */
    public $Room;
    /**
     * The Cost
     * @var \SabrePaymentGateway\StructType\CostType
     */
    public $Cost;
    /**
     * The PaymentInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\PaymentInfoType
     */
    public $PaymentInfo;
    /**
     * The ServiceNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceNote;
    /**
     * The CancellationPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CancellationPolicy;
    /**
     * The LodgingType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $LodgingType;
    /**
     * The CheckInCity
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CheckInCity;
    /**
     * Constructor method for HotelType
     * @uses HotelType::setAgreementNbr()
     * @uses HotelType::setCheckInDate()
     * @uses HotelType::setCheckOutDate()
     * @uses HotelType::setReferenceNbr()
     * @uses HotelType::setProviderInfo()
     * @uses HotelType::setRoom()
     * @uses HotelType::setCost()
     * @uses HotelType::setPaymentInfo()
     * @uses HotelType::setServiceNote()
     * @uses HotelType::setCancellationPolicy()
     * @uses HotelType::setLodgingType()
     * @uses HotelType::setCheckInCity()
     * @param string $agreementNbr
     * @param string $checkInDate
     * @param string $checkOutDate
     * @param string $referenceNbr
     * @param \SabrePaymentGateway\StructType\ProviderInfoType $providerInfo
     * @param \SabrePaymentGateway\StructType\RoomStayType[] $room
     * @param \SabrePaymentGateway\StructType\CostType $cost
     * @param \SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo
     * @param string $serviceNote
     * @param string $cancellationPolicy
     * @param string $lodgingType
     * @param string $checkInCity
     */
    public function __construct($agreementNbr = null, $checkInDate = null, $checkOutDate = null, $referenceNbr = null, \SabrePaymentGateway\StructType\ProviderInfoType $providerInfo = null, array $room = array(), \SabrePaymentGateway\StructType\CostType $cost = null, \SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo = null, $serviceNote = null, $cancellationPolicy = null, $lodgingType = null, $checkInCity = null)
    {
        $this
            ->setAgreementNbr($agreementNbr)
            ->setCheckInDate($checkInDate)
            ->setCheckOutDate($checkOutDate)
            ->setReferenceNbr($referenceNbr)
            ->setProviderInfo($providerInfo)
            ->setRoom($room)
            ->setCost($cost)
            ->setPaymentInfo($paymentInfo)
            ->setServiceNote($serviceNote)
            ->setCancellationPolicy($cancellationPolicy)
            ->setLodgingType($lodgingType)
            ->setCheckInCity($checkInCity);
    }
    /**
     * Get AgreementNbr value
     * @return string
     */
    public function getAgreementNbr()
    {
        return $this->AgreementNbr;
    }
    /**
     * Set AgreementNbr value
     * @param string $agreementNbr
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setAgreementNbr($agreementNbr = null)
    {
        // validation for constraint: string
        if (!is_null($agreementNbr) && !is_string($agreementNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agreementNbr, true), gettype($agreementNbr)), __LINE__);
        }
        $this->AgreementNbr = $agreementNbr;
        return $this;
    }
    /**
     * Get CheckInDate value
     * @return string
     */
    public function getCheckInDate()
    {
        return $this->CheckInDate;
    }
    /**
     * Set CheckInDate value
     * @param string $checkInDate
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setCheckInDate($checkInDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkInDate) && !is_string($checkInDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInDate, true), gettype($checkInDate)), __LINE__);
        }
        $this->CheckInDate = $checkInDate;
        return $this;
    }
    /**
     * Get CheckOutDate value
     * @return string
     */
    public function getCheckOutDate()
    {
        return $this->CheckOutDate;
    }
    /**
     * Set CheckOutDate value
     * @param string $checkOutDate
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setCheckOutDate($checkOutDate = null)
    {
        // validation for constraint: string
        if (!is_null($checkOutDate) && !is_string($checkOutDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkOutDate, true), gettype($checkOutDate)), __LINE__);
        }
        $this->CheckOutDate = $checkOutDate;
        return $this;
    }
    /**
     * Get ReferenceNbr value
     * @return string
     */
    public function getReferenceNbr()
    {
        return $this->ReferenceNbr;
    }
    /**
     * Set ReferenceNbr value
     * @param string $referenceNbr
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setReferenceNbr($referenceNbr = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNbr) && !is_string($referenceNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNbr, true), gettype($referenceNbr)), __LINE__);
        }
        $this->ReferenceNbr = $referenceNbr;
        return $this;
    }
    /**
     * Get ProviderInfo value
     * @return \SabrePaymentGateway\StructType\ProviderInfoType|null
     */
    public function getProviderInfo()
    {
        return $this->ProviderInfo;
    }
    /**
     * Set ProviderInfo value
     * @param \SabrePaymentGateway\StructType\ProviderInfoType $providerInfo
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setProviderInfo(\SabrePaymentGateway\StructType\ProviderInfoType $providerInfo = null)
    {
        $this->ProviderInfo = $providerInfo;
        return $this;
    }
    /**
     * Get Room value
     * @return \SabrePaymentGateway\StructType\RoomStayType[]|null
     */
    public function getRoom()
    {
        return $this->Room;
    }
    /**
     * This method is responsible for validating the values passed to the setRoom method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoom method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoomForArrayConstraintsFromSetRoom(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $hotelTypeRoomItem) {
            // validation for constraint: itemType
            if (!$hotelTypeRoomItem instanceof \SabrePaymentGateway\StructType\RoomStayType) {
                $invalidValues[] = is_object($hotelTypeRoomItem) ? get_class($hotelTypeRoomItem) : sprintf('%s(%s)', gettype($hotelTypeRoomItem), var_export($hotelTypeRoomItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Room property can only contain items of type \SabrePaymentGateway\StructType\RoomStayType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Room value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\RoomStayType[] $room
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setRoom(array $room = array())
    {
        // validation for constraint: array
        if ('' !== ($roomArrayErrorMessage = self::validateRoomForArrayConstraintsFromSetRoom($room))) {
            throw new \InvalidArgumentException($roomArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($room) && count($room) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($room)), __LINE__);
        }
        $this->Room = $room;
        return $this;
    }
    /**
     * Add item to Room value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\RoomStayType $item
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function addToRoom(\SabrePaymentGateway\StructType\RoomStayType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\RoomStayType) {
            throw new \InvalidArgumentException(sprintf('The Room property can only contain items of type \SabrePaymentGateway\StructType\RoomStayType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Room) && count($this->Room) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Room)), __LINE__);
        }
        $this->Room[] = $item;
        return $this;
    }
    /**
     * Get Cost value
     * @return \SabrePaymentGateway\StructType\CostType|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param \SabrePaymentGateway\StructType\CostType $cost
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setCost(\SabrePaymentGateway\StructType\CostType $cost = null)
    {
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \SabrePaymentGateway\StructType\PaymentInfoType|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setPaymentInfo(\SabrePaymentGateway\StructType\PaymentInfoType $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get ServiceNote value
     * @return string|null
     */
    public function getServiceNote()
    {
        return $this->ServiceNote;
    }
    /**
     * Set ServiceNote value
     * @param string $serviceNote
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setServiceNote($serviceNote = null)
    {
        // validation for constraint: string
        if (!is_null($serviceNote) && !is_string($serviceNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceNote, true), gettype($serviceNote)), __LINE__);
        }
        $this->ServiceNote = $serviceNote;
        return $this;
    }
    /**
     * Get CancellationPolicy value
     * @return string|null
     */
    public function getCancellationPolicy()
    {
        return $this->CancellationPolicy;
    }
    /**
     * Set CancellationPolicy value
     * @param string $cancellationPolicy
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setCancellationPolicy($cancellationPolicy = null)
    {
        // validation for constraint: string
        if (!is_null($cancellationPolicy) && !is_string($cancellationPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellationPolicy, true), gettype($cancellationPolicy)), __LINE__);
        }
        $this->CancellationPolicy = $cancellationPolicy;
        return $this;
    }
    /**
     * Get LodgingType value
     * @return string|null
     */
    public function getLodgingType()
    {
        return $this->LodgingType;
    }
    /**
     * Set LodgingType value
     * @param string $lodgingType
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setLodgingType($lodgingType = null)
    {
        // validation for constraint: string
        if (!is_null($lodgingType) && !is_string($lodgingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lodgingType, true), gettype($lodgingType)), __LINE__);
        }
        $this->LodgingType = $lodgingType;
        return $this;
    }
    /**
     * Get CheckInCity value
     * @return string|null
     */
    public function getCheckInCity()
    {
        return $this->CheckInCity;
    }
    /**
     * Set CheckInCity value
     * @param string $checkInCity
     * @return \SabrePaymentGateway\StructType\HotelType
     */
    public function setCheckInCity($checkInCity = null)
    {
        // validation for constraint: string
        if (!is_null($checkInCity) && !is_string($checkInCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkInCity, true), gettype($checkInCity)), __LINE__);
        }
        $this->CheckInCity = $checkInCity;
        return $this;
    }
}
