<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCardResultType StructType
 * @subpackage Structs
 */
class GetCardResultType extends AbstractStructBase
{
    /**
     * The ResponseCode
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ResponseCode;
    /**
     * The PaymentCard
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \SabrePaymentGateway\StructType\PaymentCardType[]
     */
    public $PaymentCard;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The CardDeploymentID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CardDeploymentID;
    /**
     * The SupplierID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $SupplierID;
    /**
     * Constructor method for GetCardResultType
     * @uses GetCardResultType::setResponseCode()
     * @uses GetCardResultType::setPaymentCard()
     * @uses GetCardResultType::setDescription()
     * @uses GetCardResultType::setCardDeploymentID()
     * @uses GetCardResultType::setSupplierID()
     * @param string $responseCode
     * @param \SabrePaymentGateway\StructType\PaymentCardType[] $paymentCard
     * @param string $description
     * @param string $cardDeploymentID
     * @param string $supplierID
     */
    public function __construct($responseCode = null, array $paymentCard = array(), $description = null, $cardDeploymentID = null, $supplierID = null)
    {
        $this
            ->setResponseCode($responseCode)
            ->setPaymentCard($paymentCard)
            ->setDescription($description)
            ->setCardDeploymentID($cardDeploymentID)
            ->setSupplierID($supplierID);
    }
    /**
     * Get ResponseCode value
     * @return string
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \SabrePaymentGateway\StructType\GetCardResultType
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get PaymentCard value
     * @return \SabrePaymentGateway\StructType\PaymentCardType[]|null
     */
    public function getPaymentCard()
    {
        return $this->PaymentCard;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentCardForArrayConstraintsFromSetPaymentCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getCardResultTypePaymentCardItem) {
            // validation for constraint: itemType
            if (!$getCardResultTypePaymentCardItem instanceof \SabrePaymentGateway\StructType\PaymentCardType) {
                $invalidValues[] = is_object($getCardResultTypePaymentCardItem) ? get_class($getCardResultTypePaymentCardItem) : sprintf('%s(%s)', gettype($getCardResultTypePaymentCardItem), var_export($getCardResultTypePaymentCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentCard property can only contain items of type \SabrePaymentGateway\StructType\PaymentCardType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentCard value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PaymentCardType[] $paymentCard
     * @return \SabrePaymentGateway\StructType\GetCardResultType
     */
    public function setPaymentCard(array $paymentCard = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentCardArrayErrorMessage = self::validatePaymentCardForArrayConstraintsFromSetPaymentCard($paymentCard))) {
            throw new \InvalidArgumentException($paymentCardArrayErrorMessage, __LINE__);
        }
        $this->PaymentCard = $paymentCard;
        return $this;
    }
    /**
     * Add item to PaymentCard value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PaymentCardType $item
     * @return \SabrePaymentGateway\StructType\GetCardResultType
     */
    public function addToPaymentCard(\SabrePaymentGateway\StructType\PaymentCardType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\PaymentCardType) {
            throw new \InvalidArgumentException(sprintf('The PaymentCard property can only contain items of type \SabrePaymentGateway\StructType\PaymentCardType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentCard[] = $item;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\GetCardResultType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CardDeploymentID value
     * @return string|null
     */
    public function getCardDeploymentID()
    {
        return $this->CardDeploymentID;
    }
    /**
     * Set CardDeploymentID value
     * @param string $cardDeploymentID
     * @return \SabrePaymentGateway\StructType\GetCardResultType
     */
    public function setCardDeploymentID($cardDeploymentID = null)
    {
        // validation for constraint: string
        if (!is_null($cardDeploymentID) && !is_string($cardDeploymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardDeploymentID, true), gettype($cardDeploymentID)), __LINE__);
        }
        $this->CardDeploymentID = $cardDeploymentID;
        return $this;
    }
    /**
     * Get SupplierID value
     * @return string|null
     */
    public function getSupplierID()
    {
        return $this->SupplierID;
    }
    /**
     * Set SupplierID value
     * @param string $supplierID
     * @return \SabrePaymentGateway\StructType\GetCardResultType
     */
    public function setSupplierID($supplierID = null)
    {
        // validation for constraint: string
        if (!is_null($supplierID) && !is_string($supplierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierID, true), gettype($supplierID)), __LINE__);
        }
        $this->SupplierID = $supplierID;
        return $this;
    }
}
