<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransformType StructType
 * Meta information extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class TransformType extends AbstractStructBase
{
    /**
     * The Algorithm
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Algorithm;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The XPath
     * Meta information extracted from the WSDL
     * - choice: XPath |
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * @var string
     */
    public $XPath;
    /**
     * Constructor method for TransformType
     * @uses TransformType::setAlgorithm()
     * @uses TransformType::setAny()
     * @uses TransformType::setXPath()
     * @param string $algorithm
     * @param \DOMDocument $any
     * @param string $xPath
     */
    public function __construct($algorithm = null, \DOMDocument $any = null, $xPath = null)
    {
        $this
            ->setAlgorithm($algorithm)
            ->setAny($any)
            ->setXPath($xPath);
    }
    /**
     * Get Algorithm value
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }
    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return \SabrePaymentGateway\StructType\TransformType
     */
    public function setAlgorithm($algorithm = null)
    {
        // validation for constraint: string
        if (!is_null($algorithm) && !is_string($algorithm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($algorithm, true), gettype($algorithm)), __LINE__);
        }
        $this->Algorithm = $algorithm;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\TransformType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get XPath value
     * @return string|null
     */
    public function getXPath()
    {
        return isset($this->XPath) ? $this->XPath : null;
    }
    /**
     * This method is responsible for validating the value passed to the setXPath method
     * This method is willingly generated in order to preserve the one-line inline validation within the setXPath method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateXPathForChoiceConstraintsFromSetXPath($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property XPath can\'t be set as the property %s is already set. Only one property must be set among these properties: XPath, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set XPath value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $xPath
     * @return \SabrePaymentGateway\StructType\TransformType
     */
    public function setXPath($xPath = null)
    {
        // validation for constraint: string
        if (!is_null($xPath) && !is_string($xPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xPath, true), gettype($xPath)), __LINE__);
        }
        // validation for constraint: choice(XPath, )
        if ('' !== ($xPathChoiceErrorMessage = self::validateXPathForChoiceConstraintsFromSetXPath($xPath))) {
            throw new \InvalidArgumentException($xPathChoiceErrorMessage, __LINE__);
        }
        if (is_null($xPath) || (is_array($xPath) && empty($xPath))) {
            unset($this->XPath);
        } else {
            $this->XPath = $xPath;
        }
        return $this;
    }
}
