<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for To StructType
 * @subpackage Structs
 */
class To extends AbstractStructBase
{
    /**
     * The PartyId
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: tns:PartyId
     * @var \SabrePaymentGateway\StructType\PartyId[]
     */
    public $PartyId;
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $Role;
    /**
     * Constructor method for To
     * @uses To::setPartyId()
     * @uses To::setRole()
     * @param \SabrePaymentGateway\StructType\PartyId[] $partyId
     * @param string $role
     */
    public function __construct(array $partyId = array(), $role = null)
    {
        $this
            ->setPartyId($partyId)
            ->setRole($role);
    }
    /**
     * Get PartyId value
     * @return \SabrePaymentGateway\StructType\PartyId[]|null
     */
    public function getPartyId()
    {
        return $this->PartyId;
    }
    /**
     * This method is responsible for validating the values passed to the setPartyId method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPartyId method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePartyIdForArrayConstraintsFromSetPartyId(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $toPartyIdItem) {
            // validation for constraint: itemType
            if (!$toPartyIdItem instanceof \SabrePaymentGateway\StructType\PartyId) {
                $invalidValues[] = is_object($toPartyIdItem) ? get_class($toPartyIdItem) : sprintf('%s(%s)', gettype($toPartyIdItem), var_export($toPartyIdItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PartyId property can only contain items of type \SabrePaymentGateway\StructType\PartyId, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PartyId value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PartyId[] $partyId
     * @return \SabrePaymentGateway\StructType\To
     */
    public function setPartyId(array $partyId = array())
    {
        // validation for constraint: array
        if ('' !== ($partyIdArrayErrorMessage = self::validatePartyIdForArrayConstraintsFromSetPartyId($partyId))) {
            throw new \InvalidArgumentException($partyIdArrayErrorMessage, __LINE__);
        }
        $this->PartyId = $partyId;
        return $this;
    }
    /**
     * Add item to PartyId value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\PartyId $item
     * @return \SabrePaymentGateway\StructType\To
     */
    public function addToPartyId(\SabrePaymentGateway\StructType\PartyId $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\PartyId) {
            throw new \InvalidArgumentException(sprintf('The PartyId property can only contain items of type \SabrePaymentGateway\StructType\PartyId, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PartyId[] = $item;
        return $this;
    }
    /**
     * Get Role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->Role;
    }
    /**
     * Set Role value
     * @param string $role
     * @return \SabrePaymentGateway\StructType\To
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($role) && mb_strlen($role) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($role)), __LINE__);
        }
        $this->Role = $role;
        return $this;
    }
}
