<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StatusResponse StructType
 * @subpackage Structs
 */
class StatusResponse extends AbstractStructBase
{
    /**
     * The messageStatus
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $messageStatus;
    /**
     * The RefToMessageId
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * - ref: tns:RefToMessageId
     * @var string
     */
    public $RefToMessageId;
    /**
     * The Timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:Timestamp
     * @var string
     */
    public $Timestamp;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: string
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * Constructor method for StatusResponse
     * @uses StatusResponse::setMessageStatus()
     * @uses StatusResponse::setRefToMessageId()
     * @uses StatusResponse::setTimestamp()
     * @uses StatusResponse::setAny()
     * @uses StatusResponse::setId()
     * @uses StatusResponse::setVersion()
     * @param string $messageStatus
     * @param string $refToMessageId
     * @param string $timestamp
     * @param \DOMDocument $any
     * @param string $id
     * @param string $version
     */
    public function __construct($messageStatus = null, $refToMessageId = null, $timestamp = null, \DOMDocument $any = null, $id = null, $version = null)
    {
        $this
            ->setMessageStatus($messageStatus)
            ->setRefToMessageId($refToMessageId)
            ->setTimestamp($timestamp)
            ->setAny($any)
            ->setId($id)
            ->setVersion($version);
    }
    /**
     * Get messageStatus value
     * @return string
     */
    public function getMessageStatus()
    {
        return $this->messageStatus;
    }
    /**
     * Set messageStatus value
     * @uses \SabrePaymentGateway\EnumType\MessageStatus_type::valueIsValid()
     * @uses \SabrePaymentGateway\EnumType\MessageStatus_type::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $messageStatus
     * @return \SabrePaymentGateway\StructType\StatusResponse
     */
    public function setMessageStatus($messageStatus = null)
    {
        // validation for constraint: enumeration
        if (!\SabrePaymentGateway\EnumType\MessageStatus_type::valueIsValid($messageStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \SabrePaymentGateway\EnumType\MessageStatus_type', is_array($messageStatus) ? implode(', ', $messageStatus) : var_export($messageStatus, true), implode(', ', \SabrePaymentGateway\EnumType\MessageStatus_type::getValidValues())), __LINE__);
        }
        $this->messageStatus = $messageStatus;
        return $this;
    }
    /**
     * Get RefToMessageId value
     * @return string|null
     */
    public function getRefToMessageId()
    {
        return $this->RefToMessageId;
    }
    /**
     * Set RefToMessageId value
     * @param string $refToMessageId
     * @return \SabrePaymentGateway\StructType\StatusResponse
     */
    public function setRefToMessageId($refToMessageId = null)
    {
        // validation for constraint: string
        if (!is_null($refToMessageId) && !is_string($refToMessageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refToMessageId, true), gettype($refToMessageId)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($refToMessageId) && mb_strlen($refToMessageId) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($refToMessageId)), __LINE__);
        }
        $this->RefToMessageId = $refToMessageId;
        return $this;
    }
    /**
     * Get Timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->Timestamp;
    }
    /**
     * Set Timestamp value
     * @param string $timestamp
     * @return \SabrePaymentGateway\StructType\StatusResponse
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->Timestamp = $timestamp;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        $domDocument = null;
        if (!empty($this->any) && !$asString) {
            $domDocument = new \DOMDocument('1.0', 'UTF-8');
            $domDocument->loadXML($this->any);
        }
        return $asString ? $this->any : $domDocument;
    }
    /**
     * Set any value
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @param \DOMDocument $any
     * @return \SabrePaymentGateway\StructType\StatusResponse
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = ($any instanceof \DOMDocument) && $any->hasChildNodes() ? $any->saveXML($any->childNodes->item(0)) : $any;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \SabrePaymentGateway\StructType\StatusResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \SabrePaymentGateway\StructType\StatusResponse
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($version) && mb_strlen($version) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
