<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomStayType StructType
 * @subpackage Structs
 */
class RoomStayType extends AbstractStructBase
{
    /**
     * The Guest
     * Meta information extracted from the WSDL
     * - maxOccurs: 10
     * - minOccurs: 0
     * @var \SabrePaymentGateway\StructType\GuestType[]
     */
    public $Guest;
    /**
     * The RoomType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RoomType;
    /**
     * The RoomRate
     * Meta information extracted from the WSDL
     * - documentation: In transaction currency | Used for amounts, max 3 decimals
     * - base: xs:decimal
     * - fractionDigits: 3
     * - use: optional
     * @var float
     */
    public $RoomRate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The LengthOfStay
     * Meta information extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $LengthOfStay;
    /**
     * The GuestsCount
     * Meta information extracted from the WSDL
     * - documentation: Number of guests in this room
     * - use: optional
     * @var int
     */
    public $GuestsCount;
    /**
     * Constructor method for RoomStayType
     * @uses RoomStayType::setGuest()
     * @uses RoomStayType::setRoomType()
     * @uses RoomStayType::setRoomRate()
     * @uses RoomStayType::setDescription()
     * @uses RoomStayType::setLengthOfStay()
     * @uses RoomStayType::setGuestsCount()
     * @param \SabrePaymentGateway\StructType\GuestType[] $guest
     * @param string $roomType
     * @param float $roomRate
     * @param string $description
     * @param int $lengthOfStay
     * @param int $guestsCount
     */
    public function __construct(array $guest = array(), $roomType = null, $roomRate = null, $description = null, $lengthOfStay = null, $guestsCount = null)
    {
        $this
            ->setGuest($guest)
            ->setRoomType($roomType)
            ->setRoomRate($roomRate)
            ->setDescription($description)
            ->setLengthOfStay($lengthOfStay)
            ->setGuestsCount($guestsCount);
    }
    /**
     * Get Guest value
     * @return \SabrePaymentGateway\StructType\GuestType[]|null
     */
    public function getGuest()
    {
        return $this->Guest;
    }
    /**
     * This method is responsible for validating the values passed to the setGuest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestForArrayConstraintsFromSetGuest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $roomStayTypeGuestItem) {
            // validation for constraint: itemType
            if (!$roomStayTypeGuestItem instanceof \SabrePaymentGateway\StructType\GuestType) {
                $invalidValues[] = is_object($roomStayTypeGuestItem) ? get_class($roomStayTypeGuestItem) : sprintf('%s(%s)', gettype($roomStayTypeGuestItem), var_export($roomStayTypeGuestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Guest property can only contain items of type \SabrePaymentGateway\StructType\GuestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Guest value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\GuestType[] $guest
     * @return \SabrePaymentGateway\StructType\RoomStayType
     */
    public function setGuest(array $guest = array())
    {
        // validation for constraint: array
        if ('' !== ($guestArrayErrorMessage = self::validateGuestForArrayConstraintsFromSetGuest($guest))) {
            throw new \InvalidArgumentException($guestArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($guest) && count($guest) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 10', count($guest)), __LINE__);
        }
        $this->Guest = $guest;
        return $this;
    }
    /**
     * Add item to Guest value
     * @throws \InvalidArgumentException
     * @param \SabrePaymentGateway\StructType\GuestType $item
     * @return \SabrePaymentGateway\StructType\RoomStayType
     */
    public function addToGuest(\SabrePaymentGateway\StructType\GuestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SabrePaymentGateway\StructType\GuestType) {
            throw new \InvalidArgumentException(sprintf('The Guest property can only contain items of type \SabrePaymentGateway\StructType\GuestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(10)
        if (is_array($this->Guest) && count($this->Guest) >= 10) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 10', count($this->Guest)), __LINE__);
        }
        $this->Guest[] = $item;
        return $this;
    }
    /**
     * Get RoomType value
     * @return string|null
     */
    public function getRoomType()
    {
        return $this->RoomType;
    }
    /**
     * Set RoomType value
     * @param string $roomType
     * @return \SabrePaymentGateway\StructType\RoomStayType
     */
    public function setRoomType($roomType = null)
    {
        // validation for constraint: string
        if (!is_null($roomType) && !is_string($roomType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roomType, true), gettype($roomType)), __LINE__);
        }
        $this->RoomType = $roomType;
        return $this;
    }
    /**
     * Get RoomRate value
     * @return float|null
     */
    public function getRoomRate()
    {
        return $this->RoomRate;
    }
    /**
     * Set RoomRate value
     * @param float $roomRate
     * @return \SabrePaymentGateway\StructType\RoomStayType
     */
    public function setRoomRate($roomRate = null)
    {
        // validation for constraint: float
        if (!is_null($roomRate) && !(is_float($roomRate) || is_numeric($roomRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($roomRate, true), gettype($roomRate)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($roomRate) && mb_strlen(mb_substr($roomRate, false !== mb_strpos($roomRate, '.') ? mb_strpos($roomRate, '.') + 1 : mb_strlen($roomRate))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($roomRate, true), mb_strlen(mb_substr($roomRate, mb_strpos($roomRate, '.') + 1))), __LINE__);
        }
        $this->RoomRate = $roomRate;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SabrePaymentGateway\StructType\RoomStayType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get LengthOfStay value
     * @return int|null
     */
    public function getLengthOfStay()
    {
        return $this->LengthOfStay;
    }
    /**
     * Set LengthOfStay value
     * @param int $lengthOfStay
     * @return \SabrePaymentGateway\StructType\RoomStayType
     */
    public function setLengthOfStay($lengthOfStay = null)
    {
        // validation for constraint: int
        if (!is_null($lengthOfStay) && !(is_int($lengthOfStay) || ctype_digit($lengthOfStay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lengthOfStay, true), gettype($lengthOfStay)), __LINE__);
        }
        $this->LengthOfStay = $lengthOfStay;
        return $this;
    }
    /**
     * Get GuestsCount value
     * @return int|null
     */
    public function getGuestsCount()
    {
        return $this->GuestsCount;
    }
    /**
     * Set GuestsCount value
     * @param int $guestsCount
     * @return \SabrePaymentGateway\StructType\RoomStayType
     */
    public function setGuestsCount($guestsCount = null)
    {
        // validation for constraint: int
        if (!is_null($guestsCount) && !(is_int($guestsCount) || ctype_digit($guestsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($guestsCount, true), gettype($guestsCount)), __LINE__);
        }
        $this->GuestsCount = $guestsCount;
        return $this;
    }
}
