<?php

namespace SabrePaymentGateway\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Pickup StructType
 * @subpackage Structs
 */
class Pickup extends AbstractStructBase
{
    /**
     * The PickupDateTime
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PickupDateTime;
    /**
     * The PickupAddress
     * @var \SabrePaymentGateway\StructType\AddressType
     */
    public $PickupAddress;
    /**
     * Constructor method for Pickup
     * @uses Pickup::setPickupDateTime()
     * @uses Pickup::setPickupAddress()
     * @param string $pickupDateTime
     * @param \SabrePaymentGateway\StructType\AddressType $pickupAddress
     */
    public function __construct($pickupDateTime = null, \SabrePaymentGateway\StructType\AddressType $pickupAddress = null)
    {
        $this
            ->setPickupDateTime($pickupDateTime)
            ->setPickupAddress($pickupAddress);
    }
    /**
     * Get PickupDateTime value
     * @return string
     */
    public function getPickupDateTime()
    {
        return $this->PickupDateTime;
    }
    /**
     * Set PickupDateTime value
     * @param string $pickupDateTime
     * @return \SabrePaymentGateway\StructType\Pickup
     */
    public function setPickupDateTime($pickupDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($pickupDateTime) && !is_string($pickupDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pickupDateTime, true), gettype($pickupDateTime)), __LINE__);
        }
        $this->PickupDateTime = $pickupDateTime;
        return $this;
    }
    /**
     * Get PickupAddress value
     * @return \SabrePaymentGateway\StructType\AddressType|null
     */
    public function getPickupAddress()
    {
        return $this->PickupAddress;
    }
    /**
     * Set PickupAddress value
     * @param \SabrePaymentGateway\StructType\AddressType $pickupAddress
     * @return \SabrePaymentGateway\StructType\Pickup
     */
    public function setPickupAddress(\SabrePaymentGateway\StructType\AddressType $pickupAddress = null)
    {
        $this->PickupAddress = $pickupAddress;
        return $this;
    }
}
